/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.opentsdb.core.AppendDataPoints;
import net.opentsdb.core.BatchedDataPoints;
import net.opentsdb.core.CompactionQueue;
import net.opentsdb.core.Const;
import net.opentsdb.core.IncomingDataPoints;
import net.opentsdb.core.Internal;
import net.opentsdb.core.Query;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.Tags;
import net.opentsdb.core.TsdbQuery;
import net.opentsdb.core.WritableDataPoints;
import net.opentsdb.core.WriteableDataPointFilterPlugin;
import net.opentsdb.meta.Annotation;
import net.opentsdb.meta.MetaDataCache;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.query.expression.ExpressionFactory;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.search.SearchPlugin;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.stats.Histogram;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.tools.StartupPlugin;
import net.opentsdb.tree.TreeBuilder;
import net.opentsdb.tsd.RTPublisher;
import net.opentsdb.tsd.StorageExceptionHandler;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.uid.UniqueIdFilterPlugin;
import net.opentsdb.utils.DateTime;
import net.opentsdb.utils.PluginLoader;
import net.opentsdb.utils.Threads;
import org.hbase.async.AppendRequest;
import org.hbase.async.Bytes;
import org.hbase.async.ClientStats;
import org.hbase.async.Config;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TSDB {
    private static final Logger LOG = LoggerFactory.getLogger(TSDB.class);
    static final byte[] FAMILY = new byte[]{116};
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final String METRICS_QUAL = "metrics";
    private static short METRICS_WIDTH = (short)3;
    private static final String TAG_NAME_QUAL = "tagk";
    private static short TAG_NAME_WIDTH = (short)3;
    private static final String TAG_VALUE_QUAL = "tagv";
    private static short TAG_VALUE_WIDTH = (short)3;
    final HBaseClient client;
    final byte[] table;
    final byte[] uidtable;
    final byte[] treetable;
    final byte[] meta_table;
    final UniqueId metrics;
    final UniqueId tag_names;
    final UniqueId tag_values;
    final net.opentsdb.utils.Config config;
    private final HashedWheelTimer timer;
    private final CompactionQueue compactionq;
    private SearchPlugin search = null;
    private StartupPlugin startup = null;
    private RTPublisher rt_publisher = null;
    private MetaDataCache meta_cache = null;
    private StorageExceptionHandler storage_exception_handler = null;
    private WriteableDataPointFilterPlugin ts_filter;
    private UniqueIdFilterPlugin uid_filter;
    private final AtomicLong rejected_dps = new AtomicLong();
    private final AtomicLong rejected_aggregate_dps = new AtomicLong();
    private static final AtomicLong datapoints_added = new AtomicLong();

    public TSDB(HBaseClient client, net.opentsdb.utils.Config config) {
        this.config = config;
        if (client == null) {
            Config async_config;
            if (config.configLocation() != null && !config.configLocation().isEmpty()) {
                try {
                    async_config = new Config(config.configLocation());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read the config file: " + config.configLocation(), e);
                }
            } else {
                async_config = new Config();
            }
            async_config.overrideConfig("hbase.zookeeper.znode.parent", config.getString("tsd.storage.hbase.zk_basedir"));
            async_config.overrideConfig("hbase.zookeeper.quorum", config.getString("tsd.storage.hbase.zk_quorum"));
            this.client = new HBaseClient(async_config);
        } else {
            this.client = client;
        }
        if (config.hasProperty("tsd.storage.uid.width.metric")) {
            METRICS_WIDTH = config.getShort("tsd.storage.uid.width.metric");
        }
        if (config.hasProperty("tsd.storage.uid.width.tagk")) {
            TAG_NAME_WIDTH = config.getShort("tsd.storage.uid.width.tagk");
        }
        if (config.hasProperty("tsd.storage.uid.width.tagv")) {
            TAG_VALUE_WIDTH = config.getShort("tsd.storage.uid.width.tagv");
        }
        if (config.hasProperty("tsd.storage.max_tags")) {
            Const.setMaxNumTags(config.getShort("tsd.storage.max_tags"));
        }
        if (config.hasProperty("tsd.storage.salt.buckets")) {
            Const.setSaltBuckets(config.getInt("tsd.storage.salt.buckets"));
        }
        if (config.hasProperty("tsd.storage.salt.width")) {
            Const.setSaltWidth(config.getInt("tsd.storage.salt.width"));
        }
        this.table = config.getString("tsd.storage.hbase.data_table").getBytes(CHARSET);
        this.uidtable = config.getString("tsd.storage.hbase.uid_table").getBytes(CHARSET);
        this.treetable = config.getString("tsd.storage.hbase.tree_table").getBytes(CHARSET);
        this.meta_table = config.getString("tsd.storage.hbase.meta_table").getBytes(CHARSET);
        this.metrics = config.getBoolean("tsd.core.uid.random_metrics") ? new UniqueId(this, this.uidtable, METRICS_QUAL, (int)METRICS_WIDTH, true) : new UniqueId(this, this.uidtable, METRICS_QUAL, (int)METRICS_WIDTH, false);
        this.tag_names = new UniqueId(this, this.uidtable, TAG_NAME_QUAL, (int)TAG_NAME_WIDTH, false);
        this.tag_values = new UniqueId(this, this.uidtable, TAG_VALUE_QUAL, (int)TAG_VALUE_WIDTH, false);
        this.compactionq = new CompactionQueue(this);
        if (config.hasProperty("tsd.core.timezone")) {
            DateTime.setDefaultTimezone(config.getString("tsd.core.timezone"));
        }
        this.timer = Threads.newTimer("TSDB Timer");
        QueryStats.setEnableDuplicates(config.getBoolean("tsd.query.allow_simultaneous_duplicates"));
        if (config.getBoolean("tsd.core.preload_uid_cache")) {
            Bytes.ByteMap uid_cache_map = new Bytes.ByteMap();
            uid_cache_map.put((Object)METRICS_QUAL.getBytes(CHARSET), (Object)this.metrics);
            uid_cache_map.put((Object)TAG_NAME_QUAL.getBytes(CHARSET), (Object)this.tag_names);
            uid_cache_map.put((Object)TAG_VALUE_QUAL.getBytes(CHARSET), (Object)this.tag_values);
            UniqueId.preloadUidCache(this, (Bytes.ByteMap<UniqueId>)uid_cache_map);
        }
        if (config.getString("tsd.core.tag.allow_specialchars") != null) {
            Tags.setAllowSpecialChars(config.getString("tsd.core.tag.allow_specialchars"));
        }
        ExpressionFactory.addTSDBFunctions(this);
        StatsCollector.setGlobalTags(config);
        LOG.debug(config.dumpConfiguration());
    }

    public TSDB(net.opentsdb.utils.Config config) {
        this(null, config);
    }

    public static byte[] FAMILY() {
        return FAMILY;
    }

    public static void loadPluginPath(String plugin_path) {
        if (plugin_path != null && !plugin_path.isEmpty()) {
            try {
                PluginLoader.loadJARs(plugin_path);
            }
            catch (Exception e) {
                LOG.error("Error loading plugins from plugin path: " + plugin_path, (Throwable)e);
                throw new RuntimeException("Error loading plugins from plugin path: " + plugin_path, e);
            }
        }
    }

    public void initializePlugins(boolean init_rpcs) {
        String plugin_path = this.config.getString("tsd.core.plugin_path");
        TSDB.loadPluginPath(plugin_path);
        try {
            TagVFilter.initializeFilterMap(this);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to instantiate filters", e);
        }
        if (this.config.getBoolean("tsd.search.enable")) {
            this.search = PluginLoader.loadSpecificPlugin(this.config.getString("tsd.search.plugin"), SearchPlugin.class);
            if (this.search == null) {
                throw new IllegalArgumentException("Unable to locate search plugin: " + this.config.getString("tsd.search.plugin"));
            }
            try {
                this.search.initialize(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize search plugin", e);
            }
            LOG.info("Successfully initialized search plugin [" + this.search.getClass().getCanonicalName() + "] version: " + this.search.version());
        } else {
            this.search = null;
        }
        if (this.config.getBoolean("tsd.rtpublisher.enable")) {
            this.rt_publisher = PluginLoader.loadSpecificPlugin(this.config.getString("tsd.rtpublisher.plugin"), RTPublisher.class);
            if (this.rt_publisher == null) {
                throw new IllegalArgumentException("Unable to locate real time publisher plugin: " + this.config.getString("tsd.rtpublisher.plugin"));
            }
            try {
                this.rt_publisher.initialize(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize real time publisher plugin", e);
            }
            LOG.info("Successfully initialized real time publisher plugin [" + this.rt_publisher.getClass().getCanonicalName() + "] version: " + this.rt_publisher.version());
        } else {
            this.rt_publisher = null;
        }
        if (this.config.getBoolean("tsd.core.meta.cache.enable")) {
            this.meta_cache = PluginLoader.loadSpecificPlugin(this.config.getString("tsd.core.meta.cache.plugin"), MetaDataCache.class);
            if (this.meta_cache == null) {
                throw new IllegalArgumentException("Unable to locate meta cache plugin: " + this.config.getString("tsd.core.meta.cache.plugin"));
            }
            try {
                this.meta_cache.initialize(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize meta cache plugin", e);
            }
            LOG.info("Successfully initialized meta cache plugin [" + this.meta_cache.getClass().getCanonicalName() + "] version: " + this.meta_cache.version());
        }
        if (this.config.getBoolean("tsd.core.storage_exception_handler.enable")) {
            this.storage_exception_handler = PluginLoader.loadSpecificPlugin(this.config.getString("tsd.core.storage_exception_handler.plugin"), StorageExceptionHandler.class);
            if (this.storage_exception_handler == null) {
                throw new IllegalArgumentException("Unable to locate storage exception handler plugin: " + this.config.getString("tsd.core.storage_exception_handler.plugin"));
            }
            try {
                this.storage_exception_handler.initialize(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize storage exception handler plugin", e);
            }
            LOG.info("Successfully initialized storage exception handler plugin [" + this.storage_exception_handler.getClass().getCanonicalName() + "] version: " + this.storage_exception_handler.version());
        }
        if (this.config.getBoolean("tsd.timeseriesfilter.enable")) {
            this.ts_filter = PluginLoader.loadSpecificPlugin(this.config.getString("tsd.timeseriesfilter.plugin"), WriteableDataPointFilterPlugin.class);
            if (this.ts_filter == null) {
                throw new IllegalArgumentException("Unable to locate time series filter plugin plugin: " + this.config.getString("tsd.timeseriesfilter.plugin"));
            }
            try {
                this.ts_filter.initialize(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize time series filter plugin", e);
            }
            LOG.info("Successfully initialized time series filter plugin [" + this.ts_filter.getClass().getCanonicalName() + "] version: " + this.ts_filter.version());
        }
        if (this.config.getBoolean("tsd.uidfilter.enable")) {
            this.uid_filter = PluginLoader.loadSpecificPlugin(this.config.getString("tsd.uidfilter.plugin"), UniqueIdFilterPlugin.class);
            if (this.uid_filter == null) {
                throw new IllegalArgumentException("Unable to locate UID filter plugin plugin: " + this.config.getString("tsd.uidfilter.plugin"));
            }
            try {
                this.uid_filter.initialize(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize UID filter plugin", e);
            }
            LOG.info("Successfully initialized UID filter plugin [" + this.uid_filter.getClass().getCanonicalName() + "] version: " + this.uid_filter.version());
        }
    }

    public final HBaseClient getClient() {
        return this.client;
    }

    public final void setStartupPlugin(StartupPlugin plugin) {
        this.startup = plugin;
    }

    public final StartupPlugin getStartupPlugin() {
        return this.startup;
    }

    public final net.opentsdb.utils.Config getConfig() {
        return this.config;
    }

    public final StorageExceptionHandler getStorageExceptionHandler() {
        return this.storage_exception_handler;
    }

    public WriteableDataPointFilterPlugin getTSfilter() {
        return this.ts_filter;
    }

    public UniqueIdFilterPlugin getUidFilter() {
        return this.uid_filter;
    }

    public Deferred<String> getUidName(UniqueId.UniqueIdType type, byte[] uid) {
        if (uid == null) {
            throw new IllegalArgumentException("Missing UID");
        }
        switch (type) {
            case METRIC: {
                return this.metrics.getNameAsync(uid);
            }
            case TAGK: {
                return this.tag_names.getNameAsync(uid);
            }
            case TAGV: {
                return this.tag_values.getNameAsync(uid);
            }
        }
        throw new IllegalArgumentException("Unrecognized UID type");
    }

    public byte[] getUID(UniqueId.UniqueIdType type, String name) {
        try {
            return (byte[])this.getUIDAsync(type, name).join();
        }
        catch (NoSuchUniqueName e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Deferred<byte[]> getUIDAsync(UniqueId.UniqueIdType type, String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Missing UID name");
        }
        switch (type) {
            case METRIC: {
                return this.metrics.getIdAsync(name);
            }
            case TAGK: {
                return this.tag_names.getIdAsync(name);
            }
            case TAGV: {
                return this.tag_values.getIdAsync(name);
            }
        }
        throw new IllegalArgumentException("Unrecognized UID type");
    }

    public Deferred<ArrayList<Object>> checkNecessaryTablesExist() {
        ArrayList<Deferred> checks = new ArrayList<Deferred>(2);
        checks.add(this.client.ensureTableExists(this.config.getString("tsd.storage.hbase.data_table")));
        checks.add(this.client.ensureTableExists(this.config.getString("tsd.storage.hbase.uid_table")));
        if (this.config.enable_tree_processing()) {
            checks.add(this.client.ensureTableExists(this.config.getString("tsd.storage.hbase.tree_table")));
        }
        if (this.config.enable_realtime_ts() || this.config.enable_realtime_uid() || this.config.enable_tsuid_incrementing()) {
            checks.add(this.client.ensureTableExists(this.config.getString("tsd.storage.hbase.meta_table")));
        }
        return Deferred.group(checks);
    }

    public long uidCacheHits() {
        return this.metrics.cacheHits() + this.tag_names.cacheHits() + this.tag_values.cacheHits();
    }

    public long uidCacheMisses() {
        return this.metrics.cacheMisses() + this.tag_names.cacheMisses() + this.tag_values.cacheMisses();
    }

    public long uidCacheSize() {
        return this.metrics.cacheSize() + this.tag_names.cacheSize() + this.tag_values.cacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStats(StatsCollector collector) {
        byte[][] kinds = new byte[][]{METRICS_QUAL.getBytes(CHARSET), TAG_NAME_QUAL.getBytes(CHARSET), TAG_VALUE_QUAL.getBytes(CHARSET)};
        try {
            Map used_uids = (Map)UniqueId.getUsedUIDs(this, kinds).joinUninterruptibly();
            TSDB.collectUidStats(this.metrics, collector);
            if (this.config.getBoolean("tsd.core.uid.random_metrics")) {
                collector.record("uid.ids-used", 0L, "kind=metrics");
                collector.record("uid.ids-available", 0L, "kind=metrics");
            } else {
                collector.record("uid.ids-used", (Number)used_uids.get(METRICS_QUAL), "kind=metrics");
                collector.record("uid.ids-available", Internal.getMaxUnsignedValueOnBytes(this.metrics.width()) - (Long)used_uids.get(METRICS_QUAL), "kind=metrics");
            }
            TSDB.collectUidStats(this.tag_names, collector);
            collector.record("uid.ids-used", (Number)used_uids.get(TAG_NAME_QUAL), "kind=tagk");
            collector.record("uid.ids-available", Internal.getMaxUnsignedValueOnBytes(this.tag_names.width()) - (Long)used_uids.get(TAG_NAME_QUAL), "kind=tagk");
            TSDB.collectUidStats(this.tag_values, collector);
            collector.record("uid.ids-used", (Number)used_uids.get(TAG_VALUE_QUAL), "kind=tagv");
            collector.record("uid.ids-available", Internal.getMaxUnsignedValueOnBytes(this.tag_values.width()) - (Long)used_uids.get(TAG_VALUE_QUAL), "kind=tagv");
        }
        catch (Exception e) {
            throw new RuntimeException("Shouldn't be here", e);
        }
        collector.record("uid.filter.rejected", this.rejected_dps.get(), "kind=raw");
        collector.record("uid.filter.rejected", this.rejected_aggregate_dps.get(), "kind=aggregate");
        Runtime runtime = Runtime.getRuntime();
        collector.record("jvm.ramfree", runtime.freeMemory());
        collector.record("jvm.ramused", runtime.totalMemory());
        collector.addExtraTag("class", "IncomingDataPoints");
        try {
            collector.record("hbase.latency", IncomingDataPoints.putlatency, "method=put");
        }
        finally {
            collector.clearExtraTag("class");
        }
        collector.addExtraTag("class", "TSDB");
        try {
            collector.record("datapoints.added", datapoints_added, "type=all");
        }
        finally {
            collector.clearExtraTag("class");
        }
        collector.addExtraTag("class", "TsdbQuery");
        try {
            collector.record("hbase.latency", TsdbQuery.scanlatency, "method=scan");
        }
        finally {
            collector.clearExtraTag("class");
        }
        ClientStats stats = this.client.stats();
        collector.record("hbase.root_lookups", stats.rootLookups());
        collector.record("hbase.meta_lookups", stats.uncontendedMetaLookups(), "type=uncontended");
        collector.record("hbase.meta_lookups", stats.contendedMetaLookups(), "type=contended");
        collector.record("hbase.rpcs", stats.atomicIncrements(), "type=increment");
        collector.record("hbase.rpcs", stats.deletes(), "type=delete");
        collector.record("hbase.rpcs", stats.gets(), "type=get");
        collector.record("hbase.rpcs", stats.puts(), "type=put");
        collector.record("hbase.rpcs", stats.appends(), "type=append");
        collector.record("hbase.rpcs", stats.rowLocks(), "type=rowLock");
        collector.record("hbase.rpcs", stats.scannersOpened(), "type=openScanner");
        collector.record("hbase.rpcs", stats.scans(), "type=scan");
        collector.record("hbase.rpcs.batched", stats.numBatchedRpcSent());
        collector.record("hbase.flushes", stats.flushes());
        collector.record("hbase.connections.created", stats.connectionsCreated());
        collector.record("hbase.connections.idle_closed", stats.idleConnectionsClosed());
        collector.record("hbase.nsre", stats.noSuchRegionExceptions());
        collector.record("hbase.nsre.rpcs_delayed", stats.numRpcDelayedDueToNSRE());
        collector.record("hbase.region_clients.open", stats.regionClients());
        collector.record("hbase.region_clients.idle_closed", stats.idleConnectionsClosed());
        this.compactionq.collectStats(collector);
        if (this.startup != null) {
            try {
                collector.addExtraTag("plugin", "startup");
                this.startup.collectStats(collector);
            }
            finally {
                collector.clearExtraTag("plugin");
            }
        }
        if (this.rt_publisher != null) {
            try {
                collector.addExtraTag("plugin", "publish");
                this.rt_publisher.collectStats(collector);
            }
            finally {
                collector.clearExtraTag("plugin");
            }
        }
        if (this.search != null) {
            try {
                collector.addExtraTag("plugin", "search");
                this.search.collectStats(collector);
            }
            finally {
                collector.clearExtraTag("plugin");
            }
        }
        if (this.storage_exception_handler != null) {
            try {
                collector.addExtraTag("plugin", "storageExceptionHandler");
                this.storage_exception_handler.collectStats(collector);
            }
            finally {
                collector.clearExtraTag("plugin");
            }
        }
        if (this.ts_filter != null) {
            try {
                collector.addExtraTag("plugin", "timeseriesFilter");
                this.ts_filter.collectStats(collector);
            }
            finally {
                collector.clearExtraTag("plugin");
            }
        }
        if (this.uid_filter != null) {
            try {
                collector.addExtraTag("plugin", "uidFilter");
                this.uid_filter.collectStats(collector);
            }
            finally {
                collector.clearExtraTag("plugin");
            }
        }
    }

    public Histogram getPutLatencyHistogram() {
        return IncomingDataPoints.putlatency;
    }

    public Histogram getScanLatencyHistogram() {
        return TsdbQuery.scanlatency;
    }

    private static void collectUidStats(UniqueId uid, StatsCollector collector) {
        collector.record("uid.cache-hit", uid.cacheHits(), "kind=" + uid.kind());
        collector.record("uid.cache-miss", uid.cacheMisses(), "kind=" + uid.kind());
        collector.record("uid.cache-size", uid.cacheSize(), "kind=" + uid.kind());
        collector.record("uid.random-collisions", uid.randomIdCollisions(), "kind=" + uid.kind());
        collector.record("uid.rejected-assignments", uid.rejectedAssignments(), "kind=" + uid.kind());
    }

    public static short metrics_width() {
        return METRICS_WIDTH;
    }

    public static short tagk_width() {
        return TAG_NAME_WIDTH;
    }

    public static short tagv_width() {
        return TAG_VALUE_WIDTH;
    }

    public Query newQuery() {
        return new TsdbQuery(this);
    }

    public WritableDataPoints newDataPoints() {
        return new IncomingDataPoints(this);
    }

    public WritableDataPoints newBatch(String metric, Map<String, String> tags) {
        return new BatchedDataPoints(this, metric, tags);
    }

    public Deferred<Object> addPoint(String metric, long timestamp, long value, Map<String, String> tags) {
        byte[] v = -128L <= value && value <= 127L ? new byte[]{(byte)value} : (-32768L <= value && value <= 32767L ? Bytes.fromShort((short)((short)value)) : (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE ? Bytes.fromInt((int)((int)value)) : Bytes.fromLong((long)value)));
        short flags = (short)(v.length - 1);
        return this.addPointInternal(metric, timestamp, v, tags, flags);
    }

    public Deferred<Object> addPoint(String metric, long timestamp, double value, Map<String, String> tags) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("value is NaN or Infinite: " + value + " for metric=" + metric + " timestamp=" + timestamp);
        }
        int flags = 15;
        return this.addPointInternal(metric, timestamp, Bytes.fromLong((long)Double.doubleToRawLongBits(value)), tags, (short)15);
    }

    public Deferred<Object> addPoint(String metric, long timestamp, float value, Map<String, String> tags) {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw new IllegalArgumentException("value is NaN or Infinite: " + value + " for metric=" + metric + " timestamp=" + timestamp);
        }
        int flags = 11;
        return this.addPointInternal(metric, timestamp, Bytes.fromInt((int)Float.floatToRawIntBits(value)), tags, (short)11);
    }

    Deferred<Object> addPointInternal(final String metric, final long timestamp, final byte[] value, final Map<String, String> tags, final short flags) {
        final class WriteCB
        implements Callback<Deferred<Object>, Boolean> {
            WriteCB() {
            }

            public Deferred<Object> call(Boolean allowed) throws Exception {
                if (!allowed.booleanValue()) {
                    TSDB.this.rejected_dps.incrementAndGet();
                    return Deferred.fromResult(null);
                }
                Bytes.setInt((byte[])row, (int)((int)base_time), (int)(TSDB.this.metrics.width() + Const.SALT_WIDTH()));
                RowKey.prefixKeyWithSalt(row);
                Deferred result = null;
                if (TSDB.this.config.enable_appends()) {
                    AppendDataPoints kv = new AppendDataPoints(qualifier, value);
                    AppendRequest point = new AppendRequest(TSDB.this.table, row, FAMILY, AppendDataPoints.APPEND_COLUMN_QUALIFIER, kv.getBytes());
                    result = TSDB.this.client.append(point);
                } else {
                    TSDB.this.scheduleForCompaction(row, (int)base_time);
                    PutRequest point = new PutRequest(TSDB.this.table, row, FAMILY, qualifier, value);
                    result = TSDB.this.client.put(point);
                }
                datapoints_added.incrementAndGet();
                if (!(TSDB.this.config.enable_realtime_ts() || TSDB.this.config.enable_tsuid_incrementing() || TSDB.this.config.enable_tsuid_tracking() || TSDB.this.rt_publisher != null)) {
                    return result;
                }
                byte[] tsuid = UniqueId.getTSUIDFromKey(row, METRICS_WIDTH, (short)4);
                if (TSDB.this.meta_cache != null) {
                    TSDB.this.meta_cache.increment(tsuid);
                } else if (TSDB.this.config.enable_tsuid_tracking()) {
                    if (TSDB.this.config.enable_realtime_ts()) {
                        if (TSDB.this.config.enable_tsuid_incrementing()) {
                            TSMeta.incrementAndGetCounter(TSDB.this, tsuid);
                        } else {
                            TSMeta.storeIfNecessary(TSDB.this, tsuid);
                        }
                    } else {
                        PutRequest tracking = new PutRequest(TSDB.this.meta_table, tsuid, TSMeta.FAMILY(), TSMeta.COUNTER_QUALIFIER(), Bytes.fromLong((long)1L));
                        TSDB.this.client.put(tracking);
                    }
                }
                if (TSDB.this.rt_publisher != null) {
                    TSDB.this.rt_publisher.sinkDataPoint(metric, timestamp, value, tags, tsuid, flags);
                }
                return result;
            }

            public String toString() {
                return "addPointInternal Write Callback";
            }
        }
        if (timestamp < 0L || (timestamp & 0xFFFFFFFF00000000L) != 0L && timestamp > 9999999999999L) {
            throw new IllegalArgumentException((timestamp < 0L ? "negative " : "bad") + " timestamp=" + timestamp + " when trying to add value=" + Arrays.toString(value) + '/' + flags + " to metric=" + metric + ", tags=" + tags);
        }
        IncomingDataPoints.checkMetricAndTags(metric, tags);
        final byte[] row = IncomingDataPoints.rowKeyTemplate(this, metric, tags);
        final byte[] qualifier = Internal.buildQualifier(timestamp, flags);
        final long base_time = (timestamp & 0xFFFFFFFF00000000L) != 0L ? timestamp / 1000L - timestamp / 1000L % 3600L : timestamp - timestamp % 3600L;
        if (this.ts_filter != null && this.ts_filter.filterDataPoints()) {
            return this.ts_filter.allowDataPoint(metric, timestamp, value, tags, flags).addCallbackDeferring((Callback)new WriteCB());
        }
        return Deferred.fromResult((Object)true).addCallbackDeferring((Callback)new WriteCB());
    }

    public Deferred<Object> flush() throws HBaseException {
        final class HClientFlush
        implements Callback<Object, ArrayList<Object>> {
            HClientFlush() {
            }

            public Object call(ArrayList<Object> args) {
                return TSDB.this.client.flush();
            }

            public String toString() {
                return "flush HBase client";
            }
        }
        return this.config.enable_compactions() && this.compactionq != null ? this.compactionq.flush().addCallback((Callback)new HClientFlush()) : this.client.flush();
    }

    public Deferred<Object> shutdown() {
        ArrayList<Object> deferreds = new ArrayList<Object>();
        if (this.config.enable_compactions()) {
            LOG.info("Flushing compaction queue");
            final class CompactCB
            implements Callback<Object, ArrayList<Object>> {
                CompactCB() {
                }

                public Object call(ArrayList<Object> compactions) throws Exception {
                    return null;
                }
            }
            deferreds.add(this.compactionq.flush().addCallback((Callback)new CompactCB()));
        }
        if (this.startup != null) {
            LOG.info("Shutting down startup plugin: " + this.startup.getClass().getCanonicalName());
            deferreds.add(this.startup.shutdown());
        }
        if (this.search != null) {
            LOG.info("Shutting down search plugin: " + this.search.getClass().getCanonicalName());
            deferreds.add(this.search.shutdown());
        }
        if (this.rt_publisher != null) {
            LOG.info("Shutting down RT plugin: " + this.rt_publisher.getClass().getCanonicalName());
            deferreds.add(this.rt_publisher.shutdown());
        }
        if (this.meta_cache != null) {
            LOG.info("Shutting down meta cache plugin: " + this.meta_cache.getClass().getCanonicalName());
            deferreds.add(this.meta_cache.shutdown());
        }
        if (this.storage_exception_handler != null) {
            LOG.info("Shutting down storage exception handler plugin: " + this.storage_exception_handler.getClass().getCanonicalName());
            deferreds.add(this.storage_exception_handler.shutdown());
        }
        if (this.ts_filter != null) {
            LOG.info("Shutting down time series filter plugin: " + this.ts_filter.getClass().getCanonicalName());
            deferreds.add(this.ts_filter.shutdown());
        }
        if (this.uid_filter != null) {
            LOG.info("Shutting down UID filter plugin: " + this.uid_filter.getClass().getCanonicalName());
            deferreds.add(this.uid_filter.shutdown());
        }
        final class HClientShutdown
        implements Callback<Deferred<Object>, ArrayList<Object>> {
            HClientShutdown() {
            }

            public Deferred<Object> call(ArrayList<Object> args) {
                if (TSDB.this.storage_exception_handler != null) {
                    final class SEHShutdown
                    implements Callback<Object, Object> {
                        SEHShutdown() {
                        }

                        public Object call(Object result) throws Exception {
                            if (result instanceof Exception) {
                                LOG.error("Shutdown of the HBase client failed", (Throwable)((Exception)result));
                            }
                            LOG.info("Shutting down storage exception handler plugin: " + TSDB.this.storage_exception_handler.getClass().getCanonicalName());
                            final class FinalShutdown
                            implements Callback<Object, Object> {
                                FinalShutdown() {
                                }

                                public Object call(Object result) throws Exception {
                                    Set timeouts;
                                    if (result instanceof Exception) {
                                        LOG.error("A previous shutdown failed", (Throwable)((Exception)result));
                                    }
                                    if ((timeouts = TSDB.this.timer.stop()).size() > 0) {
                                        LOG.warn("There were " + timeouts.size() + " timer tasks queued");
                                    }
                                    LOG.info("Completed shutting down the TSDB");
                                    return Deferred.fromResult(null);
                                }
                            }
                            return TSDB.this.storage_exception_handler.shutdown().addBoth((Callback)new FinalShutdown());
                        }

                        public String toString() {
                            return "SEHShutdown";
                        }
                    }
                    return TSDB.this.client.shutdown().addBoth((Callback)new SEHShutdown());
                }
                return TSDB.this.client.shutdown().addBoth((Callback)new FinalShutdown());
            }

            public String toString() {
                return "shutdown HBase client";
            }
        }
        final class ShutdownErrback
        implements Callback<Object, Exception> {
            ShutdownErrback() {
            }

            public Object call(Exception e) {
                Logger LOG = LoggerFactory.getLogger(ShutdownErrback.class);
                if (e instanceof DeferredGroupException) {
                    DeferredGroupException ge = (DeferredGroupException)e;
                    for (Object r : ge.results()) {
                        if (!(r instanceof Exception)) continue;
                        LOG.error("Failed to shutdown the TSD", (Throwable)((Exception)r));
                    }
                } else {
                    LOG.error("Failed to shutdown the TSD", (Throwable)e);
                }
                return new HClientShutdown().call(null);
            }

            public String toString() {
                return "shutdown HBase client after error";
            }
        }
        return deferreds.size() > 0 ? Deferred.group(deferreds).addCallbackDeferring((Callback)new HClientShutdown()).addErrback((Callback)new ShutdownErrback()) : new HClientShutdown().call(null);
    }

    public List<String> suggestMetrics(String search) {
        return this.metrics.suggest(search);
    }

    public List<String> suggestMetrics(String search, int max_results) {
        return this.metrics.suggest(search, max_results);
    }

    public List<String> suggestTagNames(String search) {
        return this.tag_names.suggest(search);
    }

    public List<String> suggestTagNames(String search, int max_results) {
        return this.tag_names.suggest(search, max_results);
    }

    public List<String> suggestTagValues(String search) {
        return this.tag_values.suggest(search);
    }

    public List<String> suggestTagValues(String search, int max_results) {
        return this.tag_values.suggest(search, max_results);
    }

    public void dropCaches() {
        this.metrics.dropCaches();
        this.tag_names.dropCaches();
        this.tag_values.dropCaches();
    }

    public byte[] assignUid(String type, String name) {
        Tags.validateString(type, name);
        if (type.toLowerCase().equals("metric")) {
            try {
                byte[] uid = this.metrics.getId(name);
                throw new IllegalArgumentException("Name already exists with UID: " + UniqueId.uidToString(uid));
            }
            catch (NoSuchUniqueName nsue) {
                return this.metrics.getOrCreateId(name);
            }
        }
        if (type.toLowerCase().equals(TAG_NAME_QUAL)) {
            try {
                byte[] uid = this.tag_names.getId(name);
                throw new IllegalArgumentException("Name already exists with UID: " + UniqueId.uidToString(uid));
            }
            catch (NoSuchUniqueName nsue) {
                return this.tag_names.getOrCreateId(name);
            }
        }
        if (type.toLowerCase().equals(TAG_VALUE_QUAL)) {
            try {
                byte[] uid = this.tag_values.getId(name);
                throw new IllegalArgumentException("Name already exists with UID: " + UniqueId.uidToString(uid));
            }
            catch (NoSuchUniqueName nsue) {
                return this.tag_values.getOrCreateId(name);
            }
        }
        LOG.warn("Unknown type name: " + type);
        throw new IllegalArgumentException("Unknown type name");
    }

    public Deferred<Object> deleteUidAsync(String type, String name) {
        UniqueId.UniqueIdType uid_type = UniqueId.stringToUniqueIdType(type);
        switch (uid_type) {
            case METRIC: {
                return this.metrics.deleteAsync(name);
            }
            case TAGK: {
                return this.tag_names.deleteAsync(name);
            }
            case TAGV: {
                return this.tag_values.deleteAsync(name);
            }
        }
        throw new IllegalArgumentException("Unrecognized UID type: " + (Object)((Object)uid_type));
    }

    public void renameUid(String type, String oldname, String newname) {
        Tags.validateString(type, oldname);
        Tags.validateString(type, newname);
        if (type.toLowerCase().equals("metric")) {
            try {
                this.metrics.getId(oldname);
                this.metrics.rename(oldname, newname);
            }
            catch (NoSuchUniqueName nsue) {
                throw new IllegalArgumentException("Name(\"" + oldname + "\") does not exist");
            }
        } else if (type.toLowerCase().equals(TAG_NAME_QUAL)) {
            try {
                this.tag_names.getId(oldname);
                this.tag_names.rename(oldname, newname);
            }
            catch (NoSuchUniqueName nsue) {
                throw new IllegalArgumentException("Name(\"" + oldname + "\") does not exist");
            }
        } else if (type.toLowerCase().equals(TAG_VALUE_QUAL)) {
            try {
                this.tag_values.getId(oldname);
                this.tag_values.rename(oldname, newname);
            }
            catch (NoSuchUniqueName nsue) {
                throw new IllegalArgumentException("Name(\"" + oldname + "\") does not exist");
            }
        } else {
            LOG.warn("Unknown type name: " + type);
            throw new IllegalArgumentException("Unknown type name");
        }
    }

    public byte[] uidTable() {
        return this.uidtable;
    }

    public byte[] dataTable() {
        return this.table;
    }

    public byte[] treeTable() {
        return this.treetable;
    }

    public byte[] metaTable() {
        return this.meta_table;
    }

    public void indexTSMeta(TSMeta meta) {
        if (this.search != null) {
            this.search.indexTSMeta(meta).addErrback((Callback)new PluginError());
        }
    }

    public void deleteTSMeta(String tsuid) {
        if (this.search != null) {
            this.search.deleteTSMeta(tsuid).addErrback((Callback)new PluginError());
        }
    }

    public void indexUIDMeta(UIDMeta meta) {
        if (this.search != null) {
            this.search.indexUIDMeta(meta).addErrback((Callback)new PluginError());
        }
    }

    public void deleteUIDMeta(UIDMeta meta) {
        if (this.search != null) {
            this.search.deleteUIDMeta(meta).addErrback((Callback)new PluginError());
        }
    }

    public void indexAnnotation(Annotation note) {
        if (this.search != null) {
            this.search.indexAnnotation(note).addErrback((Callback)new PluginError());
        }
        if (this.rt_publisher != null) {
            this.rt_publisher.publishAnnotation(note);
        }
    }

    public void deleteAnnotation(Annotation note) {
        if (this.search != null) {
            this.search.deleteAnnotation(note).addErrback((Callback)new PluginError());
        }
    }

    public Deferred<Boolean> processTSMetaThroughTrees(TSMeta meta) {
        if (this.config.enable_tree_processing()) {
            return TreeBuilder.processAllTrees(this, meta);
        }
        return Deferred.fromResult((Object)false);
    }

    public Deferred<SearchQuery> executeSearch(SearchQuery query) {
        if (this.search == null) {
            throw new IllegalStateException("Searching has not been enabled on this TSD");
        }
        return this.search.executeQuery(query);
    }

    public void preFetchHBaseMeta() {
        LOG.info("Pre-fetching meta data for all tables");
        long start = System.currentTimeMillis();
        ArrayList<Deferred> deferreds = new ArrayList<Deferred>();
        deferreds.add(this.client.prefetchMeta(this.table));
        deferreds.add(this.client.prefetchMeta(this.uidtable));
        try {
            Deferred.group(deferreds).join();
            LOG.info("Fetched meta data for tables in " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
            return;
        }
        catch (Exception e) {
            LOG.error("Failed to prefetch meta for our tables", (Throwable)e);
        }
    }

    public Timer getTimer() {
        return this.timer;
    }

    final KeyValue compact(ArrayList<KeyValue> row, List<Annotation> annotations) {
        return this.compactionq.compact(row, annotations);
    }

    final void scheduleForCompaction(byte[] row, int base_time) {
        if (this.config.enable_compactions()) {
            this.compactionq.add(row);
        }
    }

    final Deferred<ArrayList<KeyValue>> get(byte[] key) {
        return this.client.get(new GetRequest(this.table, key, FAMILY));
    }

    final Deferred<Object> put(byte[] key, byte[] qualifier, byte[] value) {
        return this.client.put(new PutRequest(this.table, key, FAMILY, qualifier, value));
    }

    final Deferred<Object> delete(byte[] key, byte[][] qualifiers) {
        return this.client.delete(new DeleteRequest(this.table, key, FAMILY, qualifiers));
    }

    final class PluginError
    implements Callback<Object, Exception> {
        PluginError() {
        }

        public Object call(Exception e) throws Exception {
            LOG.error("Exception from Search plugin indexer", (Throwable)e);
            return null;
        }
    }
}

