/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Objects;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.Query;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSSubQuery;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.utils.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class TSQuery {
    private String start;
    private String end;
    private String timezone;
    private HashMap<String, ArrayList<String>> options;
    private boolean padding;
    private boolean no_annotations;
    private boolean with_global_annotations;
    private boolean show_tsuids;
    private ArrayList<TSSubQuery> queries;
    private long start_time;
    private long end_time;
    private boolean ms_resolution;
    private boolean show_query;
    private boolean show_stats;
    private boolean show_summary;
    private boolean delete = false;
    private boolean use_calendar;
    private QueryStats query_stats;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end, this.timezone, this.use_calendar, this.options, this.padding, this.no_annotations, this.with_global_annotations, this.show_tsuids, this.queries, this.ms_resolution});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TSQuery)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TSQuery query = (TSQuery)obj;
        return Objects.equal((Object)this.start, (Object)query.start) && Objects.equal((Object)this.end, (Object)query.end) && Objects.equal((Object)this.timezone, (Object)query.timezone) && Objects.equal((Object)this.use_calendar, (Object)query.use_calendar) && Objects.equal(this.options, query.options) && Objects.equal((Object)this.padding, (Object)query.padding) && Objects.equal((Object)this.no_annotations, (Object)query.no_annotations) && Objects.equal((Object)this.with_global_annotations, (Object)query.with_global_annotations) && Objects.equal((Object)this.show_tsuids, (Object)query.show_tsuids) && Objects.equal(this.queries, query.queries) && Objects.equal((Object)this.ms_resolution, (Object)query.ms_resolution);
    }

    public void validateAndSetQuery() {
        if (this.start == null || this.start.isEmpty()) {
            throw new IllegalArgumentException("Missing start time");
        }
        this.start_time = DateTime.parseDateTimeString(this.start, this.timezone);
        this.end_time = this.end != null && !this.end.isEmpty() ? DateTime.parseDateTimeString(this.end, this.timezone) : System.currentTimeMillis();
        if (this.end_time <= this.start_time) {
            throw new IllegalArgumentException("End time [" + this.end_time + "] must be greater than the start time [" + this.start_time + "]");
        }
        if (this.queries == null || this.queries.isEmpty()) {
            throw new IllegalArgumentException("Missing queries");
        }
        int i = 0;
        for (TSSubQuery sub : this.queries) {
            sub.validateAndSetQuery();
            DownsamplingSpecification ds = sub.downsamplingSpecification();
            if (ds != null && this.timezone != null && !this.timezone.isEmpty() && ds != DownsamplingSpecification.NO_DOWNSAMPLER) {
                TimeZone tz = DateTime.timezones.get(this.timezone);
                if (tz == null) {
                    throw new IllegalArgumentException("The timezone specification could not be found");
                }
                ds.setTimezone(tz);
            }
            if (ds != null && this.use_calendar && ds != DownsamplingSpecification.NO_DOWNSAMPLER) {
                ds.setUseCalendar(true);
            }
            sub.setIndex(i++);
        }
    }

    public Query[] buildQueries(TSDB tsdb) {
        try {
            return (Query[])this.buildQueriesAsync(tsdb).joinUninterruptibly();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public Deferred<Query[]> buildQueriesAsync(TSDB tsdb) {
        final Query[] tsdb_queries = new Query[this.queries.size()];
        ArrayList<Deferred<Object>> deferreds = new ArrayList<Deferred<Object>>(this.queries.size());
        for (int i = 0; i < this.queries.size(); ++i) {
            Query query = tsdb.newQuery();
            deferreds.add(query.configureFromQuery(this, i));
            tsdb_queries[i] = query;
        }
        class GroupFinished
        implements Callback<Query[], ArrayList<Object>> {
            GroupFinished() {
            }

            public Query[] call(ArrayList<Object> deferreds) {
                return tsdb_queries;
            }

            public String toString() {
                return "Query compile group callback";
            }
        }
        return Deferred.group(deferreds).addCallback((Callback)new GroupFinished());
    }

    public String toString() {
        int counter;
        StringBuilder buf = new StringBuilder();
        buf.append("TSQuery(start_time=").append(this.start).append(", end_time=").append(this.end).append(", subQueries[");
        if (this.queries != null && !this.queries.isEmpty()) {
            counter = 0;
            for (TSSubQuery tSSubQuery : this.queries) {
                if (counter > 0) {
                    buf.append(", ");
                }
                buf.append(tSSubQuery);
                ++counter;
            }
        }
        buf.append("] padding=").append(this.padding).append(", no_annotations=").append(this.no_annotations).append(", with_global_annotations=").append(this.with_global_annotations).append(", show_tsuids=").append(this.show_tsuids).append(", ms_resolution=").append(this.ms_resolution).append(", options=[");
        if (this.options != null && !this.options.isEmpty()) {
            counter = 0;
            for (Map.Entry entry : this.options.entrySet()) {
                if (counter > 0) {
                    buf.append(", ");
                }
                buf.append((String)entry.getKey()).append("=[");
                ArrayList values = (ArrayList)entry.getValue();
                for (int i = 0; i < values.size(); ++i) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append((String)values.get(i));
                }
            }
        }
        buf.append("])");
        return buf.toString();
    }

    public long startTime() {
        return this.start_time;
    }

    public long endTime() {
        return this.end_time;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Map<String, ArrayList<String>> getOptions() {
        return this.options;
    }

    public boolean getPadding() {
        return this.padding;
    }

    public boolean getNoAnnotations() {
        return this.no_annotations;
    }

    public boolean getGlobalAnnotations() {
        return this.with_global_annotations;
    }

    public boolean getShowTSUIDs() {
        return this.show_tsuids;
    }

    public List<TSSubQuery> getQueries() {
        return this.queries;
    }

    public boolean getMsResolution() {
        return this.ms_resolution;
    }

    public boolean getShowQuery() {
        return this.show_query;
    }

    public boolean getShowStats() {
        return this.show_stats;
    }

    public boolean getShowSummary() {
        return this.show_summary;
    }

    public boolean getDelete() {
        return this.delete;
    }

    public boolean getUseCalendar() {
        return this.use_calendar;
    }

    @JsonIgnore
    public QueryStats getQueryStats() {
        return this.query_stats;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public void setOptions(HashMap<String, ArrayList<String>> options) {
        this.options = options;
    }

    public void setPadding(boolean padding) {
        this.padding = padding;
    }

    public void setNoAnnotations(boolean no_annotations) {
        this.no_annotations = no_annotations;
    }

    public void setGlobalAnnotations(boolean with_global) {
        this.with_global_annotations = with_global;
    }

    public void setShowTSUIDs(boolean show_tsuids) {
        this.show_tsuids = show_tsuids;
    }

    public void setQueries(ArrayList<TSSubQuery> queries) {
        this.queries = queries;
    }

    public void setMsResolution(boolean ms_resolution) {
        this.ms_resolution = ms_resolution;
    }

    public void setShowQuery(boolean show_query) {
        this.show_query = show_query;
    }

    public void setShowStats(boolean show_stats) {
        this.show_stats = show_stats;
    }

    public void setShowSummary(boolean show_summary) {
        this.show_summary = show_summary;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public void setUseCalendar(boolean use_calendar) {
        this.use_calendar = use_calendar;
    }

    public void setQueryStats(QueryStats query_stats) {
        this.query_stats = query_stats;
    }
}

