/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.RateOptions;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.utils.ByteSet;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class TSSubQuery {
    private String aggregator;
    private String metric;
    private List<String> tsuids;
    private String downsample;
    private boolean rate;
    private RateOptions rate_options;
    private Aggregator agg;
    private DownsamplingSpecification downsample_specifier = DownsamplingSpecification.NO_DOWNSAMPLER;
    private List<TagVFilter> filters;
    private boolean explicit_tags;
    private int index;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.aggregator, this.metric, this.tsuids, this.downsample, this.rate, this.rate_options, this.filters, this.explicit_tags});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TSSubQuery)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TSSubQuery query = (TSSubQuery)obj;
        return Objects.equal((Object)this.aggregator, (Object)query.aggregator) && Objects.equal((Object)this.metric, (Object)query.metric) && Objects.equal(this.tsuids, query.tsuids) && Objects.equal((Object)this.downsample, (Object)query.downsample) && Objects.equal((Object)this.rate, (Object)query.rate) && Objects.equal((Object)this.rate_options, (Object)query.rate_options) && Objects.equal(this.filters, query.filters) && Objects.equal((Object)this.explicit_tags, (Object)query.explicit_tags);
    }

    public String toString() {
        int counter;
        StringBuilder buf = new StringBuilder();
        buf.append("TSSubQuery(metric=").append(this.metric == null || this.metric.isEmpty() ? "" : this.metric);
        buf.append(", filters=[");
        if (this.filters != null && !this.filters.isEmpty()) {
            counter = 0;
            for (TagVFilter filter : this.filters) {
                if (counter > 0) {
                    buf.append(", ");
                }
                buf.append(filter);
                ++counter;
            }
        }
        buf.append("], tsuids=[");
        if (this.tsuids != null && !this.tsuids.isEmpty()) {
            counter = 0;
            for (String tsuid : this.tsuids) {
                if (counter > 0) {
                    buf.append(", ");
                }
                buf.append(tsuid);
                ++counter;
            }
        }
        buf.append("], agg=").append(this.aggregator).append(", downsample=").append(this.downsample).append(", ds_interval=").append(this.downsample_specifier.getInterval()).append(", rate=").append(this.rate).append(", rate_options=").append(this.rate_options).append(", explicit_tags=").append("explicit_tags").append(", index=").append(this.index).append(")");
        return buf.toString();
    }

    public void validateAndSetQuery() {
        if (this.aggregator == null || this.aggregator.isEmpty()) {
            throw new IllegalArgumentException("Missing the aggregation function");
        }
        try {
            this.agg = Aggregators.get(this.aggregator);
        }
        catch (NoSuchElementException nse) {
            throw new IllegalArgumentException("No such aggregation function: " + this.aggregator);
        }
        if ((this.tsuids == null || this.tsuids.isEmpty()) && (this.metric == null || this.metric.isEmpty())) {
            throw new IllegalArgumentException("Missing the metric or tsuids, provide at least one");
        }
        if (this.filters == null) {
            this.filters = new ArrayList<TagVFilter>();
        }
        this.downsample_specifier = this.downsample != null && !this.downsample.isEmpty() ? new DownsamplingSpecification(this.downsample) : DownsamplingSpecification.NO_DOWNSAMPLER;
    }

    public Aggregator aggregator() {
        return this.agg;
    }

    public Aggregator downsampler() {
        return this.downsample_specifier.getFunction();
    }

    public long downsampleInterval() {
        return this.downsample_specifier.getInterval();
    }

    public DownsamplingSpecification downsamplingSpecification() {
        return this.downsample_specifier;
    }

    public FillPolicy fillPolicy() {
        return this.downsample_specifier.getFillPolicy();
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public String getMetric() {
        return this.metric;
    }

    public List<String> getTsuids() {
        return this.tsuids;
    }

    public Map<String, String> getTags() {
        if (this.filters == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> tags = new HashMap<String, String>(this.filters.size());
        for (TagVFilter filter : this.filters) {
            if (!filter.isGroupBy()) continue;
            tags.put(filter.getTagk(), filter.getType() + "(" + filter.getFilter() + ")");
        }
        return ImmutableMap.copyOf(tags);
    }

    public String getDownsample() {
        return this.downsample;
    }

    public boolean getRate() {
        return this.rate;
    }

    public RateOptions getRateOptions() {
        return this.rate_options;
    }

    public List<TagVFilter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<TagVFilter>();
        }
        return new ArrayList<TagVFilter>(this.filters);
    }

    public ByteSet getFilterTagKs() {
        if (this.filters == null || this.filters.isEmpty()) {
            return null;
        }
        ByteSet tagks = new ByteSet();
        for (TagVFilter filter : this.filters) {
            if (filter == null || filter.getTagkBytes() == null) continue;
            tagks.add(filter.getTagkBytes());
        }
        return tagks;
    }

    public boolean getExplicitTags() {
        return this.explicit_tags;
    }

    public int getIndex() {
        return this.index;
    }

    public void setAggregator(String aggregator) {
        this.aggregator = aggregator;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTsuids(List<String> tsuids) {
        this.tsuids = tsuids;
    }

    public void setTags(Map<String, String> tags) {
        if (this.filters == null) {
            this.filters = new ArrayList<TagVFilter>(tags.size());
        } else {
            this.filters.clear();
        }
        TagVFilter.tagsToFilters(tags, this.filters);
    }

    public void setDownsample(String downsample) {
        this.downsample = downsample;
    }

    public void setRate(boolean rate) {
        this.rate = rate;
    }

    public void setRateOptions(RateOptions options) {
        this.rate_options = options;
    }

    public void setFilters(List<TagVFilter> filters) {
        this.filters = filters;
    }

    public void setExplicitTags(boolean explicit_tags) {
        this.explicit_tags = explicit_tags;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

