/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.Const;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.utils.Exceptions;
import net.opentsdb.utils.Pair;
import org.hbase.async.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Tags {
    private static final Logger LOG = LoggerFactory.getLogger(Tags.class);
    private static String allowSpecialChars = "";
    private static final SortResolvedTagsCB SORT_CB = new SortResolvedTagsCB();

    private Tags() {
    }

    public static String[] splitString(String s, char c) {
        int pos;
        char[] chars = s.toCharArray();
        int num_substrings = 1;
        for (char x : chars) {
            if (x != c) continue;
            ++num_substrings;
        }
        String[] result = new String[num_substrings];
        int len = chars.length;
        int start = 0;
        int i = 0;
        for (pos = 0; pos < len; ++pos) {
            if (chars[pos] != c) continue;
            result[i++] = new String(chars, start, pos - start);
            start = pos + 1;
        }
        result[i] = new String(chars, start, pos - start);
        return result;
    }

    public static void parse(HashMap<String, String> tags, String tag) {
        String[] kv = Tags.splitString(tag, '=');
        if (kv.length != 2 || kv[0].length() <= 0 || kv[1].length() <= 0) {
            throw new IllegalArgumentException("invalid tag: " + tag);
        }
        if (kv[1].equals(tags.get(kv[0]))) {
            return;
        }
        if (tags.get(kv[0]) != null) {
            throw new IllegalArgumentException("duplicate tag: " + tag + ", tags=" + tags);
        }
        tags.put(kv[0], kv[1]);
    }

    public static void parse(List<Pair<String, String>> tags, String tag) {
        if (tag == null || tag.isEmpty() || tag.length() < 2) {
            throw new IllegalArgumentException("Missing tag pair");
        }
        if (tag.charAt(0) == '=') {
            tags.add(new Pair<Object, String>(null, tag.substring(1)));
            return;
        }
        if (tag.charAt(tag.length() - 1) == '=') {
            tags.add(new Pair<String, Object>(tag.substring(0, tag.length() - 1), null));
            return;
        }
        String[] kv = Tags.splitString(tag, '=');
        if (kv.length != 2 || kv[0].length() <= 0 || kv[1].length() <= 0) {
            throw new IllegalArgumentException("invalid tag: " + tag);
        }
        tags.add(new Pair<String, String>(kv[0], kv[1]));
    }

    public static String parseWithMetric(String metric, HashMap<String, String> tags) {
        int curly = metric.indexOf(123);
        if (curly < 0) {
            return metric;
        }
        int len = metric.length();
        if (metric.charAt(len - 1) != '}') {
            throw new IllegalArgumentException("Missing '}' at the end of: " + metric);
        }
        if (curly == len - 2) {
            return metric.substring(0, len - 2);
        }
        for (String tag : Tags.splitString(metric.substring(curly + 1, len - 1), ',')) {
            try {
                Tags.parse(tags, tag);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("When parsing tag '" + tag + "': " + e.getMessage());
            }
        }
        return metric.substring(0, curly);
    }

    public static String parseWithMetric(String metric, List<Pair<String, String>> tags) {
        int curly = metric.indexOf(123);
        if (curly < 0) {
            if (metric.isEmpty()) {
                throw new IllegalArgumentException("Metric string was empty");
            }
            return metric;
        }
        int len = metric.length();
        if (metric.charAt(len - 1) != '}') {
            throw new IllegalArgumentException("Missing '}' at the end of: " + metric);
        }
        if (curly == len - 2) {
            if (metric.charAt(0) == '{') {
                throw new IllegalArgumentException("Missing metric and tags: " + metric);
            }
            return metric.substring(0, len - 2);
        }
        for (String tag : Tags.splitString(metric.substring(curly + 1, len - 1), ',')) {
            try {
                Tags.parse(tags, tag);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("When parsing tag '" + tag + "': " + e.getMessage());
            }
        }
        if (metric.charAt(0) == '{') {
            return null;
        }
        return metric.substring(0, curly);
    }

    public static String parseWithMetricAndFilters(String metric, List<TagVFilter> filters) {
        if (metric == null || metric.isEmpty()) {
            throw new IllegalArgumentException("Metric cannot be null or empty");
        }
        if (filters == null) {
            throw new IllegalArgumentException("Filters cannot be null");
        }
        int curly = metric.indexOf(123);
        if (curly < 0) {
            return metric;
        }
        int len = metric.length();
        if (metric.charAt(len - 1) != '}') {
            throw new IllegalArgumentException("Missing '}' at the end of: " + metric);
        }
        if (curly == len - 2) {
            return metric.substring(0, len - 2);
        }
        int close = metric.indexOf(125);
        HashMap<String, String> filter_map = new HashMap<String, String>();
        if (close != metric.length() - 1) {
            String filter;
            int filter_bracket = metric.lastIndexOf(123);
            String[] stringArray = Tags.splitString(metric.substring(filter_bracket + 1, metric.length() - 1), ',');
            int n = stringArray.length;
            for (int i = 0; i < n && !(filter = stringArray[i]).isEmpty(); ++i) {
                filter_map.clear();
                try {
                    Tags.parse(filter_map, filter);
                    TagVFilter.mapToFilters(filter_map, filters, false);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("When parsing filter '" + filter + "': " + e.getMessage(), e);
                }
            }
        }
        for (String tag : Tags.splitString(metric.substring(curly + 1, close), ',')) {
            try {
                if (tag.isEmpty() && close != metric.length() - 1) break;
                filter_map.clear();
                Tags.parse(filter_map, tag);
                TagVFilter.tagsToFilters(filter_map, filters);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("When parsing tag '" + tag + "': " + e.getMessage(), e);
            }
        }
        return metric.substring(0, curly);
    }

    public static long parseLong(CharSequence s) {
        int n = s.length();
        if (n == 0) {
            throw new NumberFormatException("Empty string");
        }
        char c = s.charAt(0);
        int i = 1;
        if (c < '0' && (c == '+' || c == '-')) {
            if (n == 1) {
                throw new NumberFormatException("Just a sign, no value: " + s);
            }
            if (n > 20) {
                throw new NumberFormatException("Value too long: " + s);
            }
            c = s.charAt(1);
            i = 2;
        } else if (n > 19) {
            throw new NumberFormatException("Value too long: " + s);
        }
        long v = 0L;
        while (true) {
            if ('0' <= c && c <= '9') {
                v -= (long)(c - 48);
            } else {
                throw new NumberFormatException("Invalid character '" + c + "' in " + s);
            }
            if (i == n) break;
            v *= 10L;
            c = s.charAt(i++);
        }
        if (v > 0L) {
            throw new NumberFormatException("Overflow in " + s);
        }
        if (s.charAt(0) == '-') {
            return v;
        }
        if (v == Long.MIN_VALUE) {
            throw new NumberFormatException("Overflow in " + s);
        }
        return -v;
    }

    static String getValue(TSDB tsdb, byte[] row, String name) throws NoSuchUniqueName {
        Tags.validateString("tag name", name);
        byte[] id = tsdb.tag_names.getId(name);
        byte[] value_id = Tags.getValueId(tsdb, row, id);
        if (value_id == null) {
            return null;
        }
        try {
            return tsdb.tag_values.getName(value_id);
        }
        catch (NoSuchUniqueId e) {
            LOG.error("Internal error, NoSuchUniqueId unexpected here!", (Throwable)e);
            throw e;
        }
    }

    static byte[] getValueId(TSDB tsdb, byte[] row, byte[] tag_id) {
        short name_width = tsdb.tag_names.width();
        short value_width = tsdb.tag_values.width();
        short pos = (short)(Const.SALT_WIDTH() + tsdb.metrics.width() + 4);
        while (pos < row.length) {
            if (Tags.rowContains(row, pos, tag_id)) {
                pos = (short)(pos + name_width);
                return Arrays.copyOfRange(row, (int)pos, pos + value_width);
            }
            pos = (short)(pos + (name_width + value_width));
        }
        return null;
    }

    private static boolean rowContains(byte[] row, short offset, byte[] bytes) {
        for (int pos = bytes.length - 1; pos >= 0; --pos) {
            if (row[offset + pos] == bytes[pos]) continue;
            return false;
        }
        return true;
    }

    static Map<String, String> getTags(TSDB tsdb, byte[] row) throws NoSuchUniqueId {
        try {
            return (Map)Tags.getTagsAsync(tsdb, row).joinUninterruptibly();
        }
        catch (DeferredGroupException e) {
            Throwable ex = Exceptions.getCause(e);
            if (ex instanceof NoSuchUniqueId) {
                throw (NoSuchUniqueId)ex;
            }
            throw new RuntimeException("Should never be here", e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    static Deferred<Map<String, String>> getTagsAsync(TSDB tsdb, final byte[] row) throws NoSuchUniqueId {
        short name_width = tsdb.tag_names.width();
        short value_width = tsdb.tag_values.width();
        final short tag_bytes = (short)(name_width + value_width);
        final short metric_ts_bytes = (short)(Const.SALT_WIDTH() + tsdb.metrics.width() + 4);
        ArrayList<Deferred<String>> deferreds = new ArrayList<Deferred<String>>((row.length - metric_ts_bytes) / tag_bytes);
        short pos = metric_ts_bytes;
        while (pos < row.length) {
            byte[] tmp_name = new byte[name_width];
            byte[] tmp_value = new byte[value_width];
            System.arraycopy(row, pos, tmp_name, 0, name_width);
            deferreds.add(tsdb.tag_names.getNameAsync(tmp_name));
            System.arraycopy(row, pos + name_width, tmp_value, 0, value_width);
            deferreds.add(tsdb.tag_values.getNameAsync(tmp_value));
            pos = (short)(pos + tag_bytes);
        }
        class NameCB
        implements Callback<Map<String, String>, ArrayList<String>> {
            NameCB() {
            }

            public Map<String, String> call(ArrayList<String> names) throws Exception {
                HashMap<String, String> result = new HashMap<String, String>((row.length - metric_ts_bytes) / tag_bytes);
                String tagk = "";
                for (String name : names) {
                    if (tagk.isEmpty()) {
                        tagk = name;
                        continue;
                    }
                    result.put(tagk, name);
                    tagk = "";
                }
                return result;
            }
        }
        return Deferred.groupInOrder(deferreds).addCallback((Callback)new NameCB());
    }

    public static Deferred<Map<String, String>> getTagsAsync(TSDB tsdb, Bytes.ByteMap<byte[]> tags) {
        if (tags == null || tags.isEmpty()) {
            return Deferred.fromResult(Collections.emptyMap());
        }
        ArrayList<Deferred<String>> deferreds = new ArrayList<Deferred<String>>();
        for (Map.Entry pair : tags) {
            deferreds.add(tsdb.tag_names.getNameAsync((byte[])pair.getKey()));
            deferreds.add(tsdb.tag_values.getNameAsync((byte[])pair.getValue()));
        }
        class NameCB
        implements Callback<Map<String, String>, ArrayList<String>> {
            NameCB() {
            }

            public Map<String, String> call(ArrayList<String> names) throws Exception {
                HashMap<String, String> result = new HashMap<String, String>();
                String tagk = "";
                for (String name : names) {
                    if (tagk.isEmpty()) {
                        tagk = name;
                        continue;
                    }
                    result.put(tagk, name);
                    tagk = "";
                }
                return result;
            }
        }
        return Deferred.groupInOrder(deferreds).addCallback((Callback)new NameCB());
    }

    public static Bytes.ByteMap<byte[]> getTagUids(byte[] row) {
        short metric_ts_bytes;
        Bytes.ByteMap uids = new Bytes.ByteMap();
        short name_width = TSDB.tagk_width();
        short value_width = TSDB.tagv_width();
        short tag_bytes = (short)(name_width + value_width);
        short pos = metric_ts_bytes = (short)(TSDB.metrics_width() + 4 + Const.SALT_WIDTH());
        while (pos < row.length) {
            byte[] tmp_name = new byte[name_width];
            byte[] tmp_value = new byte[value_width];
            System.arraycopy(row, pos, tmp_name, 0, name_width);
            System.arraycopy(row, pos + name_width, tmp_value, 0, value_width);
            uids.put((Object)tmp_name, (Object)tmp_value);
            pos = (short)(pos + tag_bytes);
        }
        return uids;
    }

    public static void validateString(String what, String s) {
        if (s == null) {
            throw new IllegalArgumentException("Invalid " + what + ": null");
        }
        if ("".equals(s)) {
            throw new IllegalArgumentException("Invalid " + what + ": empty string");
        }
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '-' || c == '_' || c == '.' || c == '/' || Character.isLetter(c) || Tags.isAllowSpecialChars(c)) continue;
            throw new IllegalArgumentException("Invalid " + what + " (\"" + s + "\"): illegal character: " + c);
        }
    }

    public static ArrayList<byte[]> resolveAll(TSDB tsdb, Map<String, String> tags) throws NoSuchUniqueName {
        try {
            return Tags.resolveAllInternal(tsdb, tags, false);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never happen!", e);
        }
    }

    public static Deferred<ArrayList<byte[]>> resolveAllAsync(TSDB tsdb, Map<String, String> tags) {
        return Tags.resolveAllInternalAsync(tsdb, null, tags, false);
    }

    static ArrayList<byte[]> resolveOrCreateAll(TSDB tsdb, Map<String, String> tags) {
        return Tags.resolveAllInternal(tsdb, tags, true);
    }

    private static ArrayList<byte[]> resolveAllInternal(TSDB tsdb, Map<String, String> tags, boolean create) throws NoSuchUniqueName {
        ArrayList<byte[]> tag_ids = new ArrayList<byte[]>(tags.size());
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            byte[] tag_id = create && tsdb.getConfig().auto_tagk() ? tsdb.tag_names.getOrCreateId(entry.getKey()) : tsdb.tag_names.getId(entry.getKey());
            byte[] value_id = create && tsdb.getConfig().auto_tagv() ? tsdb.tag_values.getOrCreateId(entry.getValue()) : tsdb.tag_values.getId(entry.getValue());
            byte[] thistag = new byte[tag_id.length + value_id.length];
            System.arraycopy(tag_id, 0, thistag, 0, tag_id.length);
            System.arraycopy(value_id, 0, thistag, tag_id.length, value_id.length);
            tag_ids.add(thistag);
        }
        Collections.sort(tag_ids, Bytes.MEMCMP);
        return tag_ids;
    }

    static Deferred<ArrayList<byte[]>> resolveOrCreateAllAsync(TSDB tsdb, Map<String, String> tags) {
        return Tags.resolveAllInternalAsync(tsdb, null, tags, true);
    }

    static Deferred<ArrayList<byte[]>> resolveOrCreateAllAsync(TSDB tsdb, String metric, Map<String, String> tags) {
        return Tags.resolveAllInternalAsync(tsdb, metric, tags, true);
    }

    private static Deferred<ArrayList<byte[]>> resolveAllInternalAsync(TSDB tsdb, String metric, Map<String, String> tags, boolean create) {
        ArrayList<Deferred> tag_ids = new ArrayList<Deferred>(tags.size());
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            Deferred<byte[]> name_id = create ? tsdb.tag_names.getOrCreateIdAsync(entry.getKey(), metric, tags) : tsdb.tag_names.getIdAsync(entry.getKey());
            Deferred<byte[]> value_id = create ? tsdb.tag_values.getOrCreateIdAsync(entry.getValue(), metric, tags) : tsdb.tag_values.getIdAsync(entry.getValue());
            class TagNameResolvedCB
            implements Callback<Deferred<byte[]>, byte[]> {
                final /* synthetic */ Deferred val$value_id;

                TagNameResolvedCB(Deferred deferred) {
                    this.val$value_id = deferred;
                }

                public Deferred<byte[]> call(final byte[] nameid) {
                    class TagValueResolvedCB
                    implements Callback<byte[], byte[]> {
                        TagValueResolvedCB() {
                        }

                        public byte[] call(byte[] valueid) {
                            byte[] thistag = new byte[nameid.length + valueid.length];
                            System.arraycopy(nameid, 0, thistag, 0, nameid.length);
                            System.arraycopy(valueid, 0, thistag, nameid.length, valueid.length);
                            return thistag;
                        }
                    }
                    return this.val$value_id.addCallback((Callback)new TagValueResolvedCB());
                }
            }
            Deferred resolve = name_id.addCallbackDeferring((Callback)new TagNameResolvedCB(value_id));
            tag_ids.add(resolve);
        }
        return Deferred.group(tag_ids).addCallback((Callback)SORT_CB);
    }

    public static HashMap<String, String> resolveIds(TSDB tsdb, ArrayList<byte[]> tags) throws NoSuchUniqueId {
        try {
            return (HashMap)Tags.resolveIdsAsync(tsdb, tags).joinUninterruptibly();
        }
        catch (NoSuchUniqueId e) {
            throw e;
        }
        catch (DeferredGroupException e) {
            Throwable ex = Exceptions.getCause(e);
            if (ex instanceof NoSuchUniqueId) {
                throw (NoSuchUniqueId)ex;
            }
            throw new RuntimeException("Shouldn't be here", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Shouldn't be here", e);
        }
    }

    public static Deferred<HashMap<String, String>> resolveIdsAsync(TSDB tsdb, List<byte[]> tags) throws NoSuchUniqueId {
        short name_width = tsdb.tag_names.width();
        short value_width = tsdb.tag_values.width();
        short tag_bytes = (short)(name_width + value_width);
        HashMap result = new HashMap(tags.size());
        ArrayList<Deferred<String>> deferreds = new ArrayList<Deferred<String>>(tags.size());
        for (byte[] tag : tags) {
            byte[] tmp_name = new byte[name_width];
            byte[] tmp_value = new byte[value_width];
            if (tag.length != tag_bytes) {
                throw new IllegalArgumentException("invalid length: " + tag.length + " (expected " + tag_bytes + "): " + Arrays.toString(tag));
            }
            System.arraycopy(tag, 0, tmp_name, 0, name_width);
            deferreds.add(tsdb.tag_names.getNameAsync(tmp_name));
            System.arraycopy(tag, name_width, tmp_value, 0, value_width);
            deferreds.add(tsdb.tag_values.getNameAsync(tmp_value));
        }
        class GroupCB
        implements Callback<HashMap<String, String>, ArrayList<String>> {
            final /* synthetic */ HashMap val$result;

            GroupCB(HashMap hashMap) {
                this.val$result = hashMap;
            }

            public HashMap<String, String> call(ArrayList<String> names) throws Exception {
                for (int i = 0; i < names.size(); ++i) {
                    if (i % 2 == 0) continue;
                    this.val$result.put(names.get(i - 1), names.get(i));
                }
                return this.val$result;
            }
        }
        return Deferred.groupInOrder(deferreds).addCallback((Callback)new GroupCB(result));
    }

    public static boolean looksLikeInteger(String value) {
        int n = value.length();
        for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            if (c != '.' && c != 'e' && c != 'E') continue;
            return false;
        }
        return true;
    }

    public static void setAllowSpecialChars(String characters) {
        allowSpecialChars = characters == null ? "" : characters;
    }

    static boolean isAllowSpecialChars(char character) {
        return allowSpecialChars.indexOf(character) != -1;
    }

    private static class SortResolvedTagsCB
    implements Callback<ArrayList<byte[]>, ArrayList<byte[]>> {
        private SortResolvedTagsCB() {
        }

        public ArrayList<byte[]> call(ArrayList<byte[]> tags) {
            Collections.sort(tags, Bytes.MEMCMP);
            return tags;
        }
    }
}

