/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.core;

import com.google.common.annotations.VisibleForTesting;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.Const;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.DownsamplingSpecification;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.Internal;
import net.opentsdb.core.Query;
import net.opentsdb.core.RateOptions;
import net.opentsdb.core.SaltScanner;
import net.opentsdb.core.Span;
import net.opentsdb.core.SpanGroup;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.core.TSSubQuery;
import net.opentsdb.core.Tags;
import net.opentsdb.query.QueryUtil;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.stats.Histogram;
import net.opentsdb.stats.QueryStats;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.DateTime;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.HBaseException;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TsdbQuery
implements Query {
    private static final Logger LOG = LoggerFactory.getLogger(TsdbQuery.class);
    private static final DataPoints[] NO_RESULT = new DataPoints[0];
    static final Histogram scanlatency = new Histogram(16000, 2, 100);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private final TSDB tsdb;
    private long scan_start_time;
    private static final int UNSET = -1;
    private long start_time = -1L;
    private long end_time = -1L;
    private boolean delete;
    private byte[] metric;
    private String regex;
    private boolean enable_fuzzy_filter;
    private ArrayList<byte[]> group_bys;
    private Bytes.ByteMap<byte[][]> row_key_literals;
    private boolean rate;
    private RateOptions rate_options;
    private Aggregator aggregator;
    private DownsamplingSpecification downsampler;
    private List<String> tsuids;
    private int query_index;
    private List<TagVFilter> filters;
    private QueryStats query_stats;
    private boolean explicit_tags;

    public TsdbQuery(TSDB tsdb) {
        this.tsdb = tsdb;
        this.enable_fuzzy_filter = tsdb.getConfig().getBoolean("tsd.query.enable_fuzzy_filter");
    }

    @Override
    public void setStartTime(long timestamp) {
        if (timestamp < 0L || (timestamp & 0xFFFFFFFF00000000L) != 0L && timestamp > 9999999999999L) {
            throw new IllegalArgumentException("Invalid timestamp: " + timestamp);
        }
        if (this.end_time != -1L && timestamp >= this.getEndTime()) {
            throw new IllegalArgumentException("new start time (" + timestamp + ") is greater than or equal to end time: " + this.getEndTime());
        }
        this.start_time = timestamp;
    }

    @Override
    public long getStartTime() {
        if (this.start_time == -1L) {
            throw new IllegalStateException("setStartTime was never called!");
        }
        return this.start_time;
    }

    @Override
    public void setEndTime(long timestamp) {
        if (timestamp < 0L || (timestamp & 0xFFFFFFFF00000000L) != 0L && timestamp > 9999999999999L) {
            throw new IllegalArgumentException("Invalid timestamp: " + timestamp);
        }
        if (this.start_time != -1L && timestamp <= this.getStartTime()) {
            throw new IllegalArgumentException("new end time (" + timestamp + ") is less than or equal to start time: " + this.getStartTime());
        }
        this.end_time = timestamp;
    }

    @Override
    public long getEndTime() {
        if (this.end_time == -1L) {
            this.setEndTime(DateTime.currentTimeMillis());
        }
        return this.end_time;
    }

    @Override
    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Override
    public boolean getDelete() {
        return this.delete;
    }

    @Override
    public void setTimeSeries(String metric, Map<String, String> tags, Aggregator function, boolean rate) throws NoSuchUniqueName {
        this.setTimeSeries(metric, tags, function, rate, new RateOptions());
    }

    @Override
    public void setTimeSeries(String metric, Map<String, String> tags, Aggregator function, boolean rate, RateOptions rate_options) throws NoSuchUniqueName {
        if (this.filters == null) {
            this.filters = new ArrayList<TagVFilter>(tags.size());
        }
        TagVFilter.tagsToFilters(tags, this.filters);
        try {
            for (TagVFilter filter : this.filters) {
                filter.resolveTagkName(this.tsdb).join();
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (NoSuchUniqueName e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof DeferredGroupException) {
                Throwable ex;
                for (ex = e.getCause(); ex != null && ex instanceof DeferredGroupException; ex = ex.getCause()) {
                }
                if (ex != null) {
                    throw (RuntimeException)ex;
                }
            }
            LOG.error("Unexpected exception processing group bys", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.findGroupBys();
        this.metric = this.tsdb.metrics.getId(metric);
        this.aggregator = function;
        this.rate = rate;
        this.rate_options = rate_options;
    }

    @Override
    public void setTimeSeries(List<String> tsuids, Aggregator function, boolean rate) {
        this.setTimeSeries(tsuids, function, rate, new RateOptions());
    }

    @Override
    public void setTimeSeries(List<String> tsuids, Aggregator function, boolean rate, RateOptions rate_options) {
        if (tsuids == null || tsuids.isEmpty()) {
            throw new IllegalArgumentException("Empty or missing TSUID list not allowed");
        }
        String first_metric = "";
        for (String tsuid : tsuids) {
            if (first_metric.isEmpty()) {
                first_metric = tsuid.substring(0, TSDB.metrics_width() * 2).toUpperCase();
                continue;
            }
            String metric = tsuid.substring(0, TSDB.metrics_width() * 2).toUpperCase();
            if (first_metric.equals(metric)) continue;
            throw new IllegalArgumentException("One or more TSUIDs did not share the same metric");
        }
        this.tsuids = tsuids;
        this.aggregator = function;
        this.rate = rate;
        this.rate_options = rate_options;
    }

    public void setExplicitTags(boolean explicit_tags) {
        this.explicit_tags = explicit_tags;
    }

    @Override
    public Deferred<Object> configureFromQuery(TSQuery query, int index) {
        if (query.getQueries() == null || query.getQueries().isEmpty()) {
            throw new IllegalArgumentException("Missing sub queries");
        }
        if (index < 0 || index > query.getQueries().size()) {
            throw new IllegalArgumentException("Query index was out of range");
        }
        TSSubQuery sub_query = query.getQueries().get(index);
        this.setStartTime(query.startTime());
        this.setEndTime(query.endTime());
        this.setDelete(query.getDelete());
        this.query_index = index;
        this.query_stats = query.getQueryStats();
        this.aggregator = sub_query.aggregator();
        this.rate = sub_query.getRate();
        this.rate_options = sub_query.getRateOptions();
        if (this.rate_options == null) {
            this.rate_options = new RateOptions();
        }
        this.downsampler = sub_query.downsamplingSpecification();
        this.filters = sub_query.getFilters();
        this.explicit_tags = sub_query.getExplicitTags();
        if (sub_query.getTsuids() != null && !sub_query.getTsuids().isEmpty()) {
            this.tsuids = new ArrayList<String>(sub_query.getTsuids());
            String first_metric = "";
            for (String tsuid : this.tsuids) {
                if (first_metric.isEmpty()) {
                    first_metric = tsuid.substring(0, TSDB.metrics_width() * 2).toUpperCase();
                    continue;
                }
                String metric = tsuid.substring(0, TSDB.metrics_width() * 2).toUpperCase();
                if (first_metric.equals(metric)) continue;
                throw new IllegalArgumentException("One or more TSUIDs did not share the same metric [" + first_metric + "] [" + metric + "]");
            }
            return Deferred.fromResult(null);
        }
        class MetricCB
        implements Callback<Deferred<Object>, byte[]> {
            MetricCB() {
            }

            public Deferred<Object> call(byte[] uid) throws Exception {
                TsdbQuery.access$102(TsdbQuery.this, uid);
                if (TsdbQuery.this.filters != null) {
                    ArrayList<Deferred<byte[]>> deferreds = new ArrayList<Deferred<byte[]>>(TsdbQuery.this.filters.size());
                    for (TagVFilter filter : TsdbQuery.this.filters) {
                        deferreds.add(filter.resolveTagkName(TsdbQuery.this.tsdb));
                    }
                    class FilterCB
                    implements Callback<Object, ArrayList<byte[]>> {
                        FilterCB() {
                        }

                        public Object call(ArrayList<byte[]> results) throws Exception {
                            TsdbQuery.this.findGroupBys();
                            return null;
                        }
                    }
                    return Deferred.group(deferreds).addCallback((Callback)new FilterCB());
                }
                return Deferred.fromResult(null);
            }
        }
        return this.tsdb.metrics.getIdAsync(sub_query.getMetric()).addCallbackDeferring((Callback)new MetricCB());
    }

    @Override
    public void downsample(long interval, Aggregator downsampler, FillPolicy fill_policy) {
        this.downsampler = new DownsamplingSpecification(interval, downsampler, fill_policy);
    }

    @Override
    public void downsample(long interval, Aggregator downsampler) {
        if (downsampler == Aggregators.NONE) {
            throw new IllegalArgumentException("cannot use the NONE aggregator for downsampling");
        }
        this.downsample(interval, downsampler, FillPolicy.NONE);
    }

    private void findGroupBys() {
        if (this.filters == null || this.filters.isEmpty()) {
            return;
        }
        this.row_key_literals = new Bytes.ByteMap();
        Collections.sort(this.filters);
        Iterator<TagVFilter> current_iterator = this.filters.iterator();
        Iterator<TagVFilter> look_ahead = this.filters.iterator();
        byte[] tagk = null;
        TagVFilter next = look_ahead.hasNext() ? look_ahead.next() : null;
        int row_key_literals_count = 0;
        while (current_iterator.hasNext()) {
            next = look_ahead.hasNext() ? look_ahead.next() : null;
            int gbs = 0;
            Bytes.ByteMap literals = new Bytes.ByteMap();
            ArrayList<TagVFilter> literal_filters = new ArrayList<TagVFilter>();
            TagVFilter current = null;
            do {
                current = current_iterator.next();
                if (tagk == null) {
                    tagk = new byte[TSDB.tagk_width()];
                    System.arraycopy(current.getTagkBytes(), 0, tagk, 0, TSDB.tagk_width());
                }
                if (current.isGroupBy()) {
                    ++gbs;
                }
                if (!current.getTagVUids().isEmpty()) {
                    for (byte[] uid : current.getTagVUids()) {
                        literals.put((Object)uid, null);
                    }
                    literal_filters.add(current);
                }
                if (next != null && Bytes.memcmp((byte[])tagk, (byte[])next.getTagkBytes()) != 0) break;
                TagVFilter tagVFilter = next = look_ahead.hasNext() ? look_ahead.next() : null;
            } while (current_iterator.hasNext() && Bytes.memcmp((byte[])tagk, (byte[])current.getTagkBytes()) == 0);
            if (gbs > 0) {
                if (this.group_bys == null) {
                    this.group_bys = new ArrayList();
                }
                this.group_bys.add(current.getTagkBytes());
            }
            if (literals.size() > 0) {
                if (literals.size() + row_key_literals_count > this.tsdb.getConfig().getInt("tsd.query.filter.expansion_limit")) {
                    LOG.debug("Skipping literals for " + current.getTagk() + " as it exceedes the limit");
                    continue;
                }
                byte[][] values = new byte[literals.size()][];
                literals.keySet().toArray((T[])values);
                this.row_key_literals.put((Object)current.getTagkBytes(), (Object)values);
                row_key_literals_count += values.length;
                for (TagVFilter filter : literal_filters) {
                    filter.setPostScan(false);
                }
                continue;
            }
            this.row_key_literals.put((Object)current.getTagkBytes(), null);
        }
    }

    @Override
    public DataPoints[] run() throws HBaseException {
        try {
            return (DataPoints[])this.runAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<DataPoints[]> runAsync() throws HBaseException {
        return this.findSpans().addCallback((Callback)new GroupByAndAggregateCB());
    }

    private Deferred<TreeMap<byte[], Span>> findSpans() throws HBaseException {
        ArrayList<TagVFilter> scanner_filters;
        final short metric_width = this.tsdb.metrics.width();
        final TreeMap<byte[], Span> spans = new TreeMap<byte[], Span>(new SpanCmp((short)(Const.SALT_WIDTH() + metric_width)));
        if (this.filters != null) {
            scanner_filters = new ArrayList<TagVFilter>(this.filters.size());
            for (TagVFilter filter : this.filters) {
                if (!filter.postScan()) continue;
                scanner_filters.add(filter);
            }
        } else {
            scanner_filters = null;
        }
        if (Const.SALT_WIDTH() > 0) {
            ArrayList<Scanner> scanners = new ArrayList<Scanner>(Const.SALT_BUCKETS());
            for (int i = 0; i < Const.SALT_BUCKETS(); ++i) {
                scanners.add(this.getScanner(i));
            }
            this.scan_start_time = DateTime.nanoTime();
            return new SaltScanner(this.tsdb, this.metric, scanners, spans, scanner_filters, this.delete, this.query_stats, this.query_index).scan();
        }
        this.scan_start_time = DateTime.nanoTime();
        final Scanner scanner = this.getScanner();
        if (this.query_stats != null) {
            this.query_stats.addScannerId(this.query_index, 0, scanner.toString());
        }
        final Deferred results = new Deferred();
        final class ScannerCB
        implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
            int nrows = 0;
            boolean seenAnnotation = false;
            long scanner_start = DateTime.nanoTime();
            long timeout = TsdbQuery.access$300(TsdbQuery.this).getConfig().getLong("tsd.query.timeout");
            private final Set<String> skips = new HashSet<String>();
            private final Set<String> keepers = new HashSet<String>();
            private final int index = 0;
            private long fetch_start = 0L;
            private long fetch_time = 0L;
            private long uid_resolve_time = 0L;
            private long uids_resolved = 0L;
            private long compaction_time = 0L;
            private long dps_pre_filter = 0L;
            private long rows_pre_filter = 0L;
            private long dps_post_filter = 0L;
            private long rows_post_filter = 0L;

            ScannerCB() {
            }

            public Object scan() {
                this.fetch_start = DateTime.nanoTime();
                return scanner.nextRows().addCallback((Callback)this).addErrback((Callback)new 1ScannerCB.ErrorCB());
            }

            public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                this.fetch_time += DateTime.nanoTime() - this.fetch_start;
                try {
                    if (rows == null) {
                        scanlatency.add((int)DateTime.msFromNano(this.fetch_time));
                        LOG.info(TsdbQuery.this + " matched " + this.nrows + " rows in " + spans.size() + " spans in " + DateTime.msFromNano(this.fetch_time) + "ms");
                        this.close(null);
                        return null;
                    }
                    if (this.timeout > 0L && DateTime.msFromNanoDiff(DateTime.nanoTime(), this.scanner_start) > (double)this.timeout) {
                        throw new InterruptedException("Query timeout exceeded!");
                    }
                    this.rows_pre_filter += (long)rows.size();
                    ArrayList<Deferred> lookups = TsdbQuery.this.filters != null && !TsdbQuery.this.filters.isEmpty() ? new ArrayList<Deferred>(rows.size()) : null;
                    for (final ArrayList<KeyValue> row : rows) {
                        final byte[] key = row.get(0).key();
                        if (Bytes.memcmp((byte[])TsdbQuery.this.metric, (byte[])key, (int)0, (int)metric_width) != 0) {
                            scanner.close();
                            throw new IllegalDataException("HBase returned a row that doesn't match our scanner (" + scanner + ")! " + row + " does not start with " + Arrays.toString(TsdbQuery.this.metric));
                        }
                        for (KeyValue kv : row) {
                            if (kv.qualifier().length % 2 == 0) {
                                if (kv.qualifier().length == 2 || kv.qualifier().length == 4) {
                                    ++this.dps_pre_filter;
                                    continue;
                                }
                                if (Internal.inMilliseconds(kv.qualifier())) {
                                    this.dps_pre_filter += (long)(kv.qualifier().length / 4);
                                    continue;
                                }
                                this.dps_pre_filter += (long)(kv.qualifier().length / 2);
                                continue;
                            }
                            if (kv.qualifier()[0] != 5) continue;
                            int idx = 0;
                            short qlength = 0;
                            while (idx < kv.value().length) {
                                qlength = Internal.getQualifierLength(kv.value(), idx);
                                idx += qlength + Internal.getValueLengthFromQualifier(kv.value(), idx);
                                ++this.dps_pre_filter;
                            }
                        }
                        if (scanner_filters != null && !scanner_filters.isEmpty()) {
                            lookups.clear();
                            final String tsuid = UniqueId.uidToString(UniqueId.getTSUIDFromKey(key, TSDB.metrics_width(), (short)4));
                            if (this.skips.contains(tsuid)) continue;
                            if (!this.keepers.contains(tsuid)) {
                                final long uid_start = DateTime.nanoTime();
                                class GetTagsCB
                                implements Callback<Deferred<ArrayList<Boolean>>, Map<String, String>> {
                                    GetTagsCB() {
                                    }

                                    public Deferred<ArrayList<Boolean>> call(Map<String, String> tags) throws Exception {
                                        uid_resolve_time = uid_resolve_time + (DateTime.nanoTime() - uid_start);
                                        uids_resolved = uids_resolved + (long)tags.size();
                                        ArrayList<Deferred<Boolean>> matches = new ArrayList<Deferred<Boolean>>(scanner_filters.size());
                                        for (TagVFilter filter : scanner_filters) {
                                            matches.add(filter.match(tags));
                                        }
                                        return Deferred.group(matches);
                                    }
                                }
                                class MatchCB
                                implements Callback<Object, ArrayList<Boolean>> {
                                    MatchCB() {
                                    }

                                    public Object call(ArrayList<Boolean> matches) throws Exception {
                                        for (boolean matched : matches) {
                                            if (matched) continue;
                                            skips.add(tsuid);
                                            return null;
                                        }
                                        keepers.add(tsuid);
                                        this.processRow(key, row);
                                        return null;
                                    }
                                }
                                lookups.add(Tags.getTagsAsync(TsdbQuery.this.tsdb, key).addCallbackDeferring((Callback)new GetTagsCB()).addBoth((Callback)new MatchCB()));
                                continue;
                            }
                            this.processRow(key, row);
                            continue;
                        }
                        this.processRow(key, row);
                    }
                    if (lookups != null && lookups.size() > 0) {
                        class GroupCB
                        implements Callback<Object, ArrayList<Object>> {
                            GroupCB() {
                            }

                            public Object call(ArrayList<Object> group) throws Exception {
                                return this.scan();
                            }
                        }
                        return Deferred.group(lookups).addCallback((Callback)new GroupCB());
                    }
                    return this.scan();
                }
                catch (Exception e) {
                    this.close(e);
                    return null;
                }
            }

            void processRow(byte[] key, ArrayList<KeyValue> row) {
                ++this.rows_post_filter;
                if (TsdbQuery.this.delete) {
                    DeleteRequest del = new DeleteRequest(TsdbQuery.this.tsdb.dataTable(), key);
                    TsdbQuery.this.tsdb.getClient().delete(del);
                }
                for (KeyValue kv : row) {
                    if (kv.qualifier().length % 2 == 0) {
                        if (kv.qualifier().length == 2 || kv.qualifier().length == 4) {
                            ++this.dps_post_filter;
                            continue;
                        }
                        if (Internal.inMilliseconds(kv.qualifier())) {
                            this.dps_post_filter += (long)(kv.qualifier().length / 4);
                            continue;
                        }
                        this.dps_post_filter += (long)(kv.qualifier().length / 2);
                        continue;
                    }
                    if (kv.qualifier()[0] != 5) continue;
                    int idx = 0;
                    short qlength = 0;
                    while (idx < kv.value().length) {
                        qlength = Internal.getQualifierLength(kv.value(), idx);
                        idx += qlength + Internal.getValueLengthFromQualifier(kv.value(), idx);
                        ++this.dps_post_filter;
                    }
                }
                Span datapoints = (Span)spans.get(key);
                if (datapoints == null) {
                    datapoints = new Span(TsdbQuery.this.tsdb);
                    spans.put(key, datapoints);
                }
                long compaction_start = DateTime.nanoTime();
                KeyValue compacted = TsdbQuery.this.tsdb.compact(row, datapoints.getAnnotations());
                this.compaction_time += DateTime.nanoTime() - compaction_start;
                this.seenAnnotation |= !datapoints.getAnnotations().isEmpty();
                if (compacted != null) {
                    datapoints.addRow(compacted);
                    ++this.nrows;
                }
            }

            void close(Exception e) {
                scanner.close();
                if (TsdbQuery.this.query_stats != null) {
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.SCANNER_TIME, DateTime.nanoTime() - TsdbQuery.this.scan_start_time);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.HBASE_TIME, this.fetch_time);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.SUCCESSFUL_SCAN, e == null ? 1L : 0L);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.ROWS_PRE_FILTER, this.rows_pre_filter);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.DPS_PRE_FILTER, this.dps_pre_filter);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.ROWS_POST_FILTER, this.rows_post_filter);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.DPS_POST_FILTER, this.dps_post_filter);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.SCANNER_UID_TO_STRING_TIME, this.uid_resolve_time);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.UID_PAIRS_RESOLVED, this.uids_resolved);
                    TsdbQuery.this.query_stats.addScannerStat(TsdbQuery.this.query_index, 0, QueryStats.QueryStat.COMPACTION_TIME, this.compaction_time);
                }
                if (e != null) {
                    results.callback((Object)e);
                } else if (this.nrows < 1 && !this.seenAnnotation) {
                    results.callback(null);
                } else {
                    results.callback((Object)spans);
                }
            }

            class 1ScannerCB.ErrorCB
            implements Callback<Object, Exception> {
                1ScannerCB.ErrorCB() {
                }

                public Object call(Exception e) throws Exception {
                    LOG.error("Scanner " + scanner + " threw an exception", (Throwable)e);
                    this.close(e);
                    return null;
                }
            }
        }
        new ScannerCB().scan();
        return results;
    }

    protected Scanner getScanner() throws HBaseException {
        return this.getScanner(0);
    }

    protected Scanner getScanner(int salt_bucket) throws HBaseException {
        short metric_width = this.tsdb.metrics.width();
        if (this.tsuids != null && !this.tsuids.isEmpty()) {
            String tsuid = this.tsuids.get(0);
            String metric_uid = tsuid.substring(0, metric_width * 2);
            this.metric = UniqueId.stringToUid(metric_uid);
        }
        Scanner scanner = QueryUtil.getMetricScanner(this.tsdb, salt_bucket, this.metric, (int)this.getScanStartTimeSeconds(), this.end_time == -1L ? -1 : (int)this.getScanEndTimeSeconds(), this.tsdb.table, TSDB.FAMILY());
        if (this.tsuids != null && !this.tsuids.isEmpty()) {
            this.createAndSetTSUIDFilter(scanner);
        } else if (this.filters.size() > 0) {
            this.createAndSetFilter(scanner);
        }
        return scanner;
    }

    private long getScanStartTimeSeconds() {
        long timespan_offset;
        long timespan_aligned_ts;
        long start = this.getStartTime();
        if ((start & 0xFFFFFFFF00000000L) != 0L) {
            start /= 1000L;
        }
        long interval_aligned_ts = start;
        if (this.downsampler != null && this.downsampler.getInterval() > 0L) {
            long interval_offset = 1000L * start % this.downsampler.getInterval();
            interval_aligned_ts -= interval_offset / 1000L;
        }
        return (timespan_aligned_ts = interval_aligned_ts - (timespan_offset = interval_aligned_ts % 3600L)) > 0L ? timespan_aligned_ts : 0L;
    }

    private long getScanEndTimeSeconds() {
        long end = this.getEndTime();
        if ((end & 0xFFFFFFFF00000000L) != 0L && (end /= 1000L) - end * 1000L < 1L) {
            ++end;
        }
        if (this.downsampler != null && this.downsampler.getInterval() > 0L) {
            long interval_offset = 1000L * end % this.downsampler.getInterval();
            long interval_aligned_ts = end + (this.downsampler.getInterval() - interval_offset) / 1000L;
            long timespan_offset = interval_aligned_ts % 3600L;
            return 0L == timespan_offset ? interval_aligned_ts : interval_aligned_ts + (3600L - timespan_offset);
        }
        long timespan_offset = end % 3600L;
        return end + (3600L - timespan_offset);
    }

    private void createAndSetFilter(Scanner scanner) {
        QueryUtil.setDataTableScanFilter(scanner, this.group_bys, this.row_key_literals, this.explicit_tags, this.enable_fuzzy_filter, this.end_time == -1L ? -1 : (int)this.getScanEndTimeSeconds());
    }

    private void createAndSetTSUIDFilter(Scanner scanner) {
        if (this.regex == null) {
            this.regex = QueryUtil.getRowKeyTSUIDRegex(this.tsuids);
        }
        scanner.setKeyRegexp(this.regex, CHARSET);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TsdbQuery(start_time=").append(this.getStartTime()).append(", end_time=").append(this.getEndTime());
        if (this.tsuids != null && !this.tsuids.isEmpty()) {
            buf.append(", tsuids=");
            for (String tsuid : this.tsuids) {
                buf.append(tsuid).append(",");
            }
        } else {
            buf.append(", metric=").append(Arrays.toString(this.metric));
            buf.append(", filters=[");
            Iterator<TagVFilter> it = this.filters.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append(',');
            }
            buf.append("], rate=").append(this.rate).append(", aggregator=").append(this.aggregator).append(", group_bys=(");
            if (this.group_bys != null) {
                for (byte[] tag_id : this.group_bys) {
                    try {
                        buf.append(this.tsdb.tag_names.getName(tag_id));
                    }
                    catch (NoSuchUniqueId e) {
                        buf.append('<').append(e.getMessage()).append('>');
                    }
                    buf.append(' ').append(Arrays.toString(tag_id));
                    if (this.row_key_literals != null) {
                        byte[][] value_ids = (byte[][])this.row_key_literals.get((Object)tag_id);
                        if (value_ids == null) continue;
                        buf.append("={");
                        for (byte[] value_id : value_ids) {
                            try {
                                if (value_id != null) {
                                    buf.append(this.tsdb.tag_values.getName(value_id));
                                } else {
                                    buf.append("null");
                                }
                            }
                            catch (NoSuchUniqueId e) {
                                buf.append('<').append(e.getMessage()).append('>');
                            }
                            buf.append(' ').append(Arrays.toString(value_id)).append(", ");
                        }
                        buf.append('}');
                    }
                    buf.append(", ");
                }
            }
        }
        buf.append("))");
        return buf.toString();
    }

    static /* synthetic */ byte[] access$102(TsdbQuery x0, byte[] x1) {
        x0.metric = x1;
        return x1;
    }

    @VisibleForTesting
    static class ForTesting {
        ForTesting() {
        }

        static long getScanStartTimeSeconds(TsdbQuery query) {
            return query.getScanStartTimeSeconds();
        }

        static long getScanEndTimeSeconds(TsdbQuery query) {
            return query.getScanEndTimeSeconds();
        }

        static long getDownsampleIntervalMs(TsdbQuery query) {
            return query.downsampler.getInterval();
        }

        static byte[] getMetric(TsdbQuery query) {
            return query.metric;
        }

        static RateOptions getRateOptions(TsdbQuery query) {
            return query.rate_options;
        }

        static List<TagVFilter> getFilters(TsdbQuery query) {
            return query.filters;
        }

        static ArrayList<byte[]> getGroupBys(TsdbQuery query) {
            return query.group_bys;
        }

        static Bytes.ByteMap<byte[][]> getRowKeyLiterals(TsdbQuery query) {
            return query.row_key_literals;
        }
    }

    private static final class SpanCmp
    implements Comparator<byte[]> {
        private final short metric_width;

        public SpanCmp(short metric_width) {
            this.metric_width = metric_width;
        }

        @Override
        public int compare(byte[] a, byte[] b) {
            int i;
            int length = Math.min(a.length, b.length);
            if (a == b) {
                return 0;
            }
            for (i = 0; i < this.metric_width; ++i) {
                if (a[i] == b[i]) continue;
                return (a[i] & 0xFF) - (b[i] & 0xFF);
            }
            i += 4;
            while (i < length) {
                if (a[i] != b[i]) {
                    return (a[i] & 0xFF) - (b[i] & 0xFF);
                }
                ++i;
            }
            return a.length - b.length;
        }
    }

    private class GroupByAndAggregateCB
    implements Callback<DataPoints[], TreeMap<byte[], Span>> {
        private GroupByAndAggregateCB() {
        }

        public DataPoints[] call(TreeMap<byte[], Span> spans) throws Exception {
            if (TsdbQuery.this.query_stats != null) {
                TsdbQuery.this.query_stats.addStat(TsdbQuery.this.query_index, QueryStats.QueryStat.QUERY_SCAN_TIME, System.nanoTime() - TsdbQuery.this.scan_start_time);
            }
            if (spans == null || spans.size() <= 0) {
                if (TsdbQuery.this.query_stats != null) {
                    TsdbQuery.this.query_stats.addStat(TsdbQuery.this.query_index, QueryStats.QueryStat.GROUP_BY_TIME, 0L);
                }
                return NO_RESULT;
            }
            if (TsdbQuery.this.aggregator == Aggregators.NONE) {
                DataPoints[] groups = new SpanGroup[spans.size()];
                int i = 0;
                for (Span span : spans.values()) {
                    SpanGroup group = new SpanGroup(TsdbQuery.this.tsdb, TsdbQuery.this.getScanStartTimeSeconds(), TsdbQuery.this.getScanEndTimeSeconds(), null, TsdbQuery.this.rate, TsdbQuery.this.rate_options, TsdbQuery.this.aggregator, TsdbQuery.this.downsampler, TsdbQuery.this.getStartTime(), TsdbQuery.this.getEndTime(), TsdbQuery.this.query_index);
                    group.add(span);
                    groups[i++] = group;
                }
                return groups;
            }
            if (TsdbQuery.this.group_bys == null) {
                SpanGroup group = new SpanGroup(TsdbQuery.this.tsdb, TsdbQuery.this.getScanStartTimeSeconds(), TsdbQuery.this.getScanEndTimeSeconds(), spans.values(), TsdbQuery.this.rate, TsdbQuery.this.rate_options, TsdbQuery.this.aggregator, TsdbQuery.this.downsampler, TsdbQuery.this.getStartTime(), TsdbQuery.this.getEndTime(), TsdbQuery.this.query_index);
                if (TsdbQuery.this.query_stats != null) {
                    TsdbQuery.this.query_stats.addStat(TsdbQuery.this.query_index, QueryStats.QueryStat.GROUP_BY_TIME, 0L);
                }
                return new SpanGroup[]{group};
            }
            Bytes.ByteMap groups = new Bytes.ByteMap();
            short value_width = ((TsdbQuery)TsdbQuery.this).tsdb.tag_values.width();
            byte[] group = new byte[TsdbQuery.this.group_bys.size() * value_width];
            for (Map.Entry<byte[], Span> entry : spans.entrySet()) {
                byte[] row = entry.getKey();
                byte[] value_id = null;
                int i = 0;
                for (byte[] tag_id : TsdbQuery.this.group_bys) {
                    value_id = Tags.getValueId(TsdbQuery.this.tsdb, row, tag_id);
                    if (value_id == null) break;
                    System.arraycopy(value_id, 0, group, i, value_width);
                    i += value_width;
                }
                if (value_id == null) {
                    LOG.error("WTF? Dropping span for row " + Arrays.toString(row) + " as it had no matching tag from the requested groups, which is unexpected. Query=" + this);
                    continue;
                }
                SpanGroup thegroup = (SpanGroup)groups.get((Object)group);
                if (thegroup == null) {
                    thegroup = new SpanGroup(TsdbQuery.this.tsdb, TsdbQuery.this.getScanStartTimeSeconds(), TsdbQuery.this.getScanEndTimeSeconds(), null, TsdbQuery.this.rate, TsdbQuery.this.rate_options, TsdbQuery.this.aggregator, TsdbQuery.this.downsampler, TsdbQuery.this.getStartTime(), TsdbQuery.this.getEndTime(), TsdbQuery.this.query_index);
                    byte[] group_copy = new byte[group.length];
                    System.arraycopy(group, 0, group_copy, 0, group.length);
                    groups.put((Object)group_copy, (Object)thegroup);
                }
                thegroup.add(entry.getValue());
            }
            if (TsdbQuery.this.query_stats != null) {
                TsdbQuery.this.query_stats.addStat(TsdbQuery.this.query_index, QueryStats.QueryStat.GROUP_BY_TIME, 0L);
            }
            return groups.values().toArray(new SpanGroup[groups.size()]);
        }
    }
}

