/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.examples;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.opentsdb.core.TSDB;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.Config;

public class AddDataExample {
    private static String pathToConfigFile;

    public static void processArgs(String[] args) {
        if (args != null && args.length > 0) {
            pathToConfigFile = args[0];
        }
    }

    public static void main(String[] args) throws Exception {
        AddDataExample.processArgs(args);
        Config config = pathToConfigFile != null && !pathToConfigFile.isEmpty() ? new Config(pathToConfigFile) : new Config(true);
        TSDB tsdb = new TSDB(config);
        String metricName = "my.tsdb.test.metric";
        try {
            byte[] byteMetricUID = tsdb.getUID(UniqueId.UniqueIdType.METRIC, metricName);
        }
        catch (IllegalArgumentException iae) {
            System.out.println("Metric name not valid.");
            iae.printStackTrace();
            System.exit(1);
        }
        catch (NoSuchUniqueName nsune) {
            byte[] byArray = tsdb.assignUid("metric", metricName);
        }
        long timestamp = System.currentTimeMillis() / 1000L;
        long value = 314159L;
        HashMap<String, String> tags = new HashMap<String, String>(1);
        tags.put("script", "example1");
        long startTime1 = System.currentTimeMillis();
        int n = 100;
        ArrayList<Deferred<Object>> deferreds = new ArrayList<Deferred<Object>>(n);
        for (int i = 0; i < n; ++i) {
            Deferred<Object> deferred = tsdb.addPoint(metricName, timestamp, value + (long)i, (Map<String, String>)tags);
            deferreds.add(deferred);
            timestamp += 30L;
        }
        System.out.println("Waiting for deferred result to return...");
        Deferred.groupInOrder(deferreds).addErrback((Callback)new AddDataExample().new errBack()).addCallback((Callback)new AddDataExample().new succBack()).join();
        long elapsedTime1 = System.currentTimeMillis() - startTime1;
        System.out.println("\nAdding " + n + " points took: " + elapsedTime1 + " milliseconds.\n");
        tsdb.shutdown().join();
    }

    class succBack
    implements Callback<Object, ArrayList<Object>> {
        succBack() {
        }

        public Object call(ArrayList<Object> results) {
            System.out.println("Successfully wrote " + results.size() + " data points");
            return null;
        }
    }

    class errBack
    implements Callback<String, Exception> {
        errBack() {
        }

        public String call(Exception e) throws Exception {
            String message = ">>>>>>>>>>>Failure!>>>>>>>>>>>";
            System.err.println(message + " " + e.getMessage());
            e.printStackTrace();
            return message;
        }
    }
}

