/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.examples;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.Query;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.core.TSSubQuery;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.utils.Config;
import net.opentsdb.utils.DateTime;

public class QueryExample {
    public static void main(String[] args) throws IOException {
        String pathToConfigFile = args != null && args.length > 0 ? args[0] : null;
        Config config = pathToConfigFile != null && !pathToConfigFile.isEmpty() ? new Config(pathToConfigFile) : new Config(true);
        TSDB tsdb = new TSDB(config);
        TSQuery query = new TSQuery();
        query.setStart("1h-ago");
        TSSubQuery subQuery = new TSSubQuery();
        subQuery.setMetric("my.tsdb.test.metric");
        ArrayList<TagVFilter> filters = new ArrayList<TagVFilter>(1);
        filters.add(new TagVFilter.Builder().setType("literal_or").setFilter("example1").setTagk("script").setGroupBy(true).build());
        subQuery.setFilters(filters);
        subQuery.setAggregator("sum");
        ArrayList<TSSubQuery> subQueries = new ArrayList<TSSubQuery>(1);
        subQueries.add(subQuery);
        query.setQueries(subQueries);
        query.setMsResolution(true);
        query.validateAndSetQuery();
        Query[] tsdbqueries = query.buildQueries(tsdb);
        int nqueries = tsdbqueries.length;
        ArrayList results = new ArrayList(nqueries);
        ArrayList<Deferred<DataPoints[]>> deferreds = new ArrayList<Deferred<DataPoints[]>>(nqueries);
        for (int i = 0; i < nqueries; ++i) {
            deferreds.add(tsdbqueries[i].runAsync());
        }
        long startTime = DateTime.nanoTime();
        try {
            class QueriesCB
            implements Callback<Object, ArrayList<DataPoints[]>> {
                final /* synthetic */ ArrayList val$results;

                QueriesCB(ArrayList arrayList) {
                    this.val$results = arrayList;
                }

                public Object call(ArrayList<DataPoints[]> queryResults) throws Exception {
                    this.val$results.addAll(queryResults);
                    return null;
                }
            }
            class QueriesEB
            implements Callback<Object, Exception> {
                QueriesEB() {
                }

                public Object call(Exception e) throws Exception {
                    System.err.println("Queries failed");
                    e.printStackTrace();
                    return null;
                }
            }
            Deferred.groupInOrder(deferreds).addCallback((Callback)new QueriesCB(results)).addErrback((Callback)new QueriesEB()).join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double elapsedTime = DateTime.msFromNanoDiff(DateTime.nanoTime(), startTime);
        System.out.println("Query returned in: " + elapsedTime + " milliseconds.");
        Iterator iterator = results.iterator();
        while (iterator.hasNext()) {
            DataPoints[] dataSets;
            for (DataPoints data : dataSets = (DataPoints[])iterator.next()) {
                System.out.print(data.metricName());
                Map<String, String> resolvedTags = data.getTags();
                for (Map.Entry<String, String> pair : resolvedTags.entrySet()) {
                    System.out.print(" " + pair.getKey() + "=" + pair.getValue());
                }
                System.out.print("\n");
                for (DataPoint dp : data) {
                    System.out.println("  " + dp.timestamp() + " " + (dp.isInteger() ? (double)dp.longValue() : dp.doubleValue()));
                }
                System.out.println("");
            }
        }
        try {
            tsdb.shutdown().join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

