/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.graph;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.meta.Annotation;
import net.opentsdb.utils.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Plot {
    private static final Logger LOG = LoggerFactory.getLogger(Plot.class);
    private static final long UNSIGNED = 0xFFFFFFFFL;
    private static final TimeZone DEFAULT_TZ = TimeZone.getDefault();
    private final int start_time;
    private final int end_time;
    private ArrayList<DataPoints> datapoints = new ArrayList();
    private List<Annotation> globals = null;
    private ArrayList<String> options = new ArrayList();
    private Map<String, String> params;
    private static final short MIN_PIXELS = 100;
    private short width = (short)1024;
    private short height = (short)768;
    private final int utc_offset;

    public Plot(long start_time, long end_time) {
        this(start_time, end_time, DEFAULT_TZ);
    }

    public Plot(long start_time, long end_time, TimeZone tz) {
        if ((start_time & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("Invalid start time: " + start_time);
        }
        if ((end_time & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("Invalid end time: " + end_time);
        }
        if (start_time >= end_time) {
            throw new IllegalArgumentException("start time (" + start_time + ") is greater than or equal to end time: " + end_time);
        }
        this.start_time = (int)start_time;
        this.end_time = (int)end_time;
        if (tz == null) {
            tz = DEFAULT_TZ;
        }
        this.utc_offset = tz.getOffset(System.currentTimeMillis()) / 1000;
    }

    public void setParams(Map<String, String> params) {
        String[] y_format_keys;
        for (String k : y_format_keys = new String[]{"format y", "format y2"}) {
            if (!params.containsKey(k)) continue;
            params.put(k, URLDecoder.decode(params.get(k)));
        }
        this.params = params;
    }

    public void setDimensions(short width, short height) {
        if (width < 100 || height < 100) {
            String what = width < 100 ? "width" : "height";
            throw new IllegalArgumentException(what + " smaller than " + 100 + " in " + width + 'x' + height);
        }
        this.width = width;
        this.height = height;
    }

    public void setGlobals(List<Annotation> globals) {
        this.globals = globals;
    }

    public void add(DataPoints datapoints, String options) {
        this.datapoints.add(datapoints);
        this.options.add(options);
    }

    public Iterable<DataPoints> getDataPoints() {
        return this.datapoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dumpToFiles(String basepath) throws IOException {
        int npoints = 0;
        int nseries = this.datapoints.size();
        String[] datafiles = nseries > 0 ? new String[nseries] : null;
        FileSystem.checkDirectory(new File(basepath).getParent(), true, true);
        for (int i = 0; i < nseries; ++i) {
            datafiles[i] = basepath + "_" + i + ".dat";
            PrintWriter datafile = new PrintWriter(datafiles[i]);
            try {
                for (DataPoint d : this.datapoints.get(i)) {
                    long ts = d.timestamp() / 1000L;
                    if (d.isInteger()) {
                        datafile.print(ts + (long)this.utc_offset);
                        datafile.print(' ');
                        datafile.print(d.longValue());
                    } else {
                        double value = d.doubleValue();
                        if (Double.isInfinite(value)) {
                            throw new IllegalStateException("Infinity found in datapoints #" + i + ": " + value + " d=" + d);
                        }
                        if (Double.isNaN(value)) continue;
                        datafile.print(ts + (long)this.utc_offset);
                        datafile.print(' ');
                        datafile.print(value);
                    }
                    datafile.print('\n');
                    if (ts < ((long)this.start_time & 0xFFFFFFFFL) || ts > ((long)this.end_time & 0xFFFFFFFFL)) continue;
                    ++npoints;
                }
                continue;
            }
            finally {
                datafile.close();
            }
        }
        if (npoints == 0) {
            this.params.put("yrange", "[0:10]");
        }
        this.writeGnuplotScript(basepath, datafiles);
        return npoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void writeGnuplotScript(String basepath, String[] datafiles) throws IOException {
        String script_path = basepath + ".gnuplot";
        PrintWriter gp = new PrintWriter(script_path);
        try {
            void var11_18;
            DataPoints dp;
            void var11_15;
            int nseries;
            gp.append("set term png small size ").append(Short.toString(this.width)).append(",").append(Short.toString(this.height));
            String smooth = this.params.remove("smooth");
            String fgcolor = this.params.remove("fgcolor");
            String style = this.params.remove("style");
            String bgcolor = this.params.remove("bgcolor");
            if (fgcolor != null && bgcolor == null) {
                bgcolor = "xFFFFFF";
            }
            if (bgcolor != null) {
                if (fgcolor != null && "transparent".equals(bgcolor)) {
                    bgcolor = "transparent xFFFFFF";
                }
                gp.append(' ').append(bgcolor);
            }
            if (fgcolor != null) {
                gp.append(' ').append(fgcolor);
            }
            gp.append("\nset xdata time\nset timefmt \"%s\"\nif (GPVAL_VERSION < 4.6) set xtics rotate; else set xtics rotate right\nset output \"").append(basepath + ".png").append("\"\nset xrange [\"").append(String.valueOf(((long)this.start_time & 0xFFFFFFFFL) + (long)this.utc_offset)).append("\":\"").append(String.valueOf(((long)this.end_time & 0xFFFFFFFFL) + (long)this.utc_offset)).append("\"]\n");
            if (!this.params.containsKey("format x")) {
                gp.append("set format x \"").append(this.xFormat()).append("\"\n");
            }
            if ((nseries = this.datapoints.size()) > 0) {
                gp.write("set grid\nset style data ");
                gp.append(style != null ? style : "linespoint").append("\n");
                if (!this.params.containsKey("key")) {
                    gp.write("set key right box\n");
                }
            } else {
                gp.write("unset key\n");
                if (this.params == null || !this.params.containsKey("label")) {
                    gp.write("set label \"No data\" at graph 0.5,0.9 center\n");
                }
            }
            if (this.params != null) {
                for (Map.Entry entry : this.params.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (value != null) {
                        gp.append("set ").append(key).append(' ').append(value).write(10);
                        continue;
                    }
                    gp.append("unset ").append(key).write(10);
                }
            }
            for (String string : this.options) {
                if (!string.contains("x1y2")) continue;
                gp.write("set y2tics border\n");
                break;
            }
            ArrayList<Annotation> notes = new ArrayList<Annotation>();
            boolean bl = false;
            while (var11_15 < nseries) {
                dp = this.datapoints.get((int)var11_15);
                List<Annotation> series_notes = dp.getAnnotations();
                if (series_notes != null && !series_notes.isEmpty()) {
                    notes.addAll(series_notes);
                }
                ++var11_15;
            }
            if (this.globals != null) {
                notes.addAll(this.globals);
            }
            if (notes.size() > 0) {
                Collections.sort(notes);
                for (Annotation note : notes) {
                    String ts = Long.toString(note.getStartTime());
                    String value = new String(note.getDescription());
                    gp.append("set arrow from \"").append(ts).append("\", graph 0 to \"");
                    gp.append(ts).append("\", graph 1 nohead ls 3\n");
                    gp.append("set object rectangle at \"").append(ts);
                    gp.append("\", graph 0 size char (strlen(\"").append(value);
                    gp.append("\")), char 1 front fc rgbcolor \"white\"\n");
                    gp.append("set label \"").append(value).append("\" at \"");
                    gp.append(ts).append("\", graph 0 front center\n");
                }
            }
            gp.write("plot ");
            boolean bl2 = false;
            while (var11_18 < nseries) {
                dp = this.datapoints.get((int)var11_18);
                String title = dp.metricName() + dp.getTags();
                gp.append(" \"").append(datafiles[var11_18]).append("\" using 1:2");
                if (smooth != null) {
                    gp.append(" smooth ").append(smooth);
                }
                gp.append(" title \"").append(title).write(34);
                String opts = this.options.get((int)var11_18);
                if (!opts.isEmpty()) {
                    gp.append(' ').write(opts);
                }
                if (var11_18 != nseries - 1) {
                    gp.print(", \\");
                }
                gp.write(10);
                ++var11_18;
            }
            if (nseries == 0) {
                gp.write(48);
            }
        }
        finally {
            gp.close();
            LOG.info("Wrote Gnuplot script to " + script_path);
        }
    }

    private String xFormat() {
        long timespan = ((long)this.end_time & 0xFFFFFFFFL) - ((long)this.start_time & 0xFFFFFFFFL);
        if (timespan < 2100L) {
            return "%H:%M:%S";
        }
        if (timespan < 86400L) {
            return "%H:%M";
        }
        if (timespan < 604800L) {
            return "%a %H:%M";
        }
        if (timespan < 1209600L) {
            return "%a %d %H:%M";
        }
        if (timespan < 7776000L) {
            return "%b %d";
        }
        return "%Y/%m/%d";
    }
}

