/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.meta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.opentsdb.core.Const;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.TSDB;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Annotation
implements Comparable<Annotation> {
    private static final Logger LOG = LoggerFactory.getLogger(Annotation.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final byte PREFIX = 1;
    private static final byte[] FAMILY = "t".getBytes(CHARSET);
    private String tsuid = "";
    private long start_time = 0L;
    private long end_time = 0L;
    private String description = "";
    private String notes = "";
    private HashMap<String, String> custom = null;
    private final HashMap<String, Boolean> changed = new HashMap();

    public Annotation() {
        this.initializeChangedMap();
    }

    public String toString() {
        return "TSUID: " + this.tsuid + " Start: " + this.start_time + "  Description: " + this.description;
    }

    @Override
    public int compareTo(Annotation note) {
        return this.start_time > note.start_time ? 1 : (this.start_time < note.start_time ? -1 : 0);
    }

    public Deferred<Boolean> syncToStorage(final TSDB tsdb, final Boolean overwrite) {
        final class StoreCB
        implements Callback<Deferred<Boolean>, Annotation> {
            StoreCB() {
            }

            public Deferred<Boolean> call(Annotation stored_note) throws Exception {
                byte[] original_note;
                byte[] byArray = original_note = stored_note == null ? new byte[]{} : stored_note.getStorageJSON();
                if (stored_note != null) {
                    Annotation.this.syncNote(stored_note, overwrite);
                }
                byte[] tsuid_byte = Annotation.this.tsuid != null && !Annotation.this.tsuid.isEmpty() ? UniqueId.stringToUid(Annotation.this.tsuid) : null;
                PutRequest put = new PutRequest(tsdb.dataTable(), Annotation.getRowKey(Annotation.this.start_time, tsuid_byte), FAMILY, Annotation.getQualifier(Annotation.this.start_time), Annotation.this.getStorageJSON());
                return tsdb.getClient().compareAndSet(put, original_note);
            }
        }
        if (this.start_time < 1L) {
            throw new IllegalArgumentException("The start timestamp has not been set");
        }
        boolean has_changes = false;
        for (Map.Entry<String, Boolean> entry : this.changed.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            has_changes = true;
            break;
        }
        if (!has_changes) {
            LOG.debug(this + " does not have changes, skipping sync to storage");
            throw new IllegalStateException("No changes detected in Annotation data");
        }
        if (this.tsuid != null && !this.tsuid.isEmpty()) {
            return Annotation.getAnnotation(tsdb, UniqueId.stringToUid(this.tsuid), this.start_time).addCallbackDeferring((Callback)new StoreCB());
        }
        return Annotation.getAnnotation(tsdb, this.start_time).addCallbackDeferring((Callback)new StoreCB());
    }

    public Deferred<Object> delete(TSDB tsdb) {
        if (this.start_time < 1L) {
            throw new IllegalArgumentException("The start timestamp has not been set");
        }
        byte[] tsuid_byte = this.tsuid != null && !this.tsuid.isEmpty() ? UniqueId.stringToUid(this.tsuid) : null;
        DeleteRequest delete = new DeleteRequest(tsdb.dataTable(), Annotation.getRowKey(this.start_time, tsuid_byte), FAMILY, Annotation.getQualifier(this.start_time));
        return tsdb.getClient().delete(delete);
    }

    public static Deferred<Annotation> getAnnotation(TSDB tsdb, long start_time) {
        return Annotation.getAnnotation(tsdb, (byte[])null, start_time);
    }

    public static Deferred<Annotation> getAnnotation(TSDB tsdb, String tsuid, long start_time) {
        if (tsuid != null && !tsuid.isEmpty()) {
            return Annotation.getAnnotation(tsdb, UniqueId.stringToUid(tsuid), start_time);
        }
        return Annotation.getAnnotation(tsdb, (byte[])null, start_time);
    }

    public static Deferred<Annotation> getAnnotation(TSDB tsdb, byte[] tsuid, long start_time) {
        GetRequest get = new GetRequest(tsdb.dataTable(), Annotation.getRowKey(start_time, tsuid));
        get.family(FAMILY);
        get.qualifier(Annotation.getQualifier(start_time));
        final class GetCB
        implements Callback<Deferred<Annotation>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<Annotation> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                Annotation note = JSON.parseToObject(row.get(0).value(), Annotation.class);
                return Deferred.fromResult((Object)note);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public static Deferred<List<Annotation>> getGlobalAnnotations(final TSDB tsdb, final long start_time, final long end_time) {
        if (end_time < 1L) {
            throw new IllegalArgumentException("The end timestamp has not been set");
        }
        if (end_time < start_time) {
            throw new IllegalArgumentException("The end timestamp cannot be less than the start timestamp");
        }
        final class ScannerCB
        implements Callback<Deferred<List<Annotation>>, ArrayList<ArrayList<KeyValue>>> {
            final Scanner scanner;
            final ArrayList<Annotation> annotations = new ArrayList();

            public ScannerCB() {
                byte[] start = new byte[Const.SALT_WIDTH() + TSDB.metrics_width() + 4];
                byte[] end = new byte[Const.SALT_WIDTH() + TSDB.metrics_width() + 4];
                long normalized_start = start_time - start_time % 3600L;
                long normalized_end = end_time - end_time % 3600L + 3600L;
                Bytes.setInt((byte[])start, (int)((int)normalized_start), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
                Bytes.setInt((byte[])end, (int)((int)normalized_end), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
                this.scanner = tsdb.getClient().newScanner(tsdb.dataTable());
                this.scanner.setStartKey(start);
                this.scanner.setStopKey(end);
                this.scanner.setFamily(FAMILY);
            }

            public Deferred<List<Annotation>> scan() {
                return this.scanner.nextRows().addCallbackDeferring((Callback)this);
            }

            public Deferred<List<Annotation>> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null || rows.isEmpty()) {
                    return Deferred.fromResult(this.annotations);
                }
                for (ArrayList<KeyValue> row : rows) {
                    for (KeyValue column : row) {
                        Annotation note;
                        if (column.qualifier().length != 3 && column.qualifier().length != 5 || column.qualifier()[0] != Annotation.PREFIX() || (note = JSON.parseToObject(column.value(), Annotation.class)).start_time < start_time || note.end_time > end_time) continue;
                        this.annotations.add(note);
                    }
                }
                return this.scan();
            }
        }
        return new ScannerCB().scan();
    }

    public static Deferred<Integer> deleteRange(final TSDB tsdb, final byte[] tsuid, final long start_time, final long end_time) {
        if (end_time < 1L) {
            throw new IllegalArgumentException("The end timestamp has not been set");
        }
        if (end_time < start_time) {
            throw new IllegalArgumentException("The end timestamp cannot be less than the start timestamp");
        }
        final ArrayList delete_requests = new ArrayList();
        int width = tsuid != null ? Const.SALT_WIDTH() + tsuid.length + 4 : Const.SALT_WIDTH() + TSDB.metrics_width() + 4;
        final byte[] start_row = new byte[width];
        final byte[] end_row = new byte[width];
        long start = start_time / 1000L;
        long end = end_time / 1000L;
        long normalized_start = start - start % 3600L;
        long normalized_end = end - end % 3600L + 3600L;
        Bytes.setInt((byte[])start_row, (int)((int)normalized_start), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
        Bytes.setInt((byte[])end_row, (int)((int)normalized_end), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
        if (tsuid != null) {
            System.arraycopy(tsuid, 0, start_row, Const.SALT_WIDTH(), TSDB.metrics_width());
            System.arraycopy(tsuid, 0, end_row, Const.SALT_WIDTH(), TSDB.metrics_width());
            width = Const.SALT_WIDTH() + TSDB.metrics_width() + 4;
            int remainder = tsuid.length - TSDB.metrics_width();
            System.arraycopy(tsuid, TSDB.metrics_width(), start_row, width, remainder);
            System.arraycopy(tsuid, TSDB.metrics_width(), end_row, width, remainder);
        }
        final class ScannerCB
        implements Callback<Deferred<List<Deferred<Object>>>, ArrayList<ArrayList<KeyValue>>> {
            final Scanner scanner;

            public ScannerCB() {
                this.scanner = tsdb.getClient().newScanner(tsdb.dataTable());
                this.scanner.setStartKey(start_row);
                this.scanner.setStopKey(end_row);
                this.scanner.setFamily(FAMILY);
                if (tsuid != null) {
                    ArrayList<String> tsuids = new ArrayList<String>(1);
                    tsuids.add(UniqueId.uidToString(tsuid));
                    Internal.createAndSetTSUIDFilter(this.scanner, tsuids);
                }
            }

            public Deferred<List<Deferred<Object>>> scan() {
                return this.scanner.nextRows().addCallbackDeferring((Callback)this);
            }

            public Deferred<List<Deferred<Object>>> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                if (rows == null || rows.isEmpty()) {
                    return Deferred.fromResult((Object)delete_requests);
                }
                for (ArrayList<KeyValue> row : rows) {
                    long base_time = Internal.baseTime(tsdb, row.get(0).key());
                    for (KeyValue column : row) {
                        long timestamp;
                        if (column.qualifier().length != 3 && column.qualifier().length != 5 || column.qualifier()[0] != Annotation.PREFIX() || (timestamp = Annotation.timeFromQualifier(column.qualifier(), base_time)) < start_time || timestamp > end_time) continue;
                        DeleteRequest delete = new DeleteRequest(tsdb.dataTable(), column.key(), FAMILY, column.qualifier());
                        delete_requests.add(tsdb.getClient().delete(delete));
                    }
                }
                return this.scan();
            }
        }
        final class ScannerDoneCB
        implements Callback<Deferred<ArrayList<Object>>, List<Deferred<Object>>> {
            final /* synthetic */ List val$delete_requests;

            ScannerDoneCB(List list) {
                this.val$delete_requests = list;
            }

            public Deferred<ArrayList<Object>> call(List<Deferred<Object>> deletes) throws Exception {
                return Deferred.group((Collection)this.val$delete_requests);
            }
        }
        Deferred scanner_done = new ScannerCB().scan().addCallbackDeferring((Callback)new ScannerDoneCB(delete_requests));
        final class GroupCB
        implements Callback<Deferred<Integer>, ArrayList<Object>> {
            GroupCB() {
            }

            public Deferred<Integer> call(ArrayList<Object> deletes) throws Exception {
                return Deferred.fromResult((Object)deletes.size());
            }
        }
        return scanner_done.addCallbackDeferring((Callback)new GroupCB());
    }

    public static byte PREFIX() {
        return 1;
    }

    @VisibleForTesting
    byte[] getStorageJSON() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
            json.writeStartObject();
            if (this.tsuid != null && !this.tsuid.isEmpty()) {
                json.writeStringField("tsuid", this.tsuid);
            }
            json.writeNumberField("startTime", this.start_time);
            json.writeNumberField("endTime", this.end_time);
            json.writeStringField("description", this.description);
            json.writeStringField("notes", this.notes);
            if (this.custom == null) {
                json.writeNullField("custom");
            } else {
                TreeMap<String, String> sorted_custom = new TreeMap<String, String>(this.custom);
                json.writeObjectField("custom", sorted_custom);
            }
            json.writeEndObject();
            json.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize Annotation", e);
        }
    }

    private void syncNote(Annotation note, boolean overwrite) {
        if (note.start_time > 0L && (note.start_time < this.start_time || this.start_time == 0L)) {
            this.start_time = note.start_time;
        }
        if (!overwrite && !this.changed.get("end_time").booleanValue()) {
            this.end_time = note.end_time;
        }
        if (!overwrite && !this.changed.get("description").booleanValue()) {
            this.description = note.description;
        }
        if (!overwrite && !this.changed.get("notes").booleanValue()) {
            this.notes = note.notes;
        }
        if (!overwrite && !this.changed.get("custom").booleanValue()) {
            this.custom = note.custom;
        }
        this.initializeChangedMap();
    }

    private void initializeChangedMap() {
        this.changed.put("end_time", false);
        this.changed.put("description", false);
        this.changed.put("notes", false);
        this.changed.put("custom", false);
    }

    private static byte[] getQualifier(long start_time) {
        byte[] qualifier;
        if (start_time < 1L) {
            throw new IllegalArgumentException("The start timestamp has not been set");
        }
        long timestamp = start_time;
        if (timestamp % 1000L == 0L) {
            timestamp /= 1000L;
        }
        if ((timestamp & 0xFFFFFFFF00000000L) != 0L) {
            long base_time = timestamp / 1000L - timestamp / 1000L % 3600L;
            qualifier = new byte[5];
            int offset = (int)(timestamp - base_time * 1000L);
            System.arraycopy(Bytes.fromInt((int)offset), 0, qualifier, 1, 4);
        } else {
            long base_time = timestamp - timestamp % 3600L;
            qualifier = new byte[3];
            short offset = (short)(timestamp - base_time);
            System.arraycopy(Bytes.fromShort((short)offset), 0, qualifier, 1, 2);
        }
        qualifier[0] = 1;
        return qualifier;
    }

    private static long timeFromQualifier(byte[] qualifier, long base_time) {
        if (qualifier.length == 3) {
            long offset = Bytes.getUnsignedShort((byte[])qualifier, (int)1);
            return (base_time + offset) * 1000L;
        }
        long offset = Bytes.getUnsignedInt((byte[])qualifier, (int)1);
        return base_time * 1000L + offset;
    }

    private static byte[] getRowKey(long start_time, byte[] tsuid) {
        if (start_time < 1L) {
            throw new IllegalArgumentException("The start timestamp has not been set");
        }
        long base_time = (start_time & 0xFFFFFFFF00000000L) != 0L ? start_time / 1000L - start_time / 1000L % 3600L : start_time - start_time % 3600L;
        if (tsuid == null || tsuid.length < 1) {
            byte[] row = new byte[Const.SALT_WIDTH() + TSDB.metrics_width() + 4];
            Bytes.setInt((byte[])row, (int)((int)base_time), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
            return row;
        }
        byte[] row = new byte[Const.SALT_WIDTH() + 4 + tsuid.length];
        System.arraycopy(tsuid, 0, row, Const.SALT_WIDTH(), TSDB.metrics_width());
        Bytes.setInt((byte[])row, (int)((int)base_time), (int)(Const.SALT_WIDTH() + TSDB.metrics_width()));
        System.arraycopy(tsuid, TSDB.metrics_width(), row, Const.SALT_WIDTH() + TSDB.metrics_width() + 4, tsuid.length - TSDB.metrics_width());
        RowKey.prefixKeyWithSalt(row);
        return row;
    }

    public final String getTSUID() {
        return this.tsuid;
    }

    public final long getStartTime() {
        return this.start_time;
    }

    public final long getEndTime() {
        return this.end_time;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getNotes() {
        return this.notes;
    }

    public final Map<String, String> getCustom() {
        return this.custom;
    }

    public void setTSUID(String tsuid) {
        this.tsuid = tsuid;
    }

    public void setStartTime(long start_time) {
        this.start_time = start_time;
    }

    public void setEndTime(long end_time) {
        if (this.end_time != end_time) {
            this.end_time = end_time;
            this.changed.put("end_time", true);
        }
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.description = description;
            this.changed.put("description", true);
        }
    }

    public void setNotes(String notes) {
        if (!this.notes.equals(notes)) {
            this.notes = notes;
            this.changed.put("notes", true);
        }
    }

    public void setCustom(Map<String, String> custom) {
        if (this.custom != null || custom != null) {
            this.changed.put("custom", true);
            this.custom = new HashMap<String, String>(custom);
        }
    }
}

