/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.meta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.TSDB;
import net.opentsdb.meta.UIDMeta;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.Bytes;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class TSMeta {
    private static final Logger LOG = LoggerFactory.getLogger(TSMeta.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    public static final byte[] FAMILY = "name".getBytes(CHARSET);
    private static final byte[] META_QUALIFIER = "ts_meta".getBytes(CHARSET);
    private static final byte[] COUNTER_QUALIFIER = "ts_ctr".getBytes(CHARSET);
    private String tsuid = "";
    private UIDMeta metric = null;
    private ArrayList<UIDMeta> tags = null;
    private String display_name = "";
    private String description = "";
    private String notes = "";
    private long created = 0L;
    private HashMap<String, String> custom = null;
    private String units = "";
    private String data_type = "";
    private int retention = 0;
    private double max = Double.NaN;
    private double min = Double.NaN;
    private long last_received = 0L;
    private long total_dps;
    private final HashMap<String, Boolean> changed = new HashMap();

    public TSMeta() {
        this.initializeChangedMap();
    }

    public TSMeta(String tsuid) {
        this.tsuid = tsuid;
        this.initializeChangedMap();
    }

    public TSMeta(byte[] tsuid, long created) {
        this.tsuid = UniqueId.uidToString(tsuid);
        this.created = created > 9999999999L ? created / 1000L : created;
        this.initializeChangedMap();
        this.changed.put("created", true);
    }

    public String toString() {
        return this.tsuid;
    }

    public Deferred<Object> delete(TSDB tsdb) {
        if (this.tsuid == null || this.tsuid.isEmpty()) {
            throw new IllegalArgumentException("Missing UID");
        }
        DeleteRequest delete = new DeleteRequest(tsdb.metaTable(), UniqueId.stringToUid(this.tsuid), FAMILY, META_QUALIFIER);
        return tsdb.getClient().delete(delete);
    }

    public Deferred<Boolean> syncToStorage(final TSDB tsdb, final boolean overwrite) {
        if (this.tsuid == null || this.tsuid.isEmpty()) {
            throw new IllegalArgumentException("Missing TSUID");
        }
        boolean has_changes = false;
        for (Map.Entry<String, Boolean> entry : this.changed.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            has_changes = true;
            break;
        }
        if (!has_changes) {
            LOG.debug(this + " does not have changes, skipping sync to storage");
            throw new IllegalStateException("No changes detected in TSUID meta data");
        }
        List<byte[]> parsed_tags = UniqueId.getTagsFromTSUID(this.tsuid);
        ArrayList<Deferred> uid_group = new ArrayList<Deferred>(parsed_tags.size() + 1);
        byte[] metric_uid = UniqueId.stringToUid(this.tsuid.substring(0, TSDB.metrics_width() * 2));
        class UidCB
        implements Callback<Object, String> {
            UidCB() {
            }

            public Object call(String name) throws Exception {
                return null;
            }
        }
        uid_group.add(tsdb.getUidName(UniqueId.UniqueIdType.METRIC, metric_uid).addCallback((Callback)new UidCB()));
        int idx = 0;
        for (byte[] tag : parsed_tags) {
            if (idx % 2 == 0) {
                uid_group.add(tsdb.getUidName(UniqueId.UniqueIdType.TAGK, tag).addCallback((Callback)new UidCB()));
            } else {
                uid_group.add(tsdb.getUidName(UniqueId.UniqueIdType.TAGV, tag).addCallback((Callback)new UidCB()));
            }
            ++idx;
        }
        final class ValidateCB
        implements Callback<Deferred<Boolean>, ArrayList<Object>> {
            private final TSMeta local_meta;

            public ValidateCB() {
                this.local_meta = local_meta;
            }

            public Deferred<Boolean> call(ArrayList<Object> validated) throws Exception {
                return TSMeta.getFromStorage(tsdb, UniqueId.stringToUid(TSMeta.this.tsuid)).addCallbackDeferring((Callback)new 1ValidateCB.StoreCB());
            }

            final class 1ValidateCB.StoreCB
            implements Callback<Deferred<Boolean>, TSMeta> {
                1ValidateCB.StoreCB() {
                }

                public Deferred<Boolean> call(TSMeta stored_meta) throws Exception {
                    if (stored_meta == null) {
                        throw new IllegalArgumentException("Requested TSMeta did not exist");
                    }
                    byte[] original_meta = stored_meta.getStorageJSON();
                    local_meta.syncMeta(stored_meta, overwrite);
                    PutRequest put = new PutRequest(tsdb.metaTable(), UniqueId.stringToUid(local_meta.tsuid), FAMILY, META_QUALIFIER, local_meta.getStorageJSON());
                    return tsdb.getClient().compareAndSet(put, original_meta);
                }
            }
        }
        return Deferred.group(uid_group).addCallbackDeferring((Callback)new ValidateCB());
    }

    public Deferred<Boolean> storeNew(TSDB tsdb) {
        if (this.tsuid == null || this.tsuid.isEmpty()) {
            throw new IllegalArgumentException("Missing TSUID");
        }
        PutRequest put = new PutRequest(tsdb.metaTable(), UniqueId.stringToUid(this.tsuid), FAMILY, META_QUALIFIER, this.getStorageJSON());
        final class PutCB
        implements Callback<Deferred<Boolean>, Object> {
            PutCB() {
            }

            public Deferred<Boolean> call(Object arg0) throws Exception {
                return Deferred.fromResult((Object)true);
            }
        }
        return tsdb.getClient().put(put).addCallbackDeferring((Callback)new PutCB());
    }

    public static Deferred<TSMeta> getTSMeta(TSDB tsdb, String tsuid) {
        return TSMeta.getFromStorage(tsdb, UniqueId.stringToUid(tsuid)).addCallbackDeferring((Callback)new LoadUIDs(tsdb, tsuid));
    }

    public static Deferred<TSMeta> parseFromColumn(TSDB tsdb, KeyValue column, boolean load_uidmetas) {
        if (column.value() == null || column.value().length < 1) {
            throw new IllegalArgumentException("Empty column value");
        }
        TSMeta parsed_meta = JSON.parseToObject(column.value(), TSMeta.class);
        if (parsed_meta.tsuid == null || parsed_meta.tsuid.isEmpty()) {
            parsed_meta.tsuid = UniqueId.uidToString(column.key());
        }
        Deferred<TSMeta> meta = TSMeta.getFromStorage(tsdb, UniqueId.stringToUid(parsed_meta.tsuid));
        if (!load_uidmetas) {
            return meta;
        }
        return meta.addCallbackDeferring((Callback)new LoadUIDs(tsdb, parsed_meta.tsuid));
    }

    public static Deferred<Boolean> metaExistsInStorage(TSDB tsdb, String tsuid) {
        GetRequest get = new GetRequest(tsdb.metaTable(), UniqueId.stringToUid(tsuid));
        get.family(FAMILY);
        get.qualifier(META_QUALIFIER);
        final class ExistsCB
        implements Callback<Boolean, ArrayList<KeyValue>> {
            ExistsCB() {
            }

            public Boolean call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty() || row.get(0).value() == null) {
                    return false;
                }
                return true;
            }
        }
        return tsdb.getClient().get(get).addCallback((Callback)new ExistsCB());
    }

    public static Deferred<Boolean> counterExistsInStorage(TSDB tsdb, byte[] tsuid) {
        GetRequest get = new GetRequest(tsdb.metaTable(), tsuid);
        get.family(FAMILY);
        get.qualifier(COUNTER_QUALIFIER);
        final class ExistsCB
        implements Callback<Boolean, ArrayList<KeyValue>> {
            ExistsCB() {
            }

            public Boolean call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty() || row.get(0).value() == null) {
                    return false;
                }
                return true;
            }
        }
        return tsdb.getClient().get(get).addCallback((Callback)new ExistsCB());
    }

    public static Deferred<Long> incrementAndGetCounter(final TSDB tsdb, final byte[] tsuid) {
        AtomicIncrementRequest inc = new AtomicIncrementRequest(tsdb.metaTable(), tsuid, FAMILY, COUNTER_QUALIFIER);
        if (!tsdb.getConfig().enable_realtime_ts()) {
            return tsdb.getClient().atomicIncrement(inc);
        }
        final class TSMetaCB
        implements Callback<Deferred<Long>, Long> {
            TSMetaCB() {
            }

            public Deferred<Long> call(final Long incremented_value) throws Exception {
                LOG.debug("Value: " + incremented_value);
                if (incremented_value > 1L) {
                    return Deferred.fromResult((Object)incremented_value);
                }
                final TSMeta meta = new TSMeta(tsuid, System.currentTimeMillis() / 1000L);
                final class StoreNewCB
                implements Callback<Deferred<Long>, Boolean> {
                    StoreNewCB() {
                    }

                    public Deferred<Long> call(Boolean success) throws Exception {
                        if (!success.booleanValue()) {
                            LOG.warn("Unable to save metadata: " + meta);
                            return Deferred.fromResult((Object)0L);
                        }
                        LOG.info("Successfullly created new TSUID entry for: " + meta);
                        final class FetchNewCB
                        implements Callback<Deferred<Long>, TSMeta> {
                            final /* synthetic */ Long val$incremented_value;

                            FetchNewCB() {
                                this.val$incremented_value = l;
                            }

                            public Deferred<Long> call(TSMeta stored_meta) throws Exception {
                                tsdb.indexTSMeta(stored_meta);
                                final class TreeCB
                                implements Callback<Deferred<Long>, Boolean> {
                                    final /* synthetic */ Long val$incremented_value;

                                    TreeCB() {
                                        this.val$incremented_value = l;
                                    }

                                    public Deferred<Long> call(Boolean success) throws Exception {
                                        return Deferred.fromResult((Object)this.val$incremented_value);
                                    }
                                }
                                return tsdb.processTSMetaThroughTrees(stored_meta).addCallbackDeferring((Callback)new TreeCB(this, this.val$incremented_value));
                            }
                        }
                        return new LoadUIDs(tsdb, UniqueId.uidToString(tsuid)).call(meta).addCallbackDeferring((Callback)new FetchNewCB(this, incremented_value));
                    }
                }
                return meta.storeNew(tsdb).addCallbackDeferring((Callback)new StoreNewCB());
            }
        }
        return tsdb.getClient().atomicIncrement(inc).addCallbackDeferring((Callback)new TSMetaCB());
    }

    public static Deferred<Boolean> storeIfNecessary(final TSDB tsdb, final byte[] tsuid) {
        GetRequest get = new GetRequest(tsdb.metaTable(), tsuid);
        get.family(FAMILY);
        get.qualifier(META_QUALIFIER);
        final class ExistsCB
        implements Callback<Deferred<Boolean>, ArrayList<KeyValue>> {
            ExistsCB() {
            }

            public Deferred<Boolean> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty() || row.get(0).value() == null) {
                    final class CreateNewCB
                    implements Callback<Deferred<Boolean>, Object> {
                        final /* synthetic */ byte[] val$tsuid;
                        final /* synthetic */ TSDB val$tsdb;

                        CreateNewCB() {
                            this.val$tsuid = byArray;
                            this.val$tsdb = tSDB;
                        }

                        public Deferred<Boolean> call(Object arg0) throws Exception {
                            final TSMeta meta = new TSMeta(this.val$tsuid, System.currentTimeMillis() / 1000L);
                            final class StoreNewCB
                            implements Callback<Deferred<Boolean>, Boolean> {
                                StoreNewCB() {
                                }

                                public Deferred<Boolean> call(Boolean success) throws Exception {
                                    if (!success.booleanValue()) {
                                        LOG.warn("Unable to save metadata: " + meta);
                                        return Deferred.fromResult((Object)false);
                                    }
                                    LOG.info("Successfullly created new TSUID entry for: " + meta);
                                    final class FetchNewCB
                                    implements Callback<Deferred<Boolean>, TSMeta> {
                                        FetchNewCB() {
                                        }

                                        public Deferred<Boolean> call(TSMeta stored_meta) throws Exception {
                                            val$tsdb.indexTSMeta(stored_meta);
                                            val$tsdb.processTSMetaThroughTrees(stored_meta);
                                            return Deferred.fromResult((Object)true);
                                        }
                                    }
                                    return new LoadUIDs(val$tsdb, UniqueId.uidToString(val$tsuid)).call(meta).addCallbackDeferring((Callback)new FetchNewCB());
                                }
                            }
                            return meta.storeNew(this.val$tsdb).addCallbackDeferring((Callback)new StoreNewCB());
                        }
                    }
                    return new CreateNewCB(tsuid, tsdb).call(null);
                }
                return Deferred.fromResult((Object)true);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new ExistsCB());
    }

    private static Deferred<TSMeta> getFromStorage(TSDB tsdb, byte[] tsuid) {
        GetRequest get = new GetRequest(tsdb.metaTable(), tsuid);
        get.family(FAMILY);
        get.qualifiers((byte[][])new byte[][]{COUNTER_QUALIFIER, META_QUALIFIER});
        final class GetCB
        implements Callback<Deferred<TSMeta>, ArrayList<KeyValue>> {
            GetCB() {
            }

            public Deferred<TSMeta> call(ArrayList<KeyValue> row) throws Exception {
                if (row == null || row.isEmpty()) {
                    return Deferred.fromResult(null);
                }
                long dps = 0L;
                long last_received = 0L;
                TSMeta meta = null;
                for (KeyValue column : row) {
                    if (Arrays.equals(COUNTER_QUALIFIER, column.qualifier())) {
                        dps = Bytes.getLong((byte[])column.value());
                        last_received = column.timestamp() / 1000L;
                        continue;
                    }
                    if (!Arrays.equals(META_QUALIFIER, column.qualifier())) continue;
                    meta = JSON.parseToObject(column.value(), TSMeta.class);
                }
                if (meta == null) {
                    LOG.warn("Found a counter TSMeta column without a meta for TSUID: " + UniqueId.uidToString(row.get(0).key()));
                    return Deferred.fromResult(null);
                }
                meta.total_dps = dps;
                meta.last_received = last_received;
                return Deferred.fromResult(meta);
            }
        }
        return tsdb.getClient().get(get).addCallbackDeferring((Callback)new GetCB());
    }

    public static byte[] META_QUALIFIER() {
        return META_QUALIFIER;
    }

    public static byte[] COUNTER_QUALIFIER() {
        return COUNTER_QUALIFIER;
    }

    public static byte[] FAMILY() {
        return FAMILY;
    }

    private void syncMeta(TSMeta meta, boolean overwrite) {
        if (meta.tsuid != null && !meta.tsuid.isEmpty()) {
            this.tsuid = meta.tsuid;
        }
        if (this.tsuid == null || this.tsuid.isEmpty()) {
            throw new IllegalArgumentException("TSUID is empty");
        }
        if (meta.created > 0L && (meta.created < this.created || this.created == 0L)) {
            this.created = meta.created;
        }
        if (!overwrite && !this.changed.get("display_name").booleanValue()) {
            this.display_name = meta.display_name;
        }
        if (!overwrite && !this.changed.get("description").booleanValue()) {
            this.description = meta.description;
        }
        if (!overwrite && !this.changed.get("notes").booleanValue()) {
            this.notes = meta.notes;
        }
        if (!overwrite && !this.changed.get("custom").booleanValue()) {
            this.custom = meta.custom;
        }
        if (!overwrite && !this.changed.get("units").booleanValue()) {
            this.units = meta.units;
        }
        if (!overwrite && !this.changed.get("data_type").booleanValue()) {
            this.data_type = meta.data_type;
        }
        if (!overwrite && !this.changed.get("retention").booleanValue()) {
            this.retention = meta.retention;
        }
        if (!overwrite && !this.changed.get("max").booleanValue()) {
            this.max = meta.max;
        }
        if (!overwrite && !this.changed.get("min").booleanValue()) {
            this.min = meta.min;
        }
        this.last_received = meta.last_received;
        this.total_dps = meta.total_dps;
        this.initializeChangedMap();
    }

    private void initializeChangedMap() {
        this.changed.put("display_name", false);
        this.changed.put("description", false);
        this.changed.put("notes", false);
        this.changed.put("created", false);
        this.changed.put("custom", false);
        this.changed.put("units", false);
        this.changed.put("data_type", false);
        this.changed.put("retention", false);
        this.changed.put("max", false);
        this.changed.put("min", false);
        this.changed.put("last_received", false);
        this.changed.put("created", false);
    }

    private byte[] getStorageJSON() {
        ByteArrayOutputStream output = new ByteArrayOutputStream(256);
        try {
            JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
            json.writeStartObject();
            json.writeStringField("tsuid", this.tsuid);
            json.writeStringField("displayName", this.display_name);
            json.writeStringField("description", this.description);
            json.writeStringField("notes", this.notes);
            json.writeNumberField("created", this.created);
            if (this.custom == null) {
                json.writeNullField("custom");
            } else {
                json.writeObjectFieldStart("custom");
                for (Map.Entry<String, String> entry : this.custom.entrySet()) {
                    json.writeStringField(entry.getKey(), entry.getValue());
                }
                json.writeEndObject();
            }
            json.writeStringField("units", this.units);
            json.writeStringField("dataType", this.data_type);
            json.writeNumberField("retention", this.retention);
            json.writeNumberField("max", this.max);
            json.writeNumberField("min", this.min);
            json.writeEndObject();
            json.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize TSMeta", e);
        }
    }

    public final String getTSUID() {
        return this.tsuid;
    }

    public final UIDMeta getMetric() {
        return this.metric;
    }

    public final List<UIDMeta> getTags() {
        return this.tags;
    }

    public final String getDisplayName() {
        return this.display_name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getNotes() {
        return this.notes;
    }

    public final long getCreated() {
        return this.created;
    }

    public final Map<String, String> getCustom() {
        return this.custom;
    }

    public final String getUnits() {
        return this.units;
    }

    public final String getDataType() {
        return this.data_type;
    }

    public final int getRetention() {
        return this.retention;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getMin() {
        return this.min;
    }

    public final long getLastReceived() {
        return this.last_received;
    }

    public final long getTotalDatapoints() {
        return this.total_dps;
    }

    public final void setDisplayName(String display_name) {
        if (!this.display_name.equals(display_name)) {
            this.changed.put("display_name", true);
            this.display_name = display_name;
        }
    }

    public final void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.changed.put("description", true);
            this.description = description;
        }
    }

    public final void setNotes(String notes) {
        if (!this.notes.equals(notes)) {
            this.changed.put("notes", true);
            this.notes = notes;
        }
    }

    public final void setCreated(long created) {
        if (this.created != created) {
            this.changed.put("created", true);
            this.created = created;
        }
    }

    public final void setTSUID(String tsuid) {
        this.tsuid = tsuid;
    }

    public final void setCustom(Map<String, String> custom) {
        if (this.custom != null || custom != null) {
            this.changed.put("custom", true);
            this.custom = new HashMap<String, String>(custom);
        }
    }

    public final void setUnits(String units) {
        if (!this.units.equals(units)) {
            this.changed.put("units", true);
            this.units = units;
        }
    }

    public final void setDataType(String data_type) {
        if (!this.data_type.equals(data_type)) {
            this.changed.put("data_type", true);
            this.data_type = data_type;
        }
    }

    public final void setRetention(int retention) {
        if (this.retention != retention) {
            this.changed.put("retention", true);
            this.retention = retention;
        }
    }

    public final void setMax(double max) {
        if (this.max != max) {
            this.changed.put("max", true);
            this.max = max;
        }
    }

    public final void setMin(double min) {
        if (this.min != min) {
            this.changed.put("min", true);
            this.min = min;
        }
    }

    private static class LoadUIDs
    implements Callback<Deferred<TSMeta>, TSMeta> {
        private final TSDB tsdb;
        private final String tsuid;

        public LoadUIDs(TSDB tsdb, String tsuid) {
            this.tsdb = tsdb;
            this.tsuid = tsuid;
        }

        public Deferred<TSMeta> call(final TSMeta meta) throws Exception {
            if (meta == null) {
                return Deferred.fromResult(null);
            }
            List<byte[]> tags = UniqueId.getTagsFromTSUID(this.tsuid);
            meta.tags = new ArrayList(tags.size());
            for (int i = 0; i < tags.size(); ++i) {
                meta.tags.add(new UIDMeta());
            }
            ArrayList<Deferred> uid_group = new ArrayList<Deferred>(tags.size() + 1);
            final class UIDMetaCB
            implements Callback<Object, UIDMeta> {
                final int index;

                public UIDMetaCB(int index) {
                    this.index = index;
                }

                public Object call(UIDMeta uid_meta) throws Exception {
                    if (this.index < 0) {
                        meta.metric = uid_meta;
                    } else {
                        meta.tags.set(this.index, uid_meta);
                    }
                    return null;
                }
            }
            uid_group.add(UIDMeta.getUIDMeta(this.tsdb, UniqueId.UniqueIdType.METRIC, this.tsuid.substring(0, TSDB.metrics_width() * 2)).addCallback((Callback)new UIDMetaCB(-1)));
            int idx = 0;
            for (byte[] tag : tags) {
                if (idx % 2 == 0) {
                    uid_group.add(UIDMeta.getUIDMeta(this.tsdb, UniqueId.UniqueIdType.TAGK, tag).addCallback((Callback)new UIDMetaCB(idx)));
                } else {
                    uid_group.add(UIDMeta.getUIDMeta(this.tsdb, UniqueId.UniqueIdType.TAGV, tag).addCallback((Callback)new UIDMetaCB(idx)));
                }
                ++idx;
            }
            final class CollateCB
            implements Callback<Deferred<TSMeta>, ArrayList<Object>> {
                CollateCB() {
                }

                public Deferred<TSMeta> call(ArrayList<Object> uids) throws Exception {
                    return Deferred.fromResult((Object)meta);
                }
            }
            return Deferred.group(uid_group).addCallbackDeferring((Callback)new CollateCB());
        }
    }
}

