/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.meta;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.IncomingDataPoint;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.DateTime;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSUIDQuery {
    private static final Logger LOG = LoggerFactory.getLogger(TSUIDQuery.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private byte[] tsuid;
    private String metric;
    private byte[] metric_uid;
    private Map<String, String> tags;
    private ArrayList<byte[]> tag_uids;
    private boolean resolve_names;
    private int back_scan;
    private long last_timestamp;
    private final TSDB tsdb;

    public TSUIDQuery(TSDB tsdb) {
        if (tsdb == null) {
            throw new IllegalArgumentException("TSDB reference cannot be null");
        }
        this.tsdb = tsdb;
    }

    public TSUIDQuery(TSDB tsdb, byte[] tsuid) {
        if (tsdb == null) {
            throw new IllegalArgumentException("TSDB reference cannot be null");
        }
        if (tsuid == null || tsuid.length < TSDB.metrics_width() + TSDB.tagk_width() + TSDB.tagv_width()) {
            throw new IllegalArgumentException("TSUID must not be null and must have a metric and at least one tag pair");
        }
        this.tsdb = tsdb;
        this.tsuid = tsuid;
    }

    public TSUIDQuery(TSDB tsdb, String metric, Map<String, String> tags) {
        if (tsdb == null) {
            throw new IllegalArgumentException("TSDB reference cannot be null");
        }
        if (metric == null || metric.isEmpty()) {
            throw new IllegalArgumentException("Metric cannot be null or empty");
        }
        if (tags == null) {
            throw new IllegalArgumentException("Tag map cannot be null. Empty is ok");
        }
        this.tsdb = tsdb;
        this.metric = metric;
        this.tags = tags;
    }

    public Deferred<IncomingDataPoint> getLastPoint(boolean resolve_names, final int back_scan) {
        class TSUIDCB
        implements Callback<Deferred<IncomingDataPoint>, byte[]> {
            TSUIDCB() {
            }

            public Deferred<IncomingDataPoint> call(byte[] incoming_tsuid) throws Exception {
                if (TSUIDQuery.this.tsuid == null && incoming_tsuid == null) {
                    return Deferred.fromError((Exception)new RuntimeException("Both incoming and supplied TSUIDs were null for " + TSUIDQuery.this));
                }
                if (incoming_tsuid != null) {
                    TSUIDQuery.this.setTSUID(incoming_tsuid);
                }
                if (back_scan < 1 && meta_enabled) {
                    GetRequest get = new GetRequest(TSUIDQuery.this.tsdb.metaTable(), TSUIDQuery.this.tsuid);
                    get.family(TSMeta.FAMILY());
                    get.qualifier(TSMeta.COUNTER_QUALIFIER());
                    return TSUIDQuery.this.tsdb.getClient().get(get).addCallbackDeferring((Callback)new MetaCB());
                }
                if (TSUIDQuery.this.last_timestamp > 0L) {
                    TSUIDQuery.this.last_timestamp = Internal.baseTime(TSUIDQuery.this.last_timestamp);
                } else {
                    TSUIDQuery.this.last_timestamp = Internal.baseTime(DateTime.currentTimeMillis());
                }
                byte[] key = RowKey.rowKeyFromTSUID(TSUIDQuery.this.tsdb, TSUIDQuery.this.tsuid, TSUIDQuery.this.last_timestamp);
                GetRequest get = new GetRequest(TSUIDQuery.this.tsdb.dataTable(), key);
                get.family(TSDB.FAMILY());
                return TSUIDQuery.this.tsdb.getClient().get(get).addCallbackDeferring((Callback)new LastPointCB());
            }

            public String toString() {
                return "TSUID callback";
            }
        }
        boolean meta_enabled;
        if (back_scan < 0) {
            throw new IllegalArgumentException("Backscan must be zero or a positive number");
        }
        this.resolve_names = resolve_names;
        this.back_scan = back_scan;
        boolean bl = meta_enabled = this.tsdb.getConfig().enable_tsuid_tracking() || this.tsdb.getConfig().enable_tsuid_incrementing();
        if (this.tsuid == null) {
            return TSUIDQuery.tsuidFromMetric(this.tsdb, this.metric, this.tags).addCallbackDeferring((Callback)new TSUIDCB());
        }
        try {
            return new TSUIDCB().call(null);
        }
        catch (Exception e) {
            return Deferred.fromError((Exception)e);
        }
    }

    public void setQuery(String metric, Map<String, String> tags) {
        this.metric = metric;
        this.tags = tags;
        this.metric_uid = this.tsdb.getUID(UniqueId.UniqueIdType.METRIC, metric);
        this.tag_uids = Tags.resolveAll(this.tsdb, tags);
    }

    public Deferred<Bytes.ByteMap<Long>> getLastWriteTimes() {
        class ResolutionCB
        implements Callback<Deferred<Bytes.ByteMap<Long>>, Object> {
            ResolutionCB() {
            }

            public Deferred<Bytes.ByteMap<Long>> call(Object arg0) throws Exception {
                final Scanner scanner = TSUIDQuery.this.getScanner();
                scanner.setQualifier(TSMeta.COUNTER_QUALIFIER());
                final Deferred results = new Deferred();
                final Bytes.ByteMap tsuids = new Bytes.ByteMap();
                final class ScannerCB
                implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
                    ScannerCB() {
                    }

                    public Object scan() {
                        final class ErrBack
                        implements Callback<Object, Exception> {
                            final /* synthetic */ Deferred val$results;

                            ErrBack() {
                                this.val$results = deferred;
                            }

                            public Object call(Exception e) throws Exception {
                                this.val$results.callback((Object)e);
                                return null;
                            }

                            public String toString() {
                                return "Error callback";
                            }
                        }
                        return scanner.nextRows().addCallback((Callback)this).addErrback((Callback)new ErrBack(this, results));
                    }

                    public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                        try {
                            if (rows == null) {
                                results.callback((Object)tsuids);
                                return null;
                            }
                            for (ArrayList<KeyValue> row : rows) {
                                byte[] tsuid = row.get(0).key();
                                tsuids.put((Object)tsuid, (Object)row.get(0).timestamp());
                            }
                            return this.scan();
                        }
                        catch (Exception e) {
                            results.callback((Object)e);
                            return null;
                        }
                    }
                }
                new ScannerCB().scan();
                return results;
            }

            public String toString() {
                return "Last counter time callback";
            }
        }
        if (this.metric_uid == null) {
            return this.resolveMetric().addCallbackDeferring((Callback)new ResolutionCB());
        }
        try {
            return new ResolutionCB().call(null);
        }
        catch (Exception e) {
            return Deferred.fromError((Exception)e);
        }
    }

    public Deferred<List<TSMeta>> getTSMetas() {
        class ResolutionCB
        implements Callback<Deferred<List<TSMeta>>, Object> {
            ResolutionCB() {
            }

            public Deferred<List<TSMeta>> call(Object done) throws Exception {
                final Scanner scanner = TSUIDQuery.this.getScanner();
                scanner.setQualifier(TSMeta.META_QUALIFIER());
                final Deferred results = new Deferred();
                final ArrayList tsmetas = new ArrayList();
                final ArrayList tsmeta_group = new ArrayList();
                final class ScannerCB
                implements Callback<Object, ArrayList<ArrayList<KeyValue>>> {
                    ScannerCB() {
                    }

                    public Object scan() {
                        final class ErrBack
                        implements Callback<Object, Exception> {
                            final /* synthetic */ Deferred val$results;

                            ErrBack() {
                                this.val$results = deferred;
                            }

                            public Object call(Exception e) throws Exception {
                                this.val$results.callback((Object)e);
                                return null;
                            }

                            public String toString() {
                                return "Error callback";
                            }
                        }
                        return scanner.nextRows().addCallback((Callback)this).addErrback((Callback)new ErrBack(this, results));
                    }

                    public Object call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                        try {
                            if (rows == null) {
                                final class TSMetaGroupCB
                                implements Callback<Object, ArrayList<TSMeta>> {
                                    final /* synthetic */ List val$tsmetas;
                                    final /* synthetic */ Deferred val$results;

                                    TSMetaGroupCB() {
                                        this.val$tsmetas = list;
                                        this.val$results = deferred;
                                    }

                                    public List<TSMeta> call(ArrayList<TSMeta> ts) throws Exception {
                                        for (TSMeta tsm : ts) {
                                            if (tsm == null) continue;
                                            this.val$tsmetas.add(tsm);
                                        }
                                        this.val$results.callback((Object)this.val$tsmetas);
                                        return null;
                                    }

                                    public String toString() {
                                        return "TSMeta callback";
                                    }
                                }
                                Deferred.group((Collection)tsmeta_group).addCallback((Callback)new TSMetaGroupCB(this, tsmetas, results)).addErrback((Callback)new ErrBack(this, results));
                                return null;
                            }
                            for (ArrayList<KeyValue> row : rows) {
                                tsmeta_group.add(TSMeta.parseFromColumn(TSUIDQuery.this.tsdb, row.get(0), true));
                            }
                            return this.scan();
                        }
                        catch (Exception e) {
                            results.callback((Object)e);
                            return null;
                        }
                    }
                }
                new ScannerCB().scan();
                return results;
            }

            public String toString() {
                return "TSMeta scan callback";
            }
        }
        if (this.metric_uid == null) {
            return this.resolveMetric().addCallbackDeferring((Callback)new ResolutionCB());
        }
        try {
            return new ResolutionCB().call(null);
        }
        catch (Exception e) {
            return Deferred.fromError((Exception)e);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TSUIDQuery(metric=").append(this.metric).append(", tags=").append(this.tags).append(", tsuid=").append(this.tsuid != null ? UniqueId.uidToString(this.tsuid) : "null").append(", last_timestamp=").append(this.last_timestamp).append(", back_scan=").append(this.back_scan).append(", resolve_names=").append(this.resolve_names).append(")");
        return buf.toString();
    }

    public static Deferred<byte[]> tsuidFromMetric(final TSDB tsdb, String metric, final Map<String, String> tags) {
        if (metric == null || metric.isEmpty()) {
            throw new IllegalArgumentException("The metric cannot be empty");
        }
        if (tags == null || tags.isEmpty()) {
            throw new IllegalArgumentException("Tags cannot be null or empty when getting a TSUID");
        }
        final byte[] metric_uid = new byte[TSDB.metrics_width()];
        class MetricCB
        implements Callback<Deferred<byte[]>, byte[]> {
            MetricCB() {
            }

            public Deferred<byte[]> call(byte[] uid) throws Exception {
                System.arraycopy(uid, 0, metric_uid, 0, uid.length);
                class TagsCB
                implements Callback<byte[], ArrayList<byte[]>> {
                    final /* synthetic */ byte[] val$metric_uid;

                    TagsCB(byte[] byArray) {
                        this.val$metric_uid = byArray;
                    }

                    public byte[] call(ArrayList<byte[]> tag_list) throws Exception {
                        byte[] tsuid = new byte[this.val$metric_uid.length + (TSDB.tagk_width() + TSDB.tagv_width()) * tag_list.size()];
                        int idx = 0;
                        System.arraycopy(this.val$metric_uid, 0, tsuid, 0, this.val$metric_uid.length);
                        idx += this.val$metric_uid.length;
                        for (byte[] t : tag_list) {
                            System.arraycopy(t, 0, tsuid, idx, t.length);
                            idx += t.length;
                        }
                        return tsuid;
                    }

                    public String toString() {
                        return "Tag resolution callback";
                    }
                }
                return Tags.resolveAllAsync(tsdb, tags).addCallback((Callback)new TagsCB(metric_uid));
            }

            public String toString() {
                return "Metric resolution callback";
            }
        }
        return tsdb.getUIDAsync(UniqueId.UniqueIdType.METRIC, metric).addCallbackDeferring((Callback)new MetricCB());
    }

    public static Deferred<IncomingDataPoint> getLastPoint(TSDB tsdb, byte[] tsuid, boolean resolve_names, int max_lookups, long last_timestamp) {
        TSUIDQuery query = new TSUIDQuery(tsdb, tsuid);
        query.last_timestamp = last_timestamp;
        return query.getLastPoint(resolve_names, max_lookups);
    }

    private Deferred<IncomingDataPoint> resolveNames(final IncomingDataPoint dp) {
        if (this.metric != null) {
            dp.setMetric(this.metric);
            dp.setTags((HashMap)this.tags);
            return Deferred.fromResult((Object)dp);
        }
        byte[] metric_uid = Arrays.copyOfRange(this.tsuid, 0, (int)TSDB.metrics_width());
        class MetricCB
        implements Callback<Deferred<IncomingDataPoint>, String> {
            MetricCB() {
            }

            public Deferred<IncomingDataPoint> call(String name) throws Exception {
                dp.setMetric(name);
                List<byte[]> tags = UniqueId.getTagPairsFromTSUID(TSUIDQuery.this.tsuid);
                class TagsCB
                implements Callback<IncomingDataPoint, HashMap<String, String>> {
                    final /* synthetic */ IncomingDataPoint val$dp;

                    TagsCB() {
                        this.val$dp = incomingDataPoint;
                    }

                    public IncomingDataPoint call(HashMap<String, String> tags) throws Exception {
                        this.val$dp.setTags(tags);
                        return this.val$dp;
                    }

                    public String toString() {
                        return "Tags resolution CB";
                    }
                }
                return Tags.resolveIdsAsync(TSUIDQuery.this.tsdb, tags).addCallback((Callback)new TagsCB(TSUIDQuery.this, dp));
            }

            public String toString() {
                return "Metric resolution CB";
            }
        }
        return this.tsdb.getUidName(UniqueId.UniqueIdType.METRIC, metric_uid).addCallbackDeferring((Callback)new MetricCB());
    }

    private Deferred<Object> resolveMetric() {
        if (this.metric == null || this.metric.isEmpty()) {
            throw new IllegalArgumentException("The metric cannot be empty");
        }
        if (this.tags == null) {
            throw new IllegalArgumentException("Tags cannot be null or empty when getting a TSUID");
        }
        class MetricCB
        implements Callback<Deferred<Object>, byte[]> {
            MetricCB() {
            }

            public Deferred<Object> call(byte[] uid) throws Exception {
                TSUIDQuery.this.setMetricUID(uid);
                if (TSUIDQuery.this.tags.isEmpty()) {
                    TSUIDQuery.this.setTagUIDs(new ArrayList(0));
                    return null;
                }
                class TagsCB
                implements Callback<Object, ArrayList<byte[]>> {
                    TagsCB() {
                    }

                    public Object call(ArrayList<byte[]> tag_list) throws Exception {
                        TSUIDQuery.this.setTagUIDs(tag_list);
                        return null;
                    }

                    public String toString() {
                        return "Tag resolution callback";
                    }
                }
                return Tags.resolveAllAsync(TSUIDQuery.this.tsdb, TSUIDQuery.this.tags).addCallback((Callback)new TagsCB());
            }

            public String toString() {
                return "Metric resolution callback";
            }
        }
        return this.tsdb.getUIDAsync(UniqueId.UniqueIdType.METRIC, this.metric).addCallbackDeferring((Callback)new MetricCB());
    }

    private void setTSUID(byte[] tsuid) {
        this.tsuid = tsuid;
    }

    private void setMetricUID(byte[] uid) {
        this.metric_uid = uid;
    }

    private void setTagUIDs(ArrayList<byte[]> uids) {
        this.tag_uids = uids;
    }

    private Scanner getScanner() {
        Scanner scanner = this.tsdb.getClient().newScanner(this.tsdb.metaTable());
        scanner.setStartKey(this.metric_uid);
        long stop = UniqueId.uidToLong(this.metric_uid, TSDB.metrics_width()) + 1L;
        scanner.setStopKey(UniqueId.longToUID(stop, TSDB.metrics_width()));
        scanner.setFamily(TSMeta.FAMILY());
        if (!this.tags.isEmpty()) {
            short name_width = TSDB.tagk_width();
            short value_width = TSDB.tagv_width();
            short tagsize = (short)(name_width + value_width);
            StringBuilder buf = new StringBuilder(15 + (13 + tagsize) * this.tags.size());
            buf.append("(?s)^.{").append(TSDB.metrics_width()).append("}");
            Iterator<byte[]> tags = this.tag_uids.iterator();
            byte[] tag = tags.hasNext() ? tags.next() : null;
            do {
                buf.append("(?:.{").append(tagsize).append("})*\\Q");
                UniqueId.addIdToRegexp(buf, tag);
            } while ((tag = tags.hasNext() ? tags.next() : null) != null);
            buf.append("(?:.{").append(tagsize).append("})*$");
            scanner.setKeyRegexp(buf.toString(), CHARSET);
        }
        return scanner;
    }

    private class MetaCB
    implements Callback<Deferred<IncomingDataPoint>, ArrayList<KeyValue>> {
        private MetaCB() {
        }

        public Deferred<IncomingDataPoint> call(ArrayList<KeyValue> row) throws Exception {
            if (row == null) {
                return Deferred.fromResult(null);
            }
            TSUIDQuery.this.last_timestamp = Internal.baseTime(row.get(0).timestamp());
            byte[] key = RowKey.rowKeyFromTSUID(TSUIDQuery.this.tsdb, TSUIDQuery.this.tsuid, TSUIDQuery.this.last_timestamp);
            GetRequest get = new GetRequest(TSUIDQuery.this.tsdb.dataTable(), key);
            get.family(TSDB.FAMILY());
            return TSUIDQuery.this.tsdb.getClient().get(get).addCallbackDeferring((Callback)new LastPointCB());
        }

        public String toString() {
            return "Meta TSCounter lookup";
        }
    }

    private class LastPointCB
    implements Callback<Deferred<IncomingDataPoint>, ArrayList<KeyValue>> {
        int iteration = 0;

        private LastPointCB() {
        }

        public Deferred<IncomingDataPoint> call(ArrayList<KeyValue> row) throws Exception {
            if (row == null || row.isEmpty()) {
                if (this.iteration >= TSUIDQuery.this.back_scan) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No data points found within the time span for TSUID query " + TSUIDQuery.this);
                    }
                    return Deferred.fromResult(null);
                }
                TSUIDQuery.this.last_timestamp = TSUIDQuery.this.last_timestamp - 3600L;
                ++this.iteration;
                byte[] key = RowKey.rowKeyFromTSUID(TSUIDQuery.this.tsdb, TSUIDQuery.this.tsuid, TSUIDQuery.this.last_timestamp);
                GetRequest get = new GetRequest(TSUIDQuery.this.tsdb.dataTable(), key);
                get.family(TSDB.FAMILY());
                return TSUIDQuery.this.tsdb.getClient().get(get).addCallbackDeferring((Callback)this);
            }
            IncomingDataPoint dp = new Internal.GetLastDataPointCB(TSUIDQuery.this.tsdb).call(row);
            dp.setTSUID(UniqueId.uidToString(TSUIDQuery.this.tsuid));
            if (!TSUIDQuery.this.resolve_names) {
                return Deferred.fromResult((Object)dp);
            }
            return TSUIDQuery.this.resolveNames(dp);
        }

        public String toString() {
            return "LastDataPoint callback";
        }
    }
}

