/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.meta;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.opentsdb.core.TSDB;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.JSON;
import org.hbase.async.DeleteRequest;
import org.hbase.async.GetRequest;
import org.hbase.async.KeyValue;
import org.hbase.async.PutRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class UIDMeta {
    private static final Logger LOG = LoggerFactory.getLogger(UIDMeta.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private static final byte[] FAMILY = "name".getBytes(CHARSET);
    private String uid = "";
    @JsonDeserialize(using=JSON.UniqueIdTypeDeserializer.class)
    private UniqueId.UniqueIdType type = null;
    private String name = "";
    private String display_name = "";
    private String description = "";
    private String notes = "";
    private long created = 0L;
    private HashMap<String, String> custom = null;
    private final HashMap<String, Boolean> changed = new HashMap();

    public UIDMeta() {
        this.initializeChangedMap();
    }

    public UIDMeta(UniqueId.UniqueIdType type, String uid) {
        this.type = type;
        this.uid = uid;
        this.initializeChangedMap();
    }

    public UIDMeta(UniqueId.UniqueIdType type, byte[] uid, String name) {
        this.type = type;
        this.uid = UniqueId.uidToString(uid);
        this.name = name;
        this.created = System.currentTimeMillis() / 1000L;
        this.initializeChangedMap();
        this.changed.put("created", true);
    }

    public String toString() {
        return "'" + this.type.toString() + ":" + this.uid + "'";
    }

    public Deferred<Boolean> syncToStorage(final TSDB tsdb, final boolean overwrite) {
        if (this.uid == null || this.uid.isEmpty()) {
            throw new IllegalArgumentException("Missing UID");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Missing type");
        }
        boolean has_changes = false;
        for (Map.Entry<String, Boolean> entry : this.changed.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            has_changes = true;
            break;
        }
        if (!has_changes) {
            LOG.debug(this + " does not have changes, skipping sync to storage");
            throw new IllegalStateException("No changes detected in UID meta data");
        }
        final class NameCB
        implements Callback<Deferred<Boolean>, String> {
            private final UIDMeta local_meta;

            public NameCB() {
                this.local_meta = meta;
            }

            public Deferred<Boolean> call(String name) throws Exception {
                GetRequest get = new GetRequest(tsdb.uidTable(), UniqueId.stringToUid(UIDMeta.this.uid));
                get.family(FAMILY);
                get.qualifier((UIDMeta.this.type.toString().toLowerCase() + "_meta").getBytes(CHARSET));
                return tsdb.getClient().get(get).addCallbackDeferring((Callback)new 1NameCB.StoreUIDMeta());
            }

            final class 1NameCB.StoreUIDMeta
            implements Callback<Deferred<Boolean>, ArrayList<KeyValue>> {
                1NameCB.StoreUIDMeta() {
                }

                public Deferred<Boolean> call(ArrayList<KeyValue> row) throws Exception {
                    byte[] original_meta;
                    UIDMeta stored_meta;
                    if (row == null || row.isEmpty()) {
                        stored_meta = null;
                    } else {
                        stored_meta = JSON.parseToObject(row.get(0).value(), UIDMeta.class);
                        stored_meta.initializeChangedMap();
                    }
                    byte[] byArray = original_meta = row == null || row.isEmpty() ? new byte[]{} : row.get(0).value();
                    if (stored_meta != null) {
                        local_meta.syncMeta(stored_meta, overwrite);
                    }
                    if (UIDMeta.this.name == null || UIDMeta.this.name.isEmpty()) {
                        local_meta.name = UIDMeta.this.name;
                    }
                    PutRequest put = new PutRequest(tsdb.uidTable(), UniqueId.stringToUid(UIDMeta.this.uid), FAMILY, (UIDMeta.this.type.toString().toLowerCase() + "_meta").getBytes(CHARSET), local_meta.getStorageJSON());
                    return tsdb.getClient().compareAndSet(put, original_meta);
                }
            }
        }
        return tsdb.getUidName(this.type, UniqueId.stringToUid(this.uid)).addCallbackDeferring((Callback)new NameCB());
    }

    public Deferred<Object> storeNew(TSDB tsdb) {
        if (this.uid == null || this.uid.isEmpty()) {
            throw new IllegalArgumentException("Missing UID");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Missing type");
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new IllegalArgumentException("Missing name");
        }
        PutRequest put = new PutRequest(tsdb.uidTable(), UniqueId.stringToUid(this.uid), FAMILY, (this.type.toString().toLowerCase() + "_meta").getBytes(CHARSET), this.getStorageJSON());
        return tsdb.getClient().put(put);
    }

    public Deferred<Object> delete(TSDB tsdb) {
        if (this.uid == null || this.uid.isEmpty()) {
            throw new IllegalArgumentException("Missing UID");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Missing type");
        }
        DeleteRequest delete = new DeleteRequest(tsdb.uidTable(), UniqueId.stringToUid(this.uid), FAMILY, (this.type.toString().toLowerCase() + "_meta").getBytes(CHARSET));
        return tsdb.getClient().delete(delete);
    }

    public static Deferred<UIDMeta> getUIDMeta(TSDB tsdb, UniqueId.UniqueIdType type, String uid) {
        return UIDMeta.getUIDMeta(tsdb, type, UniqueId.stringToUid(uid));
    }

    public static Deferred<UIDMeta> getUIDMeta(final TSDB tsdb, final UniqueId.UniqueIdType type, final byte[] uid) {
        class NameCB
        implements Callback<Deferred<UIDMeta>, String> {
            NameCB() {
            }

            public Deferred<UIDMeta> call(final String name) throws Exception {
                GetRequest get = new GetRequest(tsdb.uidTable(), uid);
                get.family(FAMILY);
                get.qualifier((type.toString().toLowerCase() + "_meta").getBytes(CHARSET));
                class FetchMetaCB
                implements Callback<Deferred<UIDMeta>, ArrayList<KeyValue>> {
                    FetchMetaCB() {
                    }

                    public Deferred<UIDMeta> call(ArrayList<KeyValue> row) throws Exception {
                        if (row == null || row.isEmpty()) {
                            UIDMeta meta = new UIDMeta();
                            meta.uid = UniqueId.uidToString(uid);
                            meta.type = type;
                            meta.name = name;
                            return Deferred.fromResult((Object)meta);
                        }
                        UIDMeta meta = JSON.parseToObject(row.get(0).value(), UIDMeta.class);
                        meta.name = name;
                        meta.uid = UniqueId.uidToString(uid);
                        if (meta.type == null) {
                            String qualifier = new String(row.get(0).qualifier(), CHARSET);
                            meta.type = UniqueId.stringToUniqueIdType(qualifier.substring(0, qualifier.indexOf("_meta")));
                        }
                        meta.initializeChangedMap();
                        return Deferred.fromResult((Object)meta);
                    }
                }
                return tsdb.getClient().get(get).addCallbackDeferring((Callback)new FetchMetaCB());
            }
        }
        return tsdb.getUidName(type, uid).addCallbackDeferring((Callback)new NameCB());
    }

    private void syncMeta(UIDMeta meta, boolean overwrite) {
        if (meta.uid != null && !meta.uid.isEmpty()) {
            this.uid = meta.uid;
        }
        if (meta.name != null && !meta.name.isEmpty()) {
            this.name = meta.name;
        }
        if (meta.type != null) {
            this.type = meta.type;
        }
        if (meta.created > 0L && (meta.created < this.created || this.created == 0L)) {
            this.created = meta.created;
        }
        if (!overwrite && !this.changed.get("display_name").booleanValue()) {
            this.display_name = meta.display_name;
        }
        if (!overwrite && !this.changed.get("description").booleanValue()) {
            this.description = meta.description;
        }
        if (!overwrite && !this.changed.get("notes").booleanValue()) {
            this.notes = meta.notes;
        }
        if (!overwrite && !this.changed.get("custom").booleanValue()) {
            this.custom = meta.custom;
        }
        this.initializeChangedMap();
    }

    private void initializeChangedMap() {
        this.changed.put("display_name", false);
        this.changed.put("description", false);
        this.changed.put("notes", false);
        this.changed.put("custom", false);
        this.changed.put("created", false);
    }

    private byte[] getStorageJSON() {
        ByteArrayOutputStream output = new ByteArrayOutputStream(256);
        try {
            JsonGenerator json = JSON.getFactory().createGenerator((OutputStream)output);
            json.writeStartObject();
            json.writeStringField("type", this.type.toString());
            json.writeStringField("displayName", this.display_name);
            json.writeStringField("description", this.description);
            json.writeStringField("notes", this.notes);
            json.writeNumberField("created", this.created);
            if (this.custom == null) {
                json.writeNullField("custom");
            } else {
                json.writeObjectFieldStart("custom");
                for (Map.Entry<String, String> entry : this.custom.entrySet()) {
                    json.writeStringField(entry.getKey(), entry.getValue());
                }
                json.writeEndObject();
            }
            json.writeEndObject();
            json.close();
            return output.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize UIDMeta", e);
        }
    }

    public String getUID() {
        return this.uid;
    }

    public UniqueId.UniqueIdType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.display_name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNotes() {
        return this.notes;
    }

    public long getCreated() {
        return this.created;
    }

    public Map<String, String> getCustom() {
        return this.custom;
    }

    public void setDisplayName(String display_name) {
        if (!this.display_name.equals(display_name)) {
            this.changed.put("display_name", true);
            this.display_name = display_name;
        }
    }

    public void setDescription(String description) {
        if (!this.description.equals(description)) {
            this.changed.put("description", true);
            this.description = description;
        }
    }

    public void setNotes(String notes) {
        if (!this.notes.equals(notes)) {
            this.changed.put("notes", true);
            this.notes = notes;
        }
    }

    public void setCustom(Map<String, String> custom) {
        if (this.custom != null || custom != null) {
            this.changed.put("custom", true);
            this.custom = new HashMap<String, String>(custom);
        }
    }

    public final void setCreated(long created) {
        if (this.created != created) {
            this.changed.put("created", true);
            this.created = created;
        }
    }
}

