/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.Const;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.TSDB;
import net.opentsdb.uid.UniqueId;
import org.hbase.async.Bytes;
import org.hbase.async.FilterList;
import org.hbase.async.FuzzyRowFilter;
import org.hbase.async.KeyRegexpFilter;
import org.hbase.async.ScanFilter;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(QueryUtil.class);

    public static String getRowKeyUIDRegex(List<byte[]> group_bys, Bytes.ByteMap<byte[][]> row_key_literals) {
        return QueryUtil.getRowKeyUIDRegex(group_bys, row_key_literals, false, null, null);
    }

    public static String getRowKeyUIDRegex(List<byte[]> group_bys, Bytes.ByteMap<byte[][]> row_key_literals, boolean explicit_tags, byte[] fuzzy_key, byte[] fuzzy_mask) {
        if (group_bys != null) {
            Collections.sort(group_bys, Bytes.MEMCMP);
        }
        int prefix_width = Const.SALT_WIDTH() + TSDB.metrics_width() + 4;
        short name_width = TSDB.tagk_width();
        int value_width = TSDB.tagv_width();
        short tagsize = (short)(name_width + value_width);
        StringBuilder buf = new StringBuilder(15 + (13 + tagsize) * ((row_key_literals == null ? 0 : row_key_literals.size()) + (group_bys == null ? 0 : group_bys.size() * 3)));
        buf.append("(?s)^.{").append(Const.SALT_WIDTH() + TSDB.metrics_width() + 4).append("}");
        Iterator it = row_key_literals == null ? new Bytes.ByteMap().iterator() : row_key_literals.iterator();
        int fuzzy_offset = Const.SALT_WIDTH() + TSDB.metrics_width();
        if (fuzzy_mask != null) {
            while (fuzzy_offset < prefix_width) {
                fuzzy_mask[fuzzy_offset++] = 1;
            }
        }
        while (it.hasNext()) {
            boolean not_key;
            Map.Entry entry = it.hasNext() ? (Map.Entry)it.next() : null;
            boolean bl = not_key = entry.getValue() != null && ((byte[][])entry.getValue()).length == 0;
            if (!explicit_tags) {
                buf.append("(?:.{").append(tagsize).append("})*");
            } else if (fuzzy_mask != null) {
                System.arraycopy(entry.getKey(), 0, fuzzy_key, fuzzy_offset, name_width);
                fuzzy_offset += name_width;
                for (int i = 0; i < value_width; ++i) {
                    fuzzy_mask[fuzzy_offset++] = 1;
                }
            }
            if (not_key) {
                buf.append("(?!");
            }
            buf.append("\\Q");
            QueryUtil.addId(buf, (byte[])entry.getKey(), true);
            if (entry.getValue() != null && ((byte[][])entry.getValue()).length > 0) {
                buf.append("(?:");
                for (byte[] value_id : (byte[][])entry.getValue()) {
                    if (value_id == null) continue;
                    buf.append("\\Q");
                    QueryUtil.addId(buf, value_id, true);
                    buf.append('|');
                }
                buf.setCharAt(buf.length() - 1, ')');
            } else {
                buf.append(".{").append(value_width).append('}');
            }
            if (!not_key) continue;
            buf.append(")");
        }
        if (!explicit_tags) {
            buf.append("(?:.{").append(tagsize).append("})*");
        }
        buf.append("$");
        return buf.toString();
    }

    public static void setDataTableScanFilter(Scanner scanner, List<byte[]> group_bys, Bytes.ByteMap<byte[][]> row_key_literals, boolean explicit_tags, boolean enable_fuzzy_filter, int end_time) {
        byte[] fuzzy_mask;
        byte[] fuzzy_key;
        if ((group_bys == null || group_bys.isEmpty()) && (row_key_literals == null || row_key_literals.isEmpty())) {
            return;
        }
        int prefix_width = Const.SALT_WIDTH() + TSDB.metrics_width() + 4;
        short name_width = TSDB.tagk_width();
        short value_width = TSDB.tagv_width();
        if (explicit_tags && enable_fuzzy_filter) {
            fuzzy_key = new byte[prefix_width + row_key_literals.size() * (name_width + value_width)];
            fuzzy_mask = new byte[prefix_width + row_key_literals.size() * (name_width + value_width)];
            System.arraycopy(scanner.getCurrentKey(), 0, fuzzy_key, 0, scanner.getCurrentKey().length);
        } else {
            fuzzy_mask = null;
            fuzzy_key = null;
        }
        String regex = QueryUtil.getRowKeyUIDRegex(group_bys, row_key_literals, explicit_tags, fuzzy_key, fuzzy_mask);
        KeyRegexpFilter regex_filter = new KeyRegexpFilter(regex.toString(), Const.ASCII_CHARSET);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Regex for scanner: " + scanner + ": " + QueryUtil.byteRegexToString(regex));
        }
        if (!explicit_tags || !enable_fuzzy_filter) {
            scanner.setFilter((ScanFilter)regex_filter);
            return;
        }
        scanner.setStartKey(fuzzy_key);
        byte[] stop_key = Arrays.copyOf(fuzzy_key, fuzzy_key.length);
        Internal.setBaseTime(stop_key, end_time);
        for (int idx = Const.SALT_WIDTH() + TSDB.metrics_width() + 4 + TSDB.tagk_width(); idx < stop_key.length; idx += TSDB.tagk_width()) {
            for (int i = 0; i < TSDB.tagv_width(); ++i) {
                stop_key[idx++] = -1;
            }
        }
        scanner.setStopKey(stop_key);
        ArrayList<Object> filters = new ArrayList<Object>(2);
        filters.add(new FuzzyRowFilter(new FuzzyRowFilter.FuzzyFilterPair(fuzzy_key, fuzzy_mask)));
        filters.add(regex_filter);
        scanner.setFilter((ScanFilter)new FilterList(filters));
    }

    public static String getRowKeyTSUIDRegex(List<String> tsuids) {
        Object tags;
        Collections.sort(tsuids);
        short metric_width = TSDB.metrics_width();
        int tags_length = 0;
        ArrayList<byte[]> uids = new ArrayList<byte[]>(tsuids.size());
        for (String tsuid : tsuids) {
            tags = tsuid.substring(metric_width * 2);
            byte[] tag_bytes = UniqueId.stringToUid((String)tags);
            tags_length += tag_bytes.length;
            uids.add(tag_bytes);
        }
        StringBuilder buf = new StringBuilder(13 + tsuids.size() * 11 + tags_length);
        buf.append("(?s)^.{").append(Const.SALT_WIDTH() + metric_width + 4).append("}(");
        Iterator iterator = uids.iterator();
        while (iterator.hasNext()) {
            tags = (byte[])iterator.next();
            buf.append("\\Q");
            QueryUtil.addId(buf, (byte[])tags, true);
            buf.append('|');
        }
        buf.setCharAt(buf.length() - 1, ')');
        buf.append("$");
        return buf.toString();
    }

    public static Scanner getMetricScanner(TSDB tsdb, int salt_bucket, byte[] metric, int start, int stop, byte[] table, byte[] family) {
        short metric_width = TSDB.metrics_width();
        int metric_salt_width = metric_width + Const.SALT_WIDTH();
        byte[] start_row = new byte[metric_salt_width + 4];
        byte[] end_row = new byte[metric_salt_width + 4];
        if (Const.SALT_WIDTH() > 0) {
            byte[] salt = RowKey.getSaltBytes(salt_bucket);
            System.arraycopy(salt, 0, start_row, 0, Const.SALT_WIDTH());
            System.arraycopy(salt, 0, end_row, 0, Const.SALT_WIDTH());
        }
        Bytes.setInt((byte[])start_row, (int)start, (int)metric_salt_width);
        Bytes.setInt((byte[])end_row, (int)stop, (int)metric_salt_width);
        System.arraycopy(metric, 0, start_row, Const.SALT_WIDTH(), metric_width);
        System.arraycopy(metric, 0, end_row, Const.SALT_WIDTH(), metric_width);
        Scanner scanner = tsdb.getClient().newScanner(table);
        scanner.setMaxNumRows(tsdb.getConfig().scanner_maxNumRows());
        scanner.setStartKey(start_row);
        scanner.setStopKey(end_row);
        scanner.setFamily(family);
        return scanner;
    }

    public static void addId(StringBuilder buf, byte[] id, boolean close) {
        boolean backslash = false;
        for (byte b : id) {
            buf.append((char)(b & 0xFF));
            if (b == 69 && backslash) {
                buf.append("\\\\E\\Q");
                continue;
            }
            backslash = b == 92;
        }
        if (close) {
            buf.append("\\E");
        }
    }

    public static String byteRegexToString(String regexp) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < regexp.length(); ++i) {
            if (i > 0 && regexp.charAt(i - 1) == 'Q') {
                int x;
                if (regexp.charAt(i - 3) == '*') {
                    byte[] tagk = new byte[TSDB.tagk_width()];
                    for (x = 0; x < TSDB.tagk_width(); ++x) {
                        tagk[x] = (byte)regexp.charAt(i + x);
                    }
                    i += TSDB.tagk_width();
                    buf.append(Arrays.toString(tagk));
                    continue;
                }
                byte[] tagv = new byte[TSDB.tagv_width()];
                for (x = 0; x < TSDB.tagv_width(); ++x) {
                    tagv[x] = (byte)regexp.charAt(i + x);
                }
                i += TSDB.tagv_width();
                buf.append(Arrays.toString(tagv));
                continue;
            }
            buf.append(regexp.charAt(i));
        }
        return buf.toString();
    }
}

