/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.ArrayList;
import java.util.List;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.PostAggregatedDataPoints;

public class Absolute
implements Expression {
    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> query_results, List<String> params) {
        if (data_query == null) {
            throw new IllegalArgumentException("Missing time series query");
        }
        if (query_results == null || query_results.isEmpty()) {
            return new DataPoints[0];
        }
        int num_results = 0;
        for (DataPoints[] results : query_results) {
            num_results += results.length;
        }
        DataPoints[] results = new DataPoints[num_results];
        int ix = 0;
        for (DataPoints[] sub_query_result : query_results) {
            for (DataPoints dps : sub_query_result) {
                results[ix++] = this.abs(dps);
            }
        }
        return results;
    }

    private DataPoints abs(DataPoints points) {
        ArrayList<MutableDataPoint> dps = new ArrayList<MutableDataPoint>();
        for (DataPoint pt : points) {
            if (pt.isInteger()) {
                dps.add(MutableDataPoint.ofLongValue(pt.timestamp(), Math.abs(pt.longValue())));
                continue;
            }
            dps.add(MutableDataPoint.ofDoubleValue(pt.timestamp(), Math.abs(pt.doubleValue())));
        }
        DataPoint[] results = new DataPoint[dps.size()];
        dps.toArray(results);
        return new PostAggregatedDataPoints(points, results);
    }

    @Override
    public String writeStringField(List<String> queryParams, String innerExpression) {
        return "absolute(" + innerExpression + ")";
    }
}

