/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.PostAggregatedDataPoints;

public class Alias
implements Expression {
    static Joiner COMMA_JOINER = Joiner.on((char)',').skipNulls();

    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> query_results, List<String> params) {
        if (data_query == null) {
            throw new IllegalArgumentException("Missing time series query");
        }
        if (query_results == null || query_results.isEmpty()) {
            return new DataPoints[0];
        }
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("Missing the alias");
        }
        String alias_template = COMMA_JOINER.join(params);
        int num_results = 0;
        for (DataPoints[] results : query_results) {
            num_results += results.length;
        }
        DataPoints[] results = new DataPoints[num_results];
        int ix = 0;
        for (DataPoints[] sub_query_result : query_results) {
            for (DataPoints dps : sub_query_result) {
                ArrayList<MutableDataPoint> new_dps_list = new ArrayList<MutableDataPoint>();
                for (DataPoint pt : dps) {
                    if (pt.isInteger()) {
                        new_dps_list.add(MutableDataPoint.ofLongValue(pt.timestamp(), Math.abs(pt.longValue())));
                        continue;
                    }
                    new_dps_list.add(MutableDataPoint.ofDoubleValue(pt.timestamp(), Math.abs(pt.doubleValue())));
                }
                DataPoint[] new_dps = new DataPoint[dps.size()];
                new_dps_list.toArray(new_dps);
                PostAggregatedDataPoints padps = new PostAggregatedDataPoints(dps, new_dps);
                padps.setAlias(alias_template);
                results[ix++] = padps;
            }
        }
        return results;
    }

    @Override
    public String writeStringField(List<String> query_params, String innerExpression) {
        StringBuilder buf = new StringBuilder();
        buf.append("alias(").append(innerExpression).append(query_params == null || query_params.isEmpty() ? "" : "," + COMMA_JOINER.join(query_params)).append(")");
        return buf.toString();
    }
}

