/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.Annotation;
import net.opentsdb.query.expression.ExpressionDataPoint;
import net.opentsdb.query.expression.ExpressionIterator;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.ByteSet;
import org.hbase.async.Bytes;

public class EDPtoDPS
implements DataPoints {
    private final TSDB tsdb;
    private final int index;
    private final ExpressionIterator iterator;
    private final ExpressionDataPoint[] edps;

    public EDPtoDPS(TSDB tsdb, int index, ExpressionIterator iterator) {
        this.tsdb = tsdb;
        this.index = index;
        this.iterator = iterator;
        this.edps = iterator.values();
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        if (this.edps[this.index].metricUIDs() == null) {
            throw new IllegalStateException("Iterator UID was null for index " + this.index + " and iterator " + this.iterator);
        }
        byte[] uid = this.edps[this.index].metricUIDs().iterator().next();
        return this.tsdb.getUidName(UniqueId.UniqueIdType.METRIC, uid);
    }

    @Override
    public byte[] metricUID() {
        if (this.edps[this.index].metricUIDs() == null) {
            throw new IllegalStateException("Iterator UID was null for index " + this.index + " and iterator " + this.iterator);
        }
        return this.edps[this.index].metricUIDs().iterator().next();
    }

    @Override
    public Map<String, String> getTags() {
        try {
            return (Map)this.getTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        return Tags.getTagsAsync(this.tsdb, this.edps[this.index].tags());
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        return this.edps[this.index].tags();
    }

    @Override
    public List<String> getAggregatedTags() {
        try {
            return (List)this.getAggregatedTagsAsync().joinUninterruptibly();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Should never be here", e);
        }
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        ByteSet tagks = this.edps[this.index].aggregatedTags();
        final ArrayList aggregated_tags = new ArrayList(tagks.size());
        ArrayList<Deferred<String>> names = new ArrayList<Deferred<String>>(tagks.size());
        for (byte[] tagk : tagks) {
            names.add(this.tsdb.getUidName(UniqueId.UniqueIdType.TAGK, tagk));
        }
        final class ResolveCB
        implements Callback<List<String>, ArrayList<String>> {
            ResolveCB() {
            }

            public List<String> call(ArrayList<String> names) throws Exception {
                for (String name : names) {
                    aggregated_tags.add(name);
                }
                return aggregated_tags;
            }
        }
        return Deferred.group(names).addCallback((Callback)new ResolveCB());
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        ArrayList<byte[]> agg_tags = new ArrayList<byte[]>(this.edps[this.index].aggregatedTags());
        return agg_tags;
    }

    @Override
    public List<String> getTSUIDs() {
        return Collections.emptyList();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    public int size() {
        return -1;
    }

    @Override
    public int aggregatedSize() {
        return -1;
    }

    @Override
    public SeekableView iterator() {
        return new Iterator();
    }

    @Override
    public long timestamp(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isInteger(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long longValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double doubleValue(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryIndex() {
        return 0;
    }

    private class Iterator
    implements SeekableView {
        final MutableDataPoint dp = new MutableDataPoint();

        private Iterator() {
        }

        @Override
        public boolean hasNext() {
            return EDPtoDPS.this.iterator.hasNext(EDPtoDPS.this.index);
        }

        @Override
        public DataPoint next() {
            EDPtoDPS.this.iterator.next(EDPtoDPS.this.index);
            this.dp.reset(EDPtoDPS.this.edps[EDPtoDPS.this.index].timestamp(), EDPtoDPS.this.edps[EDPtoDPS.this.index].toDouble());
            return this.dp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seek(long timestamp) {
            throw new UnsupportedOperationException();
        }
    }
}

