/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.HashSet;
import java.util.Set;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.utils.ByteSet;
import org.hbase.async.Bytes;

public class ExpressionDataPoint
implements DataPoint {
    private final ByteSet metric_uids = new ByteSet();
    private final Bytes.ByteMap<byte[]> tags;
    private final ByteSet aggregated_tags;
    private final Set<String> tsuids;
    private long size;
    private long raw_size;
    private final MutableDataPoint dp;
    private int index;

    public ExpressionDataPoint() {
        this.tags = new Bytes.ByteMap();
        this.aggregated_tags = new ByteSet();
        this.tsuids = new HashSet<String>();
        this.dp = new MutableDataPoint();
    }

    public ExpressionDataPoint(DataPoints dps) {
        this.metric_uids.add(dps.metricUID());
        this.tags = dps.getTagUids() != null ? (Bytes.ByteMap)dps.getTagUids().clone() : new Bytes.ByteMap();
        this.aggregated_tags = new ByteSet();
        if (dps.getAggregatedTagUids() != null) {
            for (byte[] tagk : dps.getAggregatedTagUids()) {
                this.aggregated_tags.add(tagk);
            }
        }
        this.tsuids = new HashSet<String>(dps.getTSUIDs());
        this.dp = new MutableDataPoint();
        this.dp.reset(Long.MAX_VALUE, Double.NaN);
    }

    public ExpressionDataPoint(ExpressionDataPoint dps) {
        this.metric_uids.addAll(dps.metric_uids);
        this.tags = (Bytes.ByteMap)dps.tags.clone();
        this.aggregated_tags = new ByteSet();
        this.aggregated_tags.addAll(dps.aggregated_tags);
        this.tsuids = new HashSet<String>(dps.tsuids);
        this.size = dps.size;
        this.raw_size = dps.raw_size;
        this.dp = new MutableDataPoint();
        this.dp.reset(Long.MAX_VALUE, Double.NaN);
    }

    public void add(DataPoints dps) {
        this.metric_uids.add(dps.metricUID());
        for (byte[] tagk : dps.getAggregatedTagUids()) {
            this.aggregated_tags.add(tagk);
        }
        this.tsuids.addAll(dps.getTSUIDs());
    }

    public void add(ExpressionDataPoint dps) {
        this.metric_uids.addAll(dps.metric_uids);
        this.aggregated_tags.addAll(dps.aggregated_tags);
        this.tsuids.addAll(dps.tsuids);
        this.raw_size += dps.raw_size;
    }

    public ByteSet metricUIDs() {
        return this.metric_uids;
    }

    public Bytes.ByteMap<byte[]> tags() {
        return this.tags;
    }

    public ByteSet aggregatedTags() {
        return this.aggregated_tags;
    }

    public Set<String> tsuids() {
        return this.tsuids;
    }

    public long size() {
        return this.size;
    }

    public long rawSize() {
        return this.raw_size;
    }

    public void reset(long timestamp, double value) {
        this.dp.reset(timestamp, value);
    }

    public void reset(DataPoint dp) {
        this.dp.reset(dp);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ExpressionDataPoint(metricUIDs=").append(this.metric_uids).append(", tsuids=").append(this.tsuids).append(")");
        return buf.toString();
    }

    @Override
    public long timestamp() {
        return this.dp.timestamp();
    }

    @Override
    public boolean isInteger() {
        return this.dp.isInteger();
    }

    @Override
    public long longValue() {
        return this.dp.longValue();
    }

    @Override
    public double doubleValue() {
        return this.dp.doubleValue();
    }

    @Override
    public double toDouble() {
        return this.dp.toDouble();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }
}

