/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.HashMap;
import java.util.Map;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.expression.Absolute;
import net.opentsdb.query.expression.Alias;
import net.opentsdb.query.expression.DiffSeries;
import net.opentsdb.query.expression.DivideSeries;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.HighestCurrent;
import net.opentsdb.query.expression.HighestMax;
import net.opentsdb.query.expression.MovingAverage;
import net.opentsdb.query.expression.MultiplySeries;
import net.opentsdb.query.expression.Scale;
import net.opentsdb.query.expression.SumSeries;
import net.opentsdb.query.expression.TimeShift;

public final class ExpressionFactory {
    private static Map<String, Expression> available_functions = new HashMap<String, Expression>();

    private ExpressionFactory() {
    }

    public static void addTSDBFunctions(TSDB tsdb) {
        available_functions.put("divideSeries", new DivideSeries(tsdb));
        available_functions.put("divide", new DivideSeries(tsdb));
        available_functions.put("sumSeries", new SumSeries(tsdb));
        available_functions.put("sum", new SumSeries(tsdb));
        available_functions.put("diffSeries", new DiffSeries(tsdb));
        available_functions.put("difference", new DiffSeries(tsdb));
        available_functions.put("multiplySeries", new MultiplySeries(tsdb));
        available_functions.put("multiply", new MultiplySeries(tsdb));
    }

    static void addFunction(String name, Expression expr) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Missing function name");
        }
        if (expr == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        available_functions.put(name, expr);
    }

    public static Expression getByName(String function) {
        Expression expression = available_functions.get(function);
        if (expression == null) {
            throw new UnsupportedOperationException("Function " + function + " has not been implemented");
        }
        return expression;
    }

    static {
        available_functions.put("alias", new Alias());
        available_functions.put("scale", new Scale());
        available_functions.put("absolute", new Absolute());
        available_functions.put("movingAverage", new MovingAverage());
        available_functions.put("highestCurrent", new HighestCurrent());
        available_functions.put("highestMax", new HighestMax());
        available_functions.put("shift", new TimeShift());
        available_functions.put("timeShift", new TimeShift());
    }
}

