/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.NoSuchElementException;

public class ExpressionReader {
    protected final char[] chars;
    private int mark = 0;

    public ExpressionReader(char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("Character set cannot be null");
        }
        this.chars = chars;
    }

    public int getMark() {
        return this.mark;
    }

    public char peek() {
        if (this.isEOF()) {
            throw new NoSuchElementException("Index " + this.mark + " is out of bounds " + this.chars.length);
        }
        return this.chars[this.mark];
    }

    public char next() {
        if (this.isEOF()) {
            throw new NoSuchElementException("Index " + this.mark + " is out of bounds " + this.chars.length);
        }
        return this.chars[this.mark++];
    }

    public void skip(int num) {
        if (num < 0) {
            throw new UnsupportedOperationException("Skipping backwards is not allowed");
        }
        this.mark += num;
    }

    public boolean isNextChar(char c) {
        return this.peek() == c;
    }

    public boolean isNextSeq(CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException("Comparative sequence cannot be null");
        }
        for (int i = 0; i < seq.length(); ++i) {
            if (this.mark + i >= this.chars.length) {
                return false;
            }
            if (this.chars[this.mark + i] == seq.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public String readFuncName() {
        this.skipWhitespaces();
        StringBuilder builder = new StringBuilder();
        while (this.peek() != '(' && !Character.isWhitespace(this.peek())) {
            builder.append(this.next());
        }
        this.skipWhitespaces();
        return builder.toString();
    }

    public boolean isEOF() {
        return this.mark >= this.chars.length;
    }

    public void skipWhitespaces() {
        for (int i = this.mark; i < this.chars.length && Character.isWhitespace(this.chars[i]); ++i) {
            ++this.mark;
        }
    }

    public String readNextParameter() {
        StringBuilder builder = new StringBuilder();
        int num_nested = 0;
        while (!this.isEOF() && !Character.isWhitespace(this.peek())) {
            char ch = this.peek();
            if (ch == '(') {
                ++num_nested;
            } else if (ch == ')') {
                --num_nested;
            }
            if (num_nested < 0 || num_nested <= 0 && this.isNextSeq(",,")) break;
            builder.append(this.next());
        }
        return builder.toString();
    }

    public String toString() {
        return new String(this.chars);
    }
}

