/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.ExpressionFactory;

public class ExpressionTree {
    private static final Joiner DOUBLE_COMMA_JOINER = Joiner.on((String)",").skipNulls();
    private final Expression expression;
    private final TSQuery data_query;
    private List<ExpressionTree> sub_expressions;
    private List<String> func_params;
    private Map<Integer, String> sub_metric_queries;
    private Map<Integer, Parameter> parameter_index = Maps.newHashMap();

    public ExpressionTree(String expression_name, TSQuery data_query) {
        this(ExpressionFactory.getByName(expression_name), data_query);
    }

    public ExpressionTree(Expression expression, TSQuery data_query) {
        this.expression = expression;
        this.data_query = data_query;
    }

    public void addSubExpression(ExpressionTree child, int param_index) {
        if (child == null) {
            throw new IllegalArgumentException("Cannot add a null child tree");
        }
        if (child == this) {
            throw new IllegalDataException("Recursive sub expression detected: " + this);
        }
        if (param_index < 0) {
            throw new IllegalArgumentException("Parameter index must be 0 or greater");
        }
        if (this.sub_expressions == null) {
            this.sub_expressions = Lists.newArrayList();
        }
        this.sub_expressions.add(child);
        this.parameter_index.put(param_index, Parameter.SUB_EXPRESSION);
    }

    public void addSubMetricQuery(String metric_query, int sub_query_index, int param_index) {
        if (metric_query == null || metric_query.isEmpty()) {
            throw new IllegalArgumentException("Metric query cannot be null or empty");
        }
        if (sub_query_index < 0) {
            throw new IllegalArgumentException("Sub query index must be 0 or greater");
        }
        if (param_index < 0) {
            throw new IllegalArgumentException("Parameter index must be 0 or greater");
        }
        if (this.sub_metric_queries == null) {
            this.sub_metric_queries = Maps.newHashMap();
        }
        this.sub_metric_queries.put(sub_query_index, metric_query);
        this.parameter_index.put(param_index, Parameter.METRIC_QUERY);
    }

    public void addFunctionParameter(String param) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Parameter cannot be null or empty");
        }
        if (this.func_params == null) {
            this.func_params = Lists.newArrayList();
        }
        this.func_params.add(param);
    }

    public DataPoints[] evaluate(List<DataPoints[]> query_results) {
        ArrayList materialized = Lists.newArrayList();
        ArrayList metric_query_keys = null;
        if (this.sub_metric_queries != null && this.sub_metric_queries.size() > 0) {
            metric_query_keys = Lists.newArrayList(this.sub_metric_queries.keySet());
            Collections.sort(metric_query_keys);
        }
        int metric_pointer = 0;
        int sub_expression_pointer = 0;
        for (int i = 0; i < this.parameter_index.size(); ++i) {
            Parameter param = this.parameter_index.get(i);
            if (param == Parameter.METRIC_QUERY) {
                if (metric_query_keys == null) {
                    throw new RuntimeException("Attempt to read metric results when none exist");
                }
                int ix = (Integer)metric_query_keys.get(metric_pointer++);
                materialized.add(query_results.get(ix));
                continue;
            }
            if (param == Parameter.SUB_EXPRESSION) {
                ExpressionTree st = this.sub_expressions.get(sub_expression_pointer++);
                materialized.add(st.evaluate(query_results));
                continue;
            }
            throw new IllegalDataException("Unknown parameter type: " + (Object)((Object)param) + " in tree: " + this);
        }
        return this.expression.evaluate(this.data_query, materialized, this.func_params);
    }

    public String toString() {
        return this.writeStringField();
    }

    public String writeStringField() {
        String sub_metrics;
        ArrayList strs = Lists.newArrayList();
        if (this.sub_expressions != null) {
            for (ExpressionTree sub : this.sub_expressions) {
                strs.add(sub.toString());
            }
        }
        if (this.sub_metric_queries != null && (sub_metrics = this.clean(this.sub_metric_queries.values())) != null && sub_metrics.length() > 0) {
            strs.add(sub_metrics);
        }
        String inner_expression = DOUBLE_COMMA_JOINER.join((Iterable)strs);
        return this.expression.writeStringField(this.func_params, inner_expression);
    }

    private String clean(Collection<String> values) {
        if (values == null || values.size() == 0) {
            return "";
        }
        ArrayList strs = Lists.newArrayList();
        for (String v : values) {
            String tmp = v.replaceAll("\\{.*\\}", "");
            int ix = tmp.lastIndexOf(58);
            if (ix < 0) {
                strs.add(tmp);
                continue;
            }
            strs.add(tmp.substring(ix + 1));
        }
        return DOUBLE_COMMA_JOINER.join((Iterable)strs);
    }

    @VisibleForTesting
    List<ExpressionTree> subExpressions() {
        return this.sub_expressions;
    }

    @VisibleForTesting
    List<String> funcParams() {
        return this.func_params;
    }

    @VisibleForTesting
    Map<Integer, String> subMetricQueries() {
        return this.sub_metric_queries;
    }

    @VisibleForTesting
    Map<Integer, Parameter> parameterIndex() {
        return this.parameter_index;
    }

    static enum Parameter {
        SUB_EXPRESSION,
        METRIC_QUERY;

    }
}

