/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.ExpressionFactory;
import net.opentsdb.query.expression.ExpressionReader;
import net.opentsdb.query.expression.ExpressionTree;
import net.opentsdb.query.expression.parser.ParseException;
import net.opentsdb.query.expression.parser.SyntaxChecker;

public class Expressions {
    private Expressions() {
    }

    public static ExpressionTree parse(String expression, List<String> metric_queries, TSQuery data_query) {
        if (expression == null || expression.isEmpty()) {
            throw new IllegalArgumentException("Expression may not be null or empty");
        }
        if (expression.indexOf(40) == -1 || expression.indexOf(41) == -1) {
            throw new IllegalArgumentException("Invalid Expression: " + expression);
        }
        ExpressionReader reader = new ExpressionReader(expression.toCharArray());
        reader.skipWhitespaces();
        String function_name = reader.readFuncName();
        Expression root_expression = ExpressionFactory.getByName(function_name);
        ExpressionTree root = new ExpressionTree(root_expression, data_query);
        reader.skipWhitespaces();
        if (reader.peek() == '(') {
            reader.next();
            Expressions.parse(reader, metric_queries, root, data_query);
        }
        return root;
    }

    public static List<ExpressionTree> parseExpressions(List<String> expressions, TSQuery ts_query, List<String> metric_queries) {
        ArrayList<ExpressionTree> trees = new ArrayList<ExpressionTree>(expressions.size());
        for (String expr : expressions) {
            SyntaxChecker checker = new SyntaxChecker(new StringReader(expr));
            checker.setMetricQueries(metric_queries);
            checker.setTSQuery(ts_query);
            try {
                trees.add(checker.EXPRESSION());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Failed to parse " + expr, e);
            }
        }
        return trees;
    }

    private static void parse(ExpressionReader reader, List<String> metric_queries, ExpressionTree root, TSQuery data_query) {
        String param;
        int parameter_index = 0;
        reader.skipWhitespaces();
        if (reader.peek() != ')') {
            param = reader.readNextParameter();
            Expressions.parseParam(param, metric_queries, root, data_query, parameter_index++);
        }
        while (!reader.isEOF()) {
            reader.skipWhitespaces();
            if (reader.peek() == ')') {
                return;
            }
            if (reader.isNextSeq(",,")) {
                reader.skip(2);
                reader.skipWhitespaces();
                param = reader.readNextParameter();
                Expressions.parseParam(param, metric_queries, root, data_query, parameter_index++);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimiter in parameter list at pos=" + reader.getMark() + ", expr=" + reader.toString());
        }
    }

    private static void parseParam(String param, List<String> metric_queries, ExpressionTree root, TSQuery data_query, int index) {
        if (param == null || param.length() == 0) {
            throw new IllegalArgumentException("Parameter cannot be null or empty");
        }
        if (param.indexOf(40) > 0 && param.indexOf(41) > 0) {
            ExpressionTree sub_tree = Expressions.parse(param, metric_queries, data_query);
            root.addSubExpression(sub_tree, index);
        } else if (param.indexOf(58) >= 0) {
            metric_queries.add(param);
            root.addSubMetricQuery(param, metric_queries.size() - 1, index);
        } else {
            root.addFunctionParameter(param);
        }
    }
}

