/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.opentsdb.core.AggregationIterator;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.PostAggregatedDataPoints;

public class HighestMax
implements Expression {
    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> query_results, List<String> params) {
        if (data_query == null) {
            throw new IllegalArgumentException("Missing time series query");
        }
        if (query_results == null || query_results.isEmpty()) {
            return new DataPoints[0];
        }
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("Need aggregation window for moving average");
        }
        String param = params.get(0);
        if (param == null || param.length() == 0) {
            throw new IllegalArgumentException("Missing top n value (number of series to return)");
        }
        int topn = 0;
        if (param.matches("^[0-9]+$")) {
            try {
                topn = Integer.parseInt(param);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid parameter, must be an integer", nfe);
            }
        } else {
            throw new IllegalArgumentException("Unparseable top n value: " + param);
        }
        if (topn < 1) {
            throw new IllegalArgumentException("Top n value must be greater than zero: " + topn);
        }
        int num_results = 0;
        for (DataPoints[] results : query_results) {
            num_results += results.length;
        }
        PostAggregatedDataPoints[] post_agg_results = new PostAggregatedDataPoints[num_results];
        int ix = 0;
        for (DataPoints[] sub_query_result : query_results) {
            for (DataPoints dps : sub_query_result) {
                ArrayList<MutableDataPoint> mutable_points = new ArrayList<MutableDataPoint>();
                for (DataPoint point : dps) {
                    mutable_points.add(point.isInteger() ? MutableDataPoint.ofLongValue(point.timestamp(), point.longValue()) : MutableDataPoint.ofDoubleValue(point.timestamp(), point.doubleValue()));
                }
                post_agg_results[ix++] = new PostAggregatedDataPoints(dps, mutable_points.toArray(new DataPoint[mutable_points.size()]));
            }
        }
        SeekableView[] views = new SeekableView[num_results];
        for (int i = 0; i < num_results; ++i) {
            views[i] = post_agg_results[i].iterator();
        }
        MaxCacheAggregator aggregator = new MaxCacheAggregator(Aggregators.Interpolation.LERP, "maxCache", num_results, data_query.startTime(), data_query.endTime());
        AggregationIterator view = new AggregationIterator(views, data_query.startTime(), data_query.endTime(), aggregator, Aggregators.Interpolation.LERP, false);
        while (view.hasNext()) {
            DataPoint mdp = view.next();
            Double d = mdp.isInteger() ? (double)mdp.longValue() : mdp.doubleValue();
        }
        long[] max_longs = aggregator.getLongMaxes();
        double[] max_doubles = aggregator.getDoubleMaxes();
        Object[] max_by_ts = new TopNSortingEntry[num_results];
        if (aggregator.hasDoubles() && aggregator.hasLongs()) {
            for (int i = 0; i < num_results; ++i) {
                max_by_ts[i] = new TopNSortingEntry(Math.max((double)max_longs[i], max_doubles[i]), i);
            }
        } else if (aggregator.hasLongs() && !aggregator.hasDoubles()) {
            for (int i = 0; i < num_results; ++i) {
                max_by_ts[i] = new TopNSortingEntry(max_longs[i], i);
            }
        } else if (aggregator.hasDoubles() && !aggregator.hasLongs()) {
            for (int i = 0; i < num_results; ++i) {
                max_by_ts[i] = new TopNSortingEntry(max_doubles[i], i);
            }
        }
        Arrays.sort(max_by_ts);
        int result_count = Math.min(topn, num_results);
        DataPoints[] results = new DataPoints[result_count];
        for (int i = 0; i < result_count; ++i) {
            results[i] = post_agg_results[((TopNSortingEntry)max_by_ts[i]).pos];
        }
        return results;
    }

    @Override
    public String writeStringField(List<String> query_params, String inner_expression) {
        return "highestMax(" + inner_expression + ")";
    }

    public static class MaxCacheAggregator
    extends Aggregator {
        private final int total_series;
        private final long[] max_longs;
        private final double[] max_doubles;
        private boolean has_longs = false;
        private boolean has_doubles = false;
        private long start;
        private long end;

        public MaxCacheAggregator(Aggregators.Interpolation method, String name, int total_series, long start, long end) {
            super(method, name);
            this.total_series = total_series;
            this.start = start;
            this.end = end;
            this.max_longs = new long[total_series];
            this.max_doubles = new double[total_series];
            for (int i = 0; i < total_series; ++i) {
                this.max_doubles[i] = Double.MIN_VALUE;
                this.max_longs[i] = Long.MIN_VALUE;
            }
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long ts;
            if (values instanceof DataPoint && ((ts = ((DataPoint)((Object)values)).timestamp()) < this.start || ts > this.end)) {
                return 0L;
            }
            long[] longs = new long[this.total_series];
            int ix = 0;
            longs[ix++] = values.nextLongValue();
            while (values.hasNextValue()) {
                longs[ix++] = values.nextLongValue();
            }
            for (int i = 0; i < this.total_series; ++i) {
                this.max_longs[i] = Math.max(this.max_longs[i], longs[i]);
            }
            this.has_longs = true;
            return 0L;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            long ts;
            if (values instanceof DataPoint && ((ts = ((DataPoint)((Object)values)).timestamp()) < this.start || ts > this.end)) {
                return 0.0;
            }
            double[] doubles = new double[this.total_series];
            int ix = 0;
            doubles[ix++] = values.nextDoubleValue();
            while (values.hasNextValue()) {
                doubles[ix++] = values.nextDoubleValue();
            }
            for (int i = 0; i < this.total_series; ++i) {
                this.max_doubles[i] = Math.max(this.max_doubles[i], doubles[i]);
            }
            this.has_doubles = true;
            return 0.0;
        }

        public long[] getLongMaxes() {
            return this.max_longs;
        }

        public double[] getDoubleMaxes() {
            return this.max_doubles;
        }

        public boolean hasLongs() {
            return this.has_longs;
        }

        public boolean hasDoubles() {
            return this.has_doubles;
        }
    }

    static class TopNSortingEntry
    implements Comparable<TopNSortingEntry> {
        final double val;
        final int pos;

        public TopNSortingEntry(double val, int pos) {
            this.val = val;
            this.pos = pos;
        }

        public String toString() {
            return "{" + this.val + "," + this.pos + "}";
        }

        @Override
        public int compareTo(TopNSortingEntry o) {
            return -1 * Double.compare(this.val, o.val);
        }
    }
}

