/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.expression.ExpressionDataPoint;
import net.opentsdb.query.expression.ITimeSyncedIterator;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.query.expression.VariableIterator;
import net.opentsdb.utils.ByteSet;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class IntersectionIterator
implements ITimeSyncedIterator,
VariableIterator {
    private static final Logger LOG = LoggerFactory.getLogger(IntersectionIterator.class);
    private final Map<String, ITimeSyncedIterator> queries;
    private final Map<String, ExpressionDataPoint[]> current_values;
    private final String[] index_to_names;
    private final boolean intersect_on_query_tagks;
    private final boolean include_agg_tags;
    private long timestamp;
    private int series_size;
    private final String id;
    private int index;

    public IntersectionIterator(String id, Map<String, ITimeSyncedIterator> results, boolean intersect_on_query_tagks, boolean include_agg_tags) {
        this.id = id;
        this.intersect_on_query_tagks = intersect_on_query_tagks;
        this.include_agg_tags = include_agg_tags;
        this.timestamp = Long.MAX_VALUE;
        this.queries = new HashMap<String, ITimeSyncedIterator>(results.size());
        this.current_values = new HashMap<String, ExpressionDataPoint[]>(results.size());
        this.index_to_names = new String[results.size()];
        int max_series = 0;
        int i = 0;
        for (Map.Entry<String, ITimeSyncedIterator> entry : results.entrySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding iterator " + entry.getValue());
            }
            this.queries.put(entry.getKey(), entry.getValue());
            entry.getValue().setIndex(i);
            this.index_to_names[i] = entry.getKey();
            if (entry.getValue().values().length > max_series) {
                max_series = entry.getValue().values().length;
            }
            ++i;
        }
        if (max_series < 1) {
            LOG.debug("No series in the result sets");
            return;
        }
        this.computeIntersection();
        for (ITimeSyncedIterator it : this.queries.values()) {
            long ts = it.nextTimestamp();
            if (ts >= this.timestamp) continue;
            this.timestamp = ts;
        }
    }

    private IntersectionIterator(IntersectionIterator iterator) {
        this.id = iterator.id;
        this.intersect_on_query_tagks = iterator.intersect_on_query_tagks;
        this.include_agg_tags = iterator.include_agg_tags;
        this.timestamp = Long.MAX_VALUE;
        this.queries = new HashMap<String, ITimeSyncedIterator>(iterator.queries.size());
        this.current_values = new HashMap<String, ExpressionDataPoint[]>(this.queries.size());
        this.index_to_names = new String[this.queries.size()];
        int max_series = 0;
        int i = 0;
        for (Map.Entry<String, ITimeSyncedIterator> entry : iterator.queries.entrySet()) {
            this.queries.put(entry.getKey(), entry.getValue().getCopy());
            entry.getValue().setIndex(i);
            this.index_to_names[i] = entry.getKey();
            if (entry.getValue().values().length > max_series) {
                max_series = entry.getValue().values().length;
            }
            ++i;
        }
        if (max_series < 1) {
            LOG.debug("No series in the result sets");
            return;
        }
        this.computeIntersection();
        for (ITimeSyncedIterator it : this.queries.values()) {
            long ts = it.nextTimestamp();
            if (ts >= this.timestamp) continue;
            this.timestamp = ts;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("IntersectionIterator(id=").append(this.id).append(", useQueryTags=").append(this.intersect_on_query_tagks).append(", includeAggTags=").append(this.include_agg_tags).append(", index=").append(this.index).append(", queries=").append(this.queries);
        return buf.toString();
    }

    @Override
    public boolean hasNext() {
        for (ITimeSyncedIterator sub : this.queries.values()) {
            if (!sub.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void next() {
        if (!this.hasNext()) {
            throw new IllegalDataException("No more data");
        }
        for (ITimeSyncedIterator sub : this.queries.values()) {
            sub.next(this.timestamp);
        }
        this.timestamp = this.nextTimestamp();
    }

    @Override
    public Map<String, ExpressionDataPoint[]> getResults() {
        return this.current_values;
    }

    @Override
    public int getSeriesSize() {
        return this.series_size;
    }

    @Override
    public long nextTimestamp() {
        long ts = Long.MAX_VALUE;
        for (ITimeSyncedIterator sub : this.queries.values()) {
            long t;
            if (sub == null || (t = sub.nextTimestamp()) >= ts) continue;
            ts = t;
        }
        return ts;
    }

    private void computeIntersection() {
        ExpressionDataPoint[] idps;
        byte[] tagks;
        int i;
        Bytes.ByteMap ordered_intersection = new Bytes.ByteMap();
        Iterator<ITimeSyncedIterator> it = this.queries.values().iterator();
        ITimeSyncedIterator sub = it.next();
        HashMap<String, Bytes.ByteMap> flattened_tags = new HashMap<String, Bytes.ByteMap>(this.queries.size());
        Bytes.ByteMap tags = new Bytes.ByteMap();
        flattened_tags.put(sub.getId(), tags);
        ExpressionDataPoint[] dps = sub.values();
        for (i = 0; i < sub.size(); ++i) {
            tagks = IntersectionIterator.flattenTags(this.intersect_on_query_tagks, this.include_agg_tags, dps[i].tags(), dps[i].aggregatedTags(), sub);
            tags.put((Object)tagks, (Object)i);
            idps = new ExpressionDataPoint[this.queries.size()];
            idps[sub.getIndex()] = dps[i];
            ordered_intersection.put((Object)tagks, (Object)idps);
        }
        if (!it.hasNext()) {
            this.setCurrentAndMeta((Bytes.ByteMap<ExpressionDataPoint[]>)ordered_intersection);
            return;
        }
        while (it.hasNext()) {
            sub = it.next();
            tags = new Bytes.ByteMap();
            flattened_tags.put(sub.getId(), tags);
            dps = sub.values();
            for (i = 0; i < sub.size(); ++i) {
                tagks = IntersectionIterator.flattenTags(this.intersect_on_query_tagks, this.include_agg_tags, dps[i].tags(), dps[i].aggregatedTags(), sub);
                tags.put((Object)tagks, (Object)i);
                idps = (ExpressionDataPoint[])ordered_intersection.get((Object)tagks);
                if (idps == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Kicking out " + Bytes.pretty((byte[])tagks) + " from " + sub.getId());
                    }
                    sub.nullIterator(i);
                    continue;
                }
                idps[sub.getIndex()] = dps[i];
            }
            Iterator reverse_it = ordered_intersection.iterator();
            while (reverse_it.hasNext()) {
                Map.Entry e = (Map.Entry)reverse_it.next();
                if (tags.containsKey(e.getKey())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Kicking out " + Bytes.pretty((byte[])((byte[])e.getKey())) + " from the main list since the query for " + sub.getId() + " didn't have it");
                }
                for (Map.Entry entry : flattened_tags.entrySet()) {
                    Integer index;
                    if (((String)entry.getKey()).equals(sub.getId()) || (index = (Integer)((Bytes.ByteMap)entry.getValue()).get(e.getKey())) == null) continue;
                    this.queries.get(entry.getKey()).nullIterator(index);
                }
                reverse_it.remove();
            }
        }
        if (ordered_intersection.size() < 1) {
            throw new IllegalDataException("No intersections found: " + this);
        }
        this.setCurrentAndMeta((Bytes.ByteMap<ExpressionDataPoint[]>)ordered_intersection);
    }

    private void setCurrentAndMeta(Bytes.ByteMap<ExpressionDataPoint[]> ordered_intersection) {
        for (String id : this.queries.keySet()) {
            this.current_values.put(id, new ExpressionDataPoint[ordered_intersection.size()]);
        }
        int i = 0;
        for (ExpressionDataPoint[] idps : ordered_intersection.values()) {
            for (int x = 0; x < idps.length; ++x) {
                ExpressionDataPoint[] current_dps = this.current_values.get(this.index_to_names[x]);
                current_dps[i] = idps[x];
            }
            ++i;
        }
        this.series_size = ordered_intersection.size();
    }

    static byte[] flattenTags(boolean use_query_tags, boolean include_agg_tags, Bytes.ByteMap<byte[]> tags, ByteSet agg_tags, ITimeSyncedIterator sub) {
        int tag_size;
        ByteSet query_tagks;
        if (tags.isEmpty()) {
            return HBaseClient.EMPTY_ARRAY;
        }
        if (use_query_tags) {
            int i = 0;
            if (sub.getQueryTagKs() != null && !sub.getQueryTagKs().isEmpty()) {
                query_tagks = sub.getQueryTagKs();
                for (Map.Entry pair : tags.entrySet()) {
                    if (!query_tagks.contains(pair.getKey())) continue;
                    ++i;
                }
            } else {
                query_tagks = new ByteSet();
            }
            tag_size = i;
        } else {
            query_tagks = new ByteSet();
            tag_size = tags.size();
        }
        int len = tag_size * (TSDB.tagk_width() + TSDB.tagv_width()) + (include_agg_tags ? agg_tags.size() * TSDB.tagk_width() : 0);
        byte[] tagks = new byte[len];
        int i = 0;
        for (Map.Entry pair : tags.entrySet()) {
            if (use_query_tags && !query_tagks.contains(pair.getKey())) continue;
            System.arraycopy(pair.getKey(), 0, tagks, i, TSDB.tagk_width());
            System.arraycopy(pair.getValue(), 0, tagks, i += TSDB.tagk_width(), TSDB.tagv_width());
            i += TSDB.tagv_width();
        }
        if (include_agg_tags) {
            for (byte[] tagk : agg_tags) {
                System.arraycopy(tagk, 0, tagks, i, TSDB.tagk_width());
                i += TSDB.tagk_width();
            }
        }
        return tagks;
    }

    @Override
    public ExpressionDataPoint[] next(long timestamp) {
        throw new NotImplementedException();
    }

    @Override
    public int size() {
        throw new NotImplementedException();
    }

    @Override
    public ExpressionDataPoint[] values() {
        throw new NotImplementedException();
    }

    @Override
    public void nullIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ByteSet getQueryTagKs() {
        throw new NotImplementedException();
    }

    @Override
    public void setFillPolicy(NumericFillPolicy policy) {
        throw new NotImplementedException();
    }

    @Override
    public NumericFillPolicy getFillPolicy() {
        throw new NotImplementedException();
    }

    @Override
    public ITimeSyncedIterator getCopy() {
        return new IntersectionIterator(this);
    }

    @Override
    public boolean hasNext(int index) {
        for (ITimeSyncedIterator sub : this.queries.values()) {
            if (!sub.hasNext(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void next(int index) {
        if (!this.hasNext()) {
            throw new IllegalDataException("No more data");
        }
        for (ITimeSyncedIterator sub : this.queries.values()) {
            sub.next(index);
        }
    }
}

