/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.opentsdb.core.AggregationIterator;
import net.opentsdb.core.Aggregator;
import net.opentsdb.core.Aggregators;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.SeekableView;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.PostAggregatedDataPoints;

public class MovingAverage
implements Expression {
    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> query_results, List<String> params) {
        if (data_query == null) {
            throw new IllegalArgumentException("Missing time series query");
        }
        if (query_results == null || query_results.isEmpty()) {
            return new DataPoints[0];
        }
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("Missing moving average window size");
        }
        String param = params.get(0);
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Missing moving average window size");
        }
        param = param.trim();
        long condition = -1L;
        boolean is_time_unit = false;
        if (param.matches("^[0-9]+$")) {
            try {
                condition = Integer.parseInt(param);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid parameter, must be an integer", nfe);
            }
        } else if (param.startsWith("'") && param.endsWith("'")) {
            condition = this.parseParam(param);
            is_time_unit = true;
        } else {
            throw new IllegalArgumentException("Unparseable window size: " + param);
        }
        if (condition <= 0L) {
            throw new IllegalArgumentException("Moving average window must be an integer greater than zero");
        }
        int num_results = 0;
        for (DataPoints[] results : query_results) {
            num_results += results.length;
        }
        PostAggregatedDataPoints[] post_agg_results = new PostAggregatedDataPoints[num_results];
        int ix = 0;
        for (DataPoints[] sub_query_result : query_results) {
            for (DataPoints dps : sub_query_result) {
                ArrayList<MutableDataPoint> mutable_points = new ArrayList<MutableDataPoint>();
                for (DataPoint point : dps) {
                    mutable_points.add(MutableDataPoint.ofDoubleValue(point.timestamp(), point.toDouble()));
                }
                post_agg_results[ix++] = new PostAggregatedDataPoints(dps, mutable_points.toArray(new DataPoint[mutable_points.size()]));
            }
        }
        DataPoints[] results = new DataPoints[num_results];
        for (int i = 0; i < num_results; ++i) {
            MovingAverageAggregator moving_average = new MovingAverageAggregator(Aggregators.Interpolation.LERP, "movingAverage", condition, is_time_unit);
            SeekableView[] metrics_groups = new SeekableView[]{post_agg_results[i].iterator()};
            AggregationIterator view = new AggregationIterator(metrics_groups, data_query.startTime(), data_query.endTime(), moving_average, Aggregators.Interpolation.LERP, false);
            ArrayList<MutableDataPoint> points = new ArrayList<MutableDataPoint>();
            while (view.hasNext()) {
                DataPoint mdp = view.next();
                points.add(MutableDataPoint.ofDoubleValue(mdp.timestamp(), mdp.toDouble()));
            }
            results[i] = new PostAggregatedDataPoints(post_agg_results[i], points.toArray(new DataPoint[points.size()]));
        }
        return results;
    }

    long parseParam(String param) {
        if (param == null || param.isEmpty()) {
            throw new IllegalArgumentException("Window parameter may not be null or empty");
        }
        char[] chars = param.toCharArray();
        int idx = 0;
        for (int c = 1; c < chars.length && Character.isDigit(chars[c]); ++c) {
            ++idx;
        }
        if (idx < 1) {
            throw new IllegalArgumentException("Invalid moving window parameter: " + param);
        }
        try {
            int time = Integer.parseInt(param.substring(1, idx + 1));
            String unit = param.substring(idx + 1, param.length() - 1);
            if ("day".equals(unit) || "d".equals(unit)) {
                return TimeUnit.MILLISECONDS.convert(time, TimeUnit.DAYS);
            }
            if ("hr".equals(unit) || "hour".equals(unit) || "h".equals(unit)) {
                return TimeUnit.MILLISECONDS.convert(time, TimeUnit.HOURS);
            }
            if ("min".equals(unit) || "m".equals(unit)) {
                return TimeUnit.MILLISECONDS.convert(time, TimeUnit.MINUTES);
            }
            if ("sec".equals(unit) || "s".equals(unit)) {
                return TimeUnit.MILLISECONDS.convert(time, TimeUnit.SECONDS);
            }
            throw new IllegalArgumentException("Unknown time unit=" + unit + " in window=" + param);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unable to parse moving window parameter: " + param, nfe);
        }
    }

    @Override
    public String writeStringField(List<String> query_params, String inner_expression) {
        return "movingAverage(" + inner_expression + ")";
    }

    static final class MovingAverageAggregator
    extends Aggregator {
        private final LinkedList<DataPoint> accumulation;
        private final long condition;
        private final boolean is_time_unit;
        private boolean window_started;

        public MovingAverageAggregator(Aggregators.Interpolation method, String name, long condition, boolean is_time_unit) {
            super(method, name);
            this.condition = condition;
            this.is_time_unit = is_time_unit;
            this.accumulation = new LinkedList();
        }

        @Override
        public long runLong(Aggregator.Longs values) {
            long value = values.nextLongValue();
            if (values.hasNextValue()) {
                throw new IllegalDataException("There should only be one value in " + values);
            }
            long ts = ((DataPoint)((Object)values)).timestamp();
            this.accumulation.addFirst(MutableDataPoint.ofLongValue(ts, value));
            if (this.is_time_unit && !this.window_started) {
                this.window_started = true;
                return 0L;
            }
            long sum = 0L;
            int count = 0;
            Iterator iter = this.accumulation.iterator();
            boolean condition_met = false;
            long time_window_cumulation = 0L;
            long last_ts = -1L;
            while (iter.hasNext()) {
                DataPoint dp = (DataPoint)iter.next();
                if (this.is_time_unit) {
                    if (last_ts < 0L) {
                        last_ts = dp.timestamp();
                    } else {
                        last_ts = dp.timestamp();
                        if ((time_window_cumulation += last_ts - dp.timestamp()) >= this.condition) {
                            condition_met = true;
                            break;
                        }
                    }
                }
                sum = (long)((double)sum + (dp.isInteger() ? (double)dp.longValue() : dp.doubleValue()));
                if (this.is_time_unit || (long)(++count) < this.condition) continue;
                condition_met = true;
                break;
            }
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            if (!condition_met || count == 0) {
                return 0L;
            }
            return sum / (long)count;
        }

        @Override
        public double runDouble(Aggregator.Doubles values) {
            double value = values.nextDoubleValue();
            if (values.hasNextValue()) {
                throw new IllegalDataException("There should only be one value in " + values);
            }
            long ts = ((DataPoint)((Object)values)).timestamp();
            this.accumulation.addFirst(MutableDataPoint.ofDoubleValue(ts, value));
            if (this.is_time_unit && !this.window_started) {
                this.window_started = true;
                return 0.0;
            }
            double sum = 0.0;
            int count = 0;
            Iterator iter = this.accumulation.iterator();
            boolean condition_met = false;
            long time_window_cumulation = 0L;
            long last_ts = -1L;
            while (iter.hasNext()) {
                double v;
                DataPoint dp = (DataPoint)iter.next();
                if (this.is_time_unit) {
                    if (last_ts < 0L) {
                        last_ts = dp.timestamp();
                    } else {
                        last_ts = dp.timestamp();
                        if ((time_window_cumulation += last_ts - dp.timestamp()) >= this.condition) {
                            condition_met = true;
                            break;
                        }
                    }
                }
                double d = v = dp.isInteger() ? (double)dp.longValue() : dp.doubleValue();
                if (!Double.isNaN(v)) {
                    sum += v;
                    ++count;
                }
                if (this.is_time_unit || (long)count < this.condition) continue;
                condition_met = true;
                break;
            }
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
            if (!condition_met || count == 0) {
                return 0.0;
            }
            return sum / (double)count;
        }
    }
}

