/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import net.opentsdb.core.FillPolicy;

@JsonDeserialize(builder=Builder.class)
public class NumericFillPolicy {
    private FillPolicy policy;
    private double value;

    public NumericFillPolicy(FillPolicy policy) {
        this.policy = policy;
        this.validate();
    }

    public NumericFillPolicy(FillPolicy policy, double value) {
        this.policy = policy;
        this.value = value;
        this.validate();
    }

    public String toString() {
        return "policy=" + (Object)((Object)this.policy) + ", value=" + this.value;
    }

    public static Builder Builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.policy, this.value});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof NumericFillPolicy)) {
            return false;
        }
        NumericFillPolicy nfp = (NumericFillPolicy)obj;
        return Objects.equal((Object)((Object)this.policy), (Object)((Object)nfp.policy)) && Objects.equal((Object)this.value, (Object)nfp.value);
    }

    public FillPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(FillPolicy policy) {
        this.policy = policy;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void validate() {
        if (this.policy == null) {
            this.policy = this.value == 0.0 ? FillPolicy.ZERO : (Double.isNaN(this.value) ? FillPolicy.NOT_A_NUMBER : FillPolicy.SCALAR);
        } else {
            switch (this.policy) {
                case NONE: 
                case NOT_A_NUMBER: {
                    if (this.value != 0.0 && !Double.isNaN(this.value)) {
                        throw new IllegalArgumentException("The value for NONE and NAN must be NaN");
                    }
                    this.value = Double.NaN;
                    break;
                }
                case ZERO: {
                    if (this.value != 0.0) {
                        throw new IllegalArgumentException("The value for ZERO must be 0");
                    }
                    this.value = 0.0;
                    break;
                }
                case NULL: {
                    if (this.value != 0.0 && !Double.isNaN(this.value)) {
                        throw new IllegalArgumentException("The value for NULL must be 0");
                    }
                    this.value = Double.NaN;
                    break;
                }
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private FillPolicy policy;
        @JsonProperty
        private double value;

        public Builder setPolicy(FillPolicy policy) {
            this.policy = policy;
            return this;
        }

        public Builder setValue(double value) {
            this.value = value;
            return this;
        }

        public NumericFillPolicy build() {
            return new NumericFillPolicy(this.policy, this.value);
        }
    }
}

