/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.SeekableView;
import net.opentsdb.meta.Annotation;
import org.hbase.async.Bytes;

public class PostAggregatedDataPoints
implements DataPoints {
    private final DataPoints base_data_points;
    private final DataPoint[] points;
    private String alias = null;

    public PostAggregatedDataPoints(DataPoints base_data_points, DataPoint[] points) {
        if (base_data_points == null) {
            throw new IllegalArgumentException("base_data_points cannot be null");
        }
        if (points == null) {
            throw new IllegalArgumentException("points cannot be null");
        }
        this.base_data_points = base_data_points;
        this.points = points;
    }

    @Override
    public String metricName() {
        try {
            return (String)this.metricNameAsync().join();
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception waiting for name resolution", e);
        }
    }

    @Override
    public Deferred<String> metricNameAsync() {
        if (this.alias != null) {
            if (this.alias.contains("@") && this.getTagUids().size() > 0) {
                class TemplateFill
                implements Callback<Deferred<String>, Map<String, String>> {
                    TemplateFill() {
                    }

                    public Deferred<String> call(Map<String, String> tags) throws Exception {
                        for (Map.Entry<String, String> pair : tags.entrySet()) {
                            PostAggregatedDataPoints.this.alias = PostAggregatedDataPoints.this.alias.replace("@" + pair.getKey(), pair.getValue());
                        }
                        return Deferred.fromResult((Object)PostAggregatedDataPoints.this.alias);
                    }
                }
                return this.base_data_points.getTagsAsync().addCallbackDeferring((Callback)new TemplateFill());
            }
            return Deferred.fromResult((Object)this.alias);
        }
        return this.base_data_points.metricNameAsync();
    }

    @Override
    public byte[] metricUID() {
        if (this.alias != null) {
            return new byte[0];
        }
        return this.base_data_points.metricUID();
    }

    @Override
    public Map<String, String> getTags() {
        if (this.alias != null) {
            return Collections.emptyMap();
        }
        return this.base_data_points.getTags();
    }

    @Override
    public Deferred<Map<String, String>> getTagsAsync() {
        if (this.alias != null) {
            return Deferred.fromResult(Collections.emptyMap());
        }
        return this.base_data_points.getTagsAsync();
    }

    @Override
    public List<String> getAggregatedTags() {
        if (this.alias != null) {
            return Collections.emptyList();
        }
        return this.base_data_points.getAggregatedTags();
    }

    @Override
    public Deferred<List<String>> getAggregatedTagsAsync() {
        if (this.alias != null) {
            return Deferred.fromResult(Collections.emptyList());
        }
        return this.base_data_points.getAggregatedTagsAsync();
    }

    @Override
    public List<byte[]> getAggregatedTagUids() {
        if (this.alias != null) {
            return Collections.emptyList();
        }
        return this.base_data_points.getAggregatedTagUids();
    }

    @Override
    public List<String> getTSUIDs() {
        return this.base_data_points.getTSUIDs();
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.base_data_points.getAnnotations();
    }

    @Override
    public Bytes.ByteMap<byte[]> getTagUids() {
        return this.base_data_points.getTagUids();
    }

    @Override
    public int getQueryIndex() {
        return this.base_data_points.getQueryIndex();
    }

    @Override
    public int size() {
        return this.points.length;
    }

    @Override
    public int aggregatedSize() {
        return this.points.length;
    }

    @Override
    public SeekableView iterator() {
        return new SeekableViewImpl(this.points);
    }

    @Override
    public long timestamp(int i) {
        return this.points[i].timestamp();
    }

    @Override
    public boolean isInteger(int i) {
        return this.points[i].isInteger();
    }

    @Override
    public long longValue(int i) {
        return this.points[i].longValue();
    }

    @Override
    public double doubleValue(int i) {
        return this.points[i].doubleValue();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    static class SeekableViewImpl
    implements SeekableView {
        private int pos = 0;
        private final DataPoint[] dps;

        SeekableViewImpl(DataPoint[] dps) {
            this.dps = dps;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.dps.length;
        }

        @Override
        public DataPoint next() {
            if (this.hasNext()) {
                return this.dps[this.pos++];
            }
            throw new NoSuchElementException("no more elements");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void seek(long timestamp) {
            for (int i = this.pos; i < this.dps.length && this.dps[i].timestamp() < timestamp; ++i) {
                ++this.pos;
            }
        }
    }
}

