/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.ArrayList;
import java.util.List;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.PostAggregatedDataPoints;

public class Scale
implements Expression {
    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> query_results, List<String> params) {
        if (data_query == null) {
            throw new IllegalArgumentException("Missing time series query");
        }
        if (query_results == null || query_results.isEmpty()) {
            return new DataPoints[0];
        }
        if (params == null || params.isEmpty()) {
            throw new IllegalArgumentException("Missing scaling factor");
        }
        double scale_factor = 0.0;
        String factor = params.get(0);
        if (factor != null && factor.matches("^[-0-9\\.]+$")) {
            try {
                scale_factor = Double.parseDouble(factor);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Invalid parameter, must be an integer or floating point", nfe);
            }
        } else {
            throw new IllegalArgumentException("Unparseable scale factor value: " + scale_factor);
        }
        int num_results = 0;
        for (DataPoints[] results : query_results) {
            num_results += results.length;
        }
        DataPoints[] results = new DataPoints[num_results];
        int ix = 0;
        for (DataPoints[] sub_query_result : query_results) {
            for (DataPoints dps : sub_query_result) {
                results[ix++] = this.scale(dps, scale_factor);
            }
        }
        return results;
    }

    private DataPoints scale(DataPoints points, double scale_factor) {
        ArrayList<MutableDataPoint> dps = new ArrayList<MutableDataPoint>();
        boolean scale_is_int = scale_factor == Math.floor(scale_factor) && !Double.isInfinite(scale_factor);
        for (DataPoint pt : points) {
            if (pt.isInteger() && scale_is_int) {
                dps.add(MutableDataPoint.ofLongValue(pt.timestamp(), (long)scale_factor * pt.longValue()));
                continue;
            }
            dps.add(MutableDataPoint.ofDoubleValue(pt.timestamp(), scale_factor * pt.toDouble()));
        }
        DataPoint[] results = new DataPoint[dps.size()];
        dps.toArray(results);
        return new PostAggregatedDataPoints(points, results);
    }

    @Override
    public String writeStringField(List<String> query_params, String inner_expression) {
        return "scale(" + inner_expression + ")";
    }
}

