/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.List;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.EDPtoDPS;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.ExpressionIterator;
import net.opentsdb.query.expression.TimeSyncedIterator;
import net.opentsdb.query.expression.VariableIterator;

public class SumSeries
implements Expression {
    final TSDB tsdb;

    public SumSeries(TSDB tsdb) {
        this.tsdb = tsdb;
    }

    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> query_results, List<String> params) {
        if (data_query == null) {
            throw new IllegalArgumentException("Missing time series query");
        }
        if (query_results == null || query_results.isEmpty()) {
            return new DataPoints[0];
        }
        if (query_results.size() < 2 || query_results.size() > 26) {
            throw new IllegalArgumentException("Must have 2 to 26 series, got " + query_results.size() + " instead");
        }
        StringBuilder buf = new StringBuilder();
        char v = 'a';
        for (int i = 0; i < query_results.size(); ++i) {
            char c = v;
            v = (char)(v + 1);
            buf.append(c);
            if (i >= query_results.size() - 1) continue;
            buf.append(" + ");
        }
        System.out.println("Expression: [" + buf.toString() + "]");
        ExpressionIterator expression = new ExpressionIterator("sumSeries", buf.toString(), VariableIterator.SetOperator.UNION, false, false);
        v = 'a';
        for (DataPoints[] dps : query_results) {
            char c = v;
            v = (char)(v + 1);
            TimeSyncedIterator it = new TimeSyncedIterator(Character.toString(c), null, dps);
            expression.addResults(it.getId(), it);
        }
        expression.compile();
        DataPoints[] results = new DataPoints[expression.values().length];
        for (int i = 0; i < expression.values().length; ++i) {
            results[i] = new EDPtoDPS(this.tsdb, i, expression);
        }
        return results;
    }

    @Override
    public String writeStringField(List<String> query_params, String inner_expression) {
        return "sumSeries(" + inner_expression + ")";
    }
}

