/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.MutableDataPoint;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.Expression;
import net.opentsdb.query.expression.PostAggregatedDataPoints;

public class TimeShift
implements Expression {
    @Override
    public DataPoints[] evaluate(TSQuery data_query, List<DataPoints[]> results, List<String> params) {
        if (results == null || results.isEmpty()) {
            return new DataPoints[0];
        }
        if (params == null || results.isEmpty()) {
            throw new IllegalArgumentException("Need amount of timeshift to perform timeshift");
        }
        String param = params.get(0);
        if (param == null || param.length() == 0) {
            throw new IllegalArgumentException("Invalid timeshift='" + param + "'");
        }
        param = param.trim();
        long timeshift = -1L;
        if (!param.startsWith("'") || !param.endsWith("'")) {
            throw new RuntimeException("Invalid timeshift parameter: eg '10min'");
        }
        timeshift = TimeShift.parseParam(param) / 1000L;
        if (timeshift <= 0L) {
            throw new RuntimeException("timeshift <= 0");
        }
        DataPoints[] inputPoints = results.get(0);
        DataPoints[] outputPoints = new DataPoints[inputPoints.length];
        for (int n = 0; n < inputPoints.length; ++n) {
            outputPoints[n] = this.shift(inputPoints[n], timeshift);
        }
        return outputPoints;
    }

    public static long parseParam(String param) {
        char[] chars = param.toCharArray();
        int tuIndex = 0;
        for (int c = 1; c < chars.length && Character.isDigit(chars[c]); ++c) {
            ++tuIndex;
        }
        if (tuIndex == 0) {
            throw new RuntimeException("Invalid Parameter: " + param);
        }
        int time = Integer.parseInt(param.substring(1, tuIndex + 1));
        String unit = param.substring(tuIndex + 1, param.length() - 1);
        if ("sec".equals(unit)) {
            return TimeUnit.MILLISECONDS.convert(time, TimeUnit.SECONDS);
        }
        if ("min".equals(unit)) {
            return TimeUnit.MILLISECONDS.convert(time, TimeUnit.MINUTES);
        }
        if ("hr".equals(unit)) {
            return TimeUnit.MILLISECONDS.convert(time, TimeUnit.HOURS);
        }
        if ("day".equals(unit) || "days".equals(unit)) {
            return TimeUnit.MILLISECONDS.convert(time, TimeUnit.DAYS);
        }
        if ("week".equals(unit) || "weeks".equals(unit)) {
            return TimeUnit.MILLISECONDS.convert(time * 7, TimeUnit.DAYS);
        }
        throw new RuntimeException("unknown time unit=" + unit);
    }

    private DataPoints shift(DataPoints points, long timeshift) {
        ArrayList<MutableDataPoint> dps = new ArrayList<MutableDataPoint>();
        boolean shift_is_int = (double)timeshift == Math.floor(timeshift) && !Double.isInfinite(timeshift);
        for (DataPoint pt : points) {
            if (shift_is_int) {
                dps.add(MutableDataPoint.ofLongValue(pt.timestamp() + timeshift, pt.longValue()));
                continue;
            }
            dps.add(MutableDataPoint.ofDoubleValue(pt.timestamp() + timeshift, (double)timeshift * pt.toDouble()));
        }
        DataPoint[] results = new DataPoint[dps.size()];
        dps.toArray(results);
        return new PostAggregatedDataPoints(points, results);
    }

    @Override
    public String writeStringField(List<String> params, String inner_expression) {
        return "timeshift(" + inner_expression + ")";
    }
}

