/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import net.opentsdb.core.DataPoint;
import net.opentsdb.core.DataPoints;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.SeekableView;
import net.opentsdb.query.expression.ExpressionDataPoint;
import net.opentsdb.query.expression.ITimeSyncedIterator;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.utils.ByteSet;

public class TimeSyncedIterator
implements ITimeSyncedIterator {
    private final String id;
    private final ByteSet query_tagks;
    private final DataPoints[] dps;
    private final DataPoint[] current_values;
    private final ExpressionDataPoint[] emitter_values;
    private final SeekableView[] iterators;
    private int index;
    private NumericFillPolicy fill_policy;

    public TimeSyncedIterator(String id, ByteSet query_tagks, DataPoints[] dps) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Missing ID string");
        }
        if (dps == null) {
            throw new IllegalArgumentException("Missing data points");
        }
        this.id = id;
        this.query_tagks = query_tagks;
        this.dps = dps;
        this.fill_policy = new NumericFillPolicy(FillPolicy.ZERO);
        this.current_values = new DataPoint[dps.length];
        this.emitter_values = new ExpressionDataPoint[dps.length];
        this.iterators = new SeekableView[dps.length];
        this.setupEmitters();
    }

    private TimeSyncedIterator(TimeSyncedIterator iterator) {
        this.id = iterator.id;
        this.query_tagks = iterator.query_tagks;
        this.dps = iterator.dps;
        this.fill_policy = iterator.fill_policy;
        this.current_values = new DataPoint[this.dps.length];
        this.emitter_values = new ExpressionDataPoint[this.dps.length];
        this.iterators = new SeekableView[this.dps.length];
        this.setupEmitters();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TimeSyncedIterator(id=").append(this.id).append(", index=").append(this.index).append(", dpsSize=").append(this.dps.length).append(")");
        return buf.toString();
    }

    @Override
    public int size() {
        return this.dps.length;
    }

    @Override
    public boolean hasNext() {
        for (DataPoint dp : this.current_values) {
            if (dp == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExpressionDataPoint[] next(long timestamp) {
        for (int i = 0; i < this.current_values.length; ++i) {
            if (this.current_values[i] == null) {
                this.emitter_values[i].reset(timestamp, this.fill_policy.getValue());
                continue;
            }
            if (this.current_values[i].timestamp() > timestamp) {
                this.emitter_values[i].reset(timestamp, this.fill_policy.getValue());
                continue;
            }
            this.emitter_values[i].reset(this.current_values[i]);
            this.current_values[i] = !this.iterators[i].hasNext() ? null : this.iterators[i].next();
        }
        return this.emitter_values;
    }

    @Override
    public long nextTimestamp() {
        long ts = Long.MAX_VALUE;
        for (DataPoint dp : this.current_values) {
            long t;
            if (dp == null || (t = dp.timestamp()) >= ts) continue;
            ts = t;
        }
        return ts;
    }

    @Override
    public void next(int i) {
        if (this.current_values[i] == null) {
            throw new RuntimeException("No more elements");
        }
        this.emitter_values[i].reset(this.current_values[i]);
        this.current_values[i] = this.iterators[i].hasNext() ? this.iterators[i].next() : null;
    }

    @Override
    public boolean hasNext(int i) {
        return this.current_values[i] != null;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public DataPoints[] getDataPoints() {
        return this.dps;
    }

    @Override
    public void nullIterator(int index) {
        if (index < 0 || index > this.current_values.length) {
            throw new IllegalArgumentException("Index out of range: " + index);
        }
        this.current_values[index] = null;
    }

    @Override
    public ExpressionDataPoint[] values() {
        return this.emitter_values;
    }

    @Override
    public ByteSet getQueryTagKs() {
        return this.query_tagks;
    }

    @Override
    public void setFillPolicy(NumericFillPolicy policy) {
        this.fill_policy = policy;
    }

    @Override
    public NumericFillPolicy getFillPolicy() {
        return this.fill_policy;
    }

    @Override
    public ITimeSyncedIterator getCopy() {
        return new TimeSyncedIterator(this);
    }

    private void setupEmitters() {
        for (int i = 0; i < this.dps.length; ++i) {
            this.iterators[i] = this.dps[i].iterator();
            if (!this.iterators[i].hasNext()) {
                this.current_values[i] = null;
                this.emitter_values[i] = null;
                continue;
            }
            this.current_values[i] = this.iterators[i].next();
            this.emitter_values[i] = new ExpressionDataPoint(this.dps[i]);
            this.emitter_values[i].setIndex(i);
        }
    }
}

