/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression;

import java.util.HashMap;
import java.util.Map;
import net.opentsdb.core.FillPolicy;
import net.opentsdb.core.IllegalDataException;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.expression.ExpressionDataPoint;
import net.opentsdb.query.expression.ITimeSyncedIterator;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.query.expression.VariableIterator;
import net.opentsdb.utils.ByteSet;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class UnionIterator
implements ITimeSyncedIterator,
VariableIterator {
    private static final Logger LOG = LoggerFactory.getLogger(UnionIterator.class);
    private final Map<String, ITimeSyncedIterator> queries;
    private final Map<String, ExpressionDataPoint[]> current_values;
    private final Map<String, int[]> single_series_matrix;
    private final String[] index_to_names;
    private final boolean union_on_query_tagks;
    private final boolean include_agg_tags;
    private long timestamp;
    private int series_size;
    private final String id;
    private int index;
    private NumericFillPolicy fill_policy;
    private ExpressionDataPoint fill_dp;

    public UnionIterator(String id, Map<String, ITimeSyncedIterator> results, boolean union_on_query_tagks, boolean include_agg_tags) {
        this.id = id;
        this.union_on_query_tagks = union_on_query_tagks;
        this.include_agg_tags = include_agg_tags;
        this.timestamp = Long.MAX_VALUE;
        this.queries = new HashMap<String, ITimeSyncedIterator>(results.size());
        this.current_values = new HashMap<String, ExpressionDataPoint[]>(results.size());
        this.single_series_matrix = new HashMap<String, int[]>(results.size());
        this.index_to_names = new String[results.size()];
        this.fill_policy = new NumericFillPolicy(FillPolicy.ZERO);
        this.fill_dp = new ExpressionDataPoint();
        int i = 0;
        for (Map.Entry<String, ITimeSyncedIterator> entry : results.entrySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding iterator " + entry.getValue());
            }
            this.queries.put(entry.getKey(), entry.getValue());
            entry.getValue().setIndex(i);
            this.index_to_names[i] = entry.getKey();
            ++i;
        }
        this.computeUnion();
        for (ITimeSyncedIterator it : this.queries.values()) {
            long ts = it.nextTimestamp();
            if (ts >= this.timestamp) continue;
            this.timestamp = ts;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Computed union: " + this);
        }
    }

    private UnionIterator(UnionIterator iterator) {
        this.id = iterator.id;
        this.union_on_query_tagks = iterator.union_on_query_tagks;
        this.include_agg_tags = iterator.include_agg_tags;
        this.timestamp = Long.MAX_VALUE;
        this.queries = new HashMap<String, ITimeSyncedIterator>(iterator.queries.size());
        this.current_values = new HashMap<String, ExpressionDataPoint[]>(this.queries.size());
        this.single_series_matrix = new HashMap<String, int[]>(this.queries.size());
        this.index_to_names = new String[this.queries.size()];
        this.fill_policy = iterator.fill_policy;
        int i = 0;
        for (Map.Entry<String, ITimeSyncedIterator> entry : iterator.queries.entrySet()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding iterator " + entry.getValue());
            }
            this.queries.put(entry.getKey(), entry.getValue());
            entry.getValue().setIndex(i);
            this.index_to_names[i] = entry.getKey();
            ++i;
        }
        this.computeUnion();
        for (ITimeSyncedIterator it : this.queries.values()) {
            long ts = it.nextTimestamp();
            if (ts >= this.timestamp) continue;
            this.timestamp = ts;
        }
    }

    private void computeUnion() {
        Bytes.ByteMap ordered_union = new Bytes.ByteMap();
        for (ITimeSyncedIterator sub : this.queries.values()) {
            ExpressionDataPoint[] dps = sub.values();
            Bytes.ByteMap local_tags = new Bytes.ByteMap();
            for (int i = 0; i < sub.size(); ++i) {
                byte[] key = UnionIterator.flattenTags(this.union_on_query_tagks, this.include_agg_tags, dps[i], sub);
                local_tags.put((Object)key, (Object)i);
                ExpressionDataPoint[] udps = (ExpressionDataPoint[])ordered_union.get((Object)key);
                if (udps == null) {
                    udps = new ExpressionDataPoint[this.queries.size()];
                    ordered_union.put((Object)key, (Object)udps);
                }
                udps[sub.getIndex()] = dps[i];
            }
        }
        if (ordered_union.size() < 1) {
            return;
        }
        this.setCurrentAndMeta((Bytes.ByteMap<ExpressionDataPoint[]>)ordered_union);
    }

    private void setCurrentAndMeta(Bytes.ByteMap<ExpressionDataPoint[]> ordered_union) {
        for (String id : this.queries.keySet()) {
            this.current_values.put(id, new ExpressionDataPoint[ordered_union.size()]);
            int[] m = new int[ordered_union.size()];
            for (int i = 0; i < m.length; ++i) {
                m[i] = -1;
            }
            this.single_series_matrix.put(id, m);
        }
        int i = 0;
        for (Map.Entry entry : ordered_union.entrySet()) {
            ExpressionDataPoint[] idps = (ExpressionDataPoint[])entry.getValue();
            for (int x = 0; x < idps.length; ++x) {
                ExpressionDataPoint[] current_dps = this.current_values.get(this.index_to_names[x]);
                current_dps[i] = idps[x];
                int[] m = this.single_series_matrix.get(this.index_to_names[x]);
                if (idps[x] == null) continue;
                m[i] = idps[x].getIndex();
            }
            ++i;
        }
        for (ExpressionDataPoint[] idps : this.current_values.values()) {
            for (i = 0; i < idps.length; ++i) {
                if (idps[i] != null) continue;
                idps[i] = this.fill_dp;
            }
        }
        this.series_size = ordered_union.size();
    }

    static byte[] flattenTags(boolean use_query_tags, boolean include_agg_tags, ExpressionDataPoint dp, ITimeSyncedIterator sub) {
        int tag_size;
        ByteSet query_tagks;
        if (dp.tags() == null || dp.tags().isEmpty()) {
            return HBaseClient.EMPTY_ARRAY;
        }
        short tagk_width = TSDB.tagk_width();
        short tagv_width = TSDB.tagv_width();
        if (use_query_tags) {
            int i = 0;
            if (sub.getQueryTagKs() != null && !sub.getQueryTagKs().isEmpty()) {
                query_tagks = sub.getQueryTagKs();
                for (Map.Entry pair : dp.tags().entrySet()) {
                    if (!query_tagks.contains(pair.getKey())) continue;
                    ++i;
                }
            } else {
                query_tagks = new ByteSet();
            }
            tag_size = i;
        } else {
            query_tagks = new ByteSet();
            tag_size = dp.tags().size();
        }
        int length = tag_size * (tagk_width + tagv_width) + (include_agg_tags ? dp.aggregatedTags().size() * tagk_width : 0);
        byte[] key = new byte[length];
        int idx = 0;
        for (Map.Entry pair : dp.tags().entrySet()) {
            if (use_query_tags && !query_tagks.contains(pair.getKey())) continue;
            System.arraycopy(pair.getKey(), 0, key, idx, tagk_width);
            System.arraycopy(pair.getValue(), 0, key, idx += tagk_width, tagv_width);
            idx += tagv_width;
        }
        if (include_agg_tags) {
            for (byte[] tagk : dp.aggregatedTags()) {
                System.arraycopy(tagk, 0, key, idx, tagk_width);
                idx += tagk_width;
            }
        }
        return key;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("UnionIterator(id=").append(this.id).append(", useQueryTags=").append(this.union_on_query_tagks).append(", includeAggTags=").append(this.include_agg_tags).append(", index=").append(this.index).append(", queries=").append(this.queries);
        return buf.toString();
    }

    @Override
    public boolean hasNext() {
        for (ITimeSyncedIterator sub : this.queries.values()) {
            if (!sub.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExpressionDataPoint[] next(long timestamp) {
        throw new NotImplementedException();
    }

    @Override
    public long nextTimestamp() {
        long ts = Long.MAX_VALUE;
        for (ITimeSyncedIterator sub : this.queries.values()) {
            long t;
            if (sub == null || (t = sub.nextTimestamp()) >= ts) continue;
            ts = t;
        }
        return ts;
    }

    @Override
    public int size() {
        throw new NotImplementedException();
    }

    @Override
    public ExpressionDataPoint[] values() {
        throw new NotImplementedException();
    }

    @Override
    public void nullIterator(int index) {
        throw new NotImplementedException();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ByteSet getQueryTagKs() {
        throw new NotImplementedException();
    }

    @Override
    public void setFillPolicy(NumericFillPolicy policy) {
        this.fill_policy = policy;
    }

    @Override
    public NumericFillPolicy getFillPolicy() {
        return this.fill_policy;
    }

    @Override
    public ITimeSyncedIterator getCopy() {
        return new UnionIterator(this);
    }

    @Override
    public void next() {
        if (!this.hasNext()) {
            throw new IllegalDataException("No more data");
        }
        for (ITimeSyncedIterator sub : this.queries.values()) {
            sub.next(this.timestamp);
        }
        this.fill_dp.reset(this.timestamp, this.fill_policy.getValue());
        this.timestamp = this.nextTimestamp();
    }

    @Override
    public Map<String, ExpressionDataPoint[]> getResults() {
        return this.current_values;
    }

    @Override
    public int getSeriesSize() {
        return this.series_size;
    }

    @Override
    public boolean hasNext(int index) {
        for (Map.Entry<String, int[]> entry : this.single_series_matrix.entrySet()) {
            int idx = entry.getValue()[index];
            if (idx < 0 || !this.queries.get(entry.getKey()).hasNext(idx)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void next(int index) {
        if (!this.hasNext()) {
            throw new IllegalDataException("No more data");
        }
        for (Map.Entry<String, int[]> entry : this.single_series_matrix.entrySet()) {
            int idx = entry.getValue()[index];
            if (idx < 0) continue;
            this.queries.get(entry.getKey()).next(idx);
        }
    }
}

