/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.expression.parser;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.opentsdb.core.TSQuery;
import net.opentsdb.query.expression.ExpressionTree;
import net.opentsdb.query.expression.parser.ParseException;
import net.opentsdb.query.expression.parser.SimpleCharStream;
import net.opentsdb.query.expression.parser.SyntaxCheckerConstants;
import net.opentsdb.query.expression.parser.SyntaxCheckerTokenManager;
import net.opentsdb.query.expression.parser.Token;

public class SyntaxChecker
implements SyntaxCheckerConstants {
    private TSQuery data_query;
    private List<String> metricQueries;
    public SyntaxCheckerTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setTSQuery(TSQuery data_query) {
        this.data_query = data_query;
    }

    public void setMetricQueries(List<String> metricQueries) {
        this.metricQueries = metricQueries;
    }

    public static void main(String[] args) {
        try {
            new SyntaxChecker(new StringReader(args[0])).EXPRESSION();
            System.out.println("Syntax is okay");
        }
        catch (Throwable e) {
            System.out.println("Syntax check failed: " + e.getMessage());
        }
    }

    public final ExpressionTree EXPRESSION() throws ParseException {
        int paramIndex = 0;
        Token name = this.jj_consume_token(5);
        ExpressionTree tree = new ExpressionTree(name.image, this.data_query);
        this.jj_consume_token(7);
        this.PARAMETER(tree, paramIndex++);
        while (this.jj_2_1(5)) {
            this.jj_consume_token(8);
            this.PARAMETER(tree, paramIndex++);
        }
        this.jj_consume_token(9);
        if ("" != null) {
            return tree;
        }
        throw new Error("Missing return statement in function");
    }

    public final void PARAMETER(ExpressionTree tree, int paramIndex) throws ParseException {
        if (this.jj_2_2(5)) {
            ExpressionTree subTree = this.EXPRESSION();
            tree.addSubExpression(subTree, paramIndex);
        } else if (this.jj_2_3(5)) {
            String metric = this.METRIC();
            this.metricQueries.add(metric);
            tree.addSubMetricQuery(metric, this.metricQueries.size() - 1, paramIndex);
        } else if (this.jj_2_4(5)) {
            Token param = this.jj_consume_token(5);
            tree.addFunctionParameter(param.image);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final String METRIC() throws ParseException {
        StringBuilder builder = new StringBuilder();
        Joiner JOINER = Joiner.on((String)",").skipNulls();
        ArrayList tagPairs = Lists.newArrayList();
        Token agg = this.jj_consume_token(5);
        this.jj_consume_token(10);
        builder.append(agg.image).append(":");
        if (this.jj_2_5(5)) {
            Token itvl = this.jj_consume_token(5);
            this.jj_consume_token(10);
            builder.append(itvl.image).append(":");
        }
        if (this.jj_2_6(5)) {
            Token rate = this.jj_consume_token(5);
            this.jj_consume_token(10);
            builder.append(rate.image).append(":");
        }
        Token metric = this.jj_consume_token(5);
        builder.append(metric.image);
        if (this.jj_2_8(5)) {
            this.jj_consume_token(11);
            Token tagk = this.jj_consume_token(5);
            this.jj_consume_token(12);
            Token tagv = this.jj_consume_token(5);
            tagPairs.add(tagk + "=" + tagv);
            while (this.jj_2_7(5)) {
                this.jj_consume_token(8);
                tagk = this.jj_consume_token(5);
                this.jj_consume_token(12);
                tagv = this.jj_consume_token(5);
                tagPairs.add(tagk + "=" + tagv);
            }
            this.jj_consume_token(13);
        }
        if (tagPairs.size() > 0) {
            builder.append("{").append(JOINER.join((Iterable)tagPairs)).append("}");
        }
        if ("" != null) {
            return builder.toString();
        }
        throw new Error("Missing return statement in function");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    private boolean jj_3_3() {
        return this.jj_3R_5();
    }

    private boolean jj_3R_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_2()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_3()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_4()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_4();
    }

    private boolean jj_3R_4() {
        Token xsp;
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_3R_3()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(9);
    }

    private boolean jj_3_7() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_scan_token(5);
    }

    private boolean jj_3_8() {
        Token xsp;
        if (this.jj_scan_token(11)) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_7());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(13);
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_3();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_5() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_6()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(5)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_8()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_4() {
        return this.jj_scan_token(5);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    public SyntaxChecker(InputStream stream) {
        this(stream, null);
    }

    public SyntaxChecker(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SyntaxCheckerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SyntaxChecker(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SyntaxCheckerTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SyntaxCheckerTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SyntaxChecker(SyntaxCheckerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SyntaxCheckerTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[14];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 14; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SyntaxChecker.jj_la1_init_0();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

