/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.filter.TagVLiteralOrFilter;
import net.opentsdb.query.filter.TagVNotLiteralOrFilter;
import net.opentsdb.query.filter.TagVRegexFilter;
import net.opentsdb.query.filter.TagVWildcardFilter;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.Config;
import net.opentsdb.utils.Pair;
import net.opentsdb.utils.PluginLoader;
import org.hbase.async.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public abstract class TagVFilter
implements Comparable<TagVFilter> {
    private static final Logger LOG = LoggerFactory.getLogger(TagVFilter.class);
    private static Map<String, Pair<Class<?>, Constructor<? extends TagVFilter>>> tagv_filter_map = new HashMap();
    protected final String tagk;
    protected final String filter;
    protected byte[] tagk_bytes;
    protected List<byte[]> tagv_uids;
    @JsonProperty
    protected boolean group_by;
    protected boolean post_scan = true;

    public TagVFilter() {
        this.tagk = null;
        this.filter = null;
    }

    public TagVFilter(String tagk, String filter) {
        this.tagk = tagk;
        this.filter = filter;
        if (tagk == null || tagk.isEmpty()) {
            throw new IllegalArgumentException("Filter must have a tagk");
        }
    }

    public abstract Deferred<Boolean> match(Map<String, String> var1);

    public abstract String getType();

    @JsonIgnore
    public abstract String debugInfo();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("filter_name=").append(this.getType()).append(", tagk=").append(this.tagk).append(", group_by=").append(this.group_by).append(", tagk_bytes=").append(Bytes.pretty((byte[])this.tagk_bytes)).append(", config=").append(this.debugInfo());
        return buf.toString();
    }

    public static TagVFilter getFilter(String tagk, String filter) {
        if (tagk == null || tagk.isEmpty()) {
            throw new IllegalArgumentException("Tagk cannot be null or empty");
        }
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("Filter cannot be null or empty");
        }
        if (filter.length() == 1 && filter.charAt(0) == '*') {
            return null;
        }
        int paren = filter.indexOf(40);
        if (paren > -1) {
            String prefix = filter.substring(0, paren).toLowerCase();
            return new Builder().setTagk(tagk).setFilter(TagVFilter.stripParentheses(filter)).setType(prefix).build();
        }
        if (filter.contains("*")) {
            return new TagVWildcardFilter(tagk, filter, true);
        }
        return null;
    }

    public static String stripParentheses(String filter) {
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("Filter string cannot be null or empty");
        }
        if (filter.charAt(filter.length() - 1) != ')') {
            throw new IllegalArgumentException("Filter must end with a ')': " + filter);
        }
        int start_pos = filter.indexOf(40);
        if (start_pos < 0) {
            throw new IllegalArgumentException("Filter must include a '(': " + filter);
        }
        return filter.substring(start_pos + 1, filter.length() - 1);
    }

    public static void initializeFilterMap(TSDB tsdb) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException {
        List<TagVFilter> filter_plugins = PluginLoader.loadPlugins(TagVFilter.class);
        if (filter_plugins != null) {
            for (TagVFilter filter : filter_plugins) {
                filter.getClass().getDeclaredMethod("description", new Class[0]);
                filter.getClass().getDeclaredMethod("examples", new Class[0]);
                filter.getClass().getDeclaredField("FILTER_NAME");
                Method initialize = filter.getClass().getDeclaredMethod("initialize", TSDB.class);
                initialize.invoke(null, tsdb);
                Constructor<?> ctor = filter.getClass().getDeclaredConstructor(String.class, String.class);
                Pair<Class<?>, Constructor<TagVFilter>> existing = tagv_filter_map.get(filter.getType());
                if (existing != null) {
                    LOG.warn("Overloading existing filter " + existing.getClass().getCanonicalName() + " with new filter " + filter.getClass().getCanonicalName());
                }
                tagv_filter_map.put(filter.getType().toLowerCase(), new Pair(filter.getClass(), ctor));
                LOG.info("Successfully loaded TagVFilter plugin: " + filter.getClass().getCanonicalName());
            }
            LOG.info("Loaded " + tagv_filter_map.size() + " filters");
        }
    }

    public static void tagsToFilters(Map<String, String> tags, List<TagVFilter> filters) {
        TagVFilter.mapToFilters(tags, filters, true);
    }

    public static void mapToFilters(Map<String, String> map, List<TagVFilter> filters, boolean group_by) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            TagVFilter filter = TagVFilter.getFilter(entry.getKey(), entry.getValue());
            if (filter == null && entry.getValue().equals("*")) {
                filter = new TagVWildcardFilter(entry.getKey(), "*", true);
            } else if (filter == null) {
                filter = new TagVLiteralOrFilter(entry.getKey(), entry.getValue());
            }
            if (group_by) {
                filter.setGroupBy(true);
                boolean duplicate = false;
                for (TagVFilter existing : filters) {
                    if (!filter.equals(existing)) continue;
                    LOG.debug("Skipping duplicate filter: " + existing);
                    existing.setGroupBy(true);
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                filters.add(filter);
                continue;
            }
            filters.add(filter);
        }
    }

    public static Map<String, Map<String, String>> loadedFilters() {
        HashMap<String, Map<String, String>> filters = new HashMap<String, Map<String, String>>(tagv_filter_map.size());
        for (Pair<Class<?>, Constructor<TagVFilter>> pair : tagv_filter_map.values()) {
            HashMap<String, String> filter_meta = new HashMap<String, String>(1);
            try {
                Method method = pair.getKey().getDeclaredMethod("description", new Class[0]);
                filter_meta.put("description", (String)method.invoke(null, new Object[0]));
                method = pair.getKey().getDeclaredMethod("examples", new Class[0]);
                filter_meta.put("examples", (String)method.invoke(null, new Object[0]));
                Field filter_name = pair.getKey().getDeclaredField("FILTER_NAME");
                filters.put((String)filter_name.get(null), filter_meta);
            }
            catch (SecurityException e) {
                throw new RuntimeException("Unexpected security exception", e);
            }
            catch (NoSuchMethodException e) {
                LOG.error("Filter plugin " + pair.getClass().getCanonicalName() + " did not implement one of the \"description\" or \"examples\" methods");
            }
            catch (NoSuchFieldException e) {
                LOG.error("Filter plugin " + pair.getClass().getCanonicalName() + " did not have the \"FILTER_NAME\" field");
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Unexpected exception", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Unexpected security exception", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Unexpected security exception", e);
            }
        }
        return filters;
    }

    public Deferred<byte[]> resolveTagkName(TSDB tsdb) {
        class ResolvedCB
        implements Callback<byte[], byte[]> {
            ResolvedCB() {
            }

            public byte[] call(byte[] uid) throws Exception {
                TagVFilter.this.tagk_bytes = uid;
                return uid;
            }
        }
        return tsdb.getUIDAsync(UniqueId.UniqueIdType.TAGK, this.tagk).addCallback((Callback)new ResolvedCB());
    }

    public Deferred<byte[]> resolveTags(TSDB tsdb, Set<String> literals) {
        final Config config = tsdb.getConfig();
        ArrayList<Deferred> tagvs = new ArrayList<Deferred>(literals.size());
        for (String tagv : literals) {
            class TagVErrback
            implements Callback<byte[], Exception> {
                TagVErrback() {
                }

                public byte[] call(Exception e) throws Exception {
                    if (config.getBoolean("tsd.query.skip_unresolved_tagvs")) {
                        LOG.warn("Query tag value not found: " + e.getMessage());
                        return null;
                    }
                    throw e;
                }
            }
            tagvs.add(tsdb.getUIDAsync(UniqueId.UniqueIdType.TAGV, tagv).addErrback((Callback)new TagVErrback()));
        }
        class ResolvedTagKCB
        implements Callback<byte[], byte[]> {
            ResolvedTagKCB() {
            }

            public byte[] call(byte[] uid) throws Exception {
                TagVFilter.this.tagk_bytes = uid;
                return null;
            }
        }
        tagvs.add(tsdb.getUIDAsync(UniqueId.UniqueIdType.TAGK, this.tagk).addCallback((Callback)new ResolvedTagKCB()));
        class ResolvedTagVCB
        implements Callback<byte[], ArrayList<byte[]>> {
            ResolvedTagVCB() {
            }

            public byte[] call(ArrayList<byte[]> results) throws Exception {
                TagVFilter.this.tagv_uids = new ArrayList<byte[]>(results.size() - 1);
                for (byte[] tagv : results) {
                    if (tagv == null) continue;
                    TagVFilter.this.tagv_uids.add(tagv);
                }
                Collections.sort(TagVFilter.this.tagv_uids, Bytes.MEMCMP);
                return TagVFilter.this.tagk_bytes;
            }
        }
        return Deferred.group(tagvs).addCallback((Callback)new ResolvedTagVCB());
    }

    public String getTagk() {
        return this.tagk;
    }

    @JsonIgnore
    public byte[] getTagkBytes() {
        return this.tagk_bytes;
    }

    @JsonIgnore
    public List<byte[]> getTagVUids() {
        return this.tagv_uids == null ? Collections.emptyList() : this.tagv_uids;
    }

    @JsonIgnore
    public TagVFilter getCopy() {
        return TagVFilter.Builder().setFilter(this.filter).setTagk(this.tagk).setType(this.getType()).setGroupBy(this.group_by).build();
    }

    @JsonIgnore
    public boolean isGroupBy() {
        return this.group_by;
    }

    public void setGroupBy(boolean group_by) {
        this.group_by = group_by;
    }

    public String getFilter() {
        return this.filter;
    }

    @JsonIgnore
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean postScan() {
        return this.post_scan;
    }

    public void setPostScan(boolean post_scan) {
        this.post_scan = post_scan;
    }

    @Override
    public int compareTo(TagVFilter filter) {
        return Bytes.memcmpMaybeNull((byte[])this.tagk_bytes, (byte[])filter.tagk_bytes);
    }

    public static Builder Builder() {
        return new Builder();
    }

    static {
        try {
            tagv_filter_map.put("literal_or", new Pair(TagVLiteralOrFilter.class, TagVLiteralOrFilter.class.getDeclaredConstructor(String.class, String.class)));
            tagv_filter_map.put("iliteral_or", new Pair(TagVLiteralOrFilter.TagVILiteralOrFilter.class, TagVLiteralOrFilter.TagVILiteralOrFilter.class.getDeclaredConstructor(String.class, String.class)));
            tagv_filter_map.put("not_literal_or", new Pair(TagVNotLiteralOrFilter.class, TagVNotLiteralOrFilter.class.getDeclaredConstructor(String.class, String.class)));
            tagv_filter_map.put("not_iliteral_or", new Pair(TagVNotLiteralOrFilter.TagVNotILiteralOrFilter.class, TagVNotLiteralOrFilter.TagVNotILiteralOrFilter.class.getDeclaredConstructor(String.class, String.class)));
            tagv_filter_map.put("regexp", new Pair(TagVRegexFilter.class, TagVRegexFilter.class.getDeclaredConstructor(String.class, String.class)));
            tagv_filter_map.put("wildcard", new Pair(TagVWildcardFilter.class, TagVWildcardFilter.class.getDeclaredConstructor(String.class, String.class)));
            tagv_filter_map.put("iwildcard", new Pair(TagVWildcardFilter.TagVIWildcardFilter.class, TagVWildcardFilter.TagVIWildcardFilter.class.getDeclaredConstructor(String.class, String.class)));
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to load a tag value filter", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Failed to load a tag value filter", e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="set")
    public static class Builder {
        private String type;
        private String tagk;
        private String filter;
        @JsonProperty
        private boolean group_by;

        public Builder setType(String type) {
            this.type = type;
            return this;
        }

        public Builder setTagk(String tagk) {
            this.tagk = tagk;
            return this;
        }

        public Builder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder setGroupBy(boolean group_by) {
            this.group_by = group_by;
            return this;
        }

        public TagVFilter build() {
            TagVFilter tagv_filter;
            if (this.type == null || this.type.isEmpty()) {
                throw new IllegalArgumentException("The filter type cannot be null or empty");
            }
            if (this.tagk == null || this.tagk.isEmpty()) {
                throw new IllegalArgumentException("The tagk cannot be null or empty");
            }
            Pair filter_meta = (Pair)tagv_filter_map.get(this.type);
            if (filter_meta == null) {
                throw new IllegalArgumentException("Could not find a tag value filter of the type: " + this.type);
            }
            Constructor ctor = (Constructor)filter_meta.getValue();
            try {
                tagv_filter = (TagVFilter)ctor.newInstance(this.tagk, this.filter);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (InstantiationException e) {
                throw new RuntimeException("Failed to instantiate filter: " + this.type, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to instantiate filter: " + this.type, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() != null) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException("Failed to instantiate filter: " + this.type, e);
            }
            tagv_filter.setGroupBy(this.group_by);
            return tagv_filter;
        }
    }
}

