/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.opentsdb.core.TSDB;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.utils.Config;

public class TagVLiteralOrFilter
extends TagVFilter {
    public static final String FILTER_NAME = "literal_or";
    protected final Set<String> literals;
    protected final boolean case_insensitive;

    public TagVLiteralOrFilter(String tagk, String filter) {
        this(tagk, filter, false);
    }

    public TagVLiteralOrFilter(String tagk, String filter, boolean case_insensitive) {
        super(tagk, filter);
        this.case_insensitive = case_insensitive;
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("Filter cannot be null or empty");
        }
        if (filter.length() == 1 && filter.charAt(0) == '|') {
            throw new IllegalArgumentException("Filter must contain more than just a pipe");
        }
        String[] split = filter.split("\\|");
        if (case_insensitive) {
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].toLowerCase();
            }
        }
        this.literals = new HashSet<String>(Arrays.asList(split));
    }

    @Override
    public Deferred<Boolean> match(Map<String, String> tags) {
        String tagv = tags.get(this.tagk);
        if (tagv == null) {
            return Deferred.fromResult((Object)false);
        }
        return Deferred.fromResult((Object)this.literals.contains(this.case_insensitive ? tagv.toLowerCase() : tagv));
    }

    @Override
    public String debugInfo() {
        return "{literals=" + this.literals + ", case=" + this.case_insensitive + "}";
    }

    @Override
    public Deferred<byte[]> resolveTagkName(TSDB tsdb) {
        Config config = tsdb.getConfig();
        if (!this.case_insensitive && this.literals.size() <= config.getInt("tsd.query.filter.expansion_limit")) {
            return this.resolveTags(tsdb, this.literals);
        }
        return super.resolveTagkName(tsdb);
    }

    @JsonIgnore
    public boolean isCaseInsensitive() {
        return this.case_insensitive;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagVLiteralOrFilter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TagVLiteralOrFilter filter = (TagVLiteralOrFilter)obj;
        return Objects.equal((Object)this.tagk, (Object)filter.tagk) && Objects.equal(this.literals, filter.literals) && Objects.equal((Object)this.case_insensitive, (Object)filter.case_insensitive);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagk, this.literals, this.case_insensitive});
    }

    @Override
    public String getType() {
        return FILTER_NAME;
    }

    public static String description() {
        return "Accepts one or more exact values and matches if the series contains any of them. Multiple values can be included and must be separated by the | (pipe) character. The filter is case sensitive and will not allow characters that TSDB does not allow at write time.";
    }

    public static String examples() {
        return "host=literal_or(web01),  host=literal_or(web01|web02|web03)  {\"type\":\"literal_or\",\"tagk\":\"host\",\"filter\":\"web01|web02|web03\",\"groupBy\":false}";
    }

    public static class TagVILiteralOrFilter
    extends TagVLiteralOrFilter {
        public static final String FILTER_NAME = "iliteral_or";

        public TagVILiteralOrFilter(String tagk, String filter) {
            super(tagk, filter, true);
        }

        @Override
        public String getType() {
            return FILTER_NAME;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TagVILiteralOrFilter)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            TagVILiteralOrFilter filter = (TagVILiteralOrFilter)obj;
            return Objects.equal((Object)this.tagk, (Object)filter.tagk) && Objects.equal((Object)this.literals, (Object)filter.literals) && Objects.equal((Object)this.case_insensitive, (Object)filter.case_insensitive);
        }

        public static String description() {
            return "Accepts one or more exact values and matches if the series contains any of them. Multiple values can be included and must be separated by the | (pipe) character. The filter is case insensitive and will not allow characters that TSDB does not allow at write time.";
        }

        public static String examples() {
            return "host=iliteral_or(web01),  host=iliteral_or(web01|web02|web03)  {\"type\":\"iliteral_or\",\"tagk\":\"host\",\"filter\":\"web01|web02|web03\",\"groupBy\":false}";
        }
    }
}

