/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.filter;

import com.google.common.base.Objects;
import com.stumbleupon.async.Deferred;
import java.util.Map;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.query.filter.TagVRegexFilter;

public class TagVNotKeyFilter
extends TagVFilter {
    public static final String FILTER_NAME = "not_key";

    public TagVNotKeyFilter(String tagk, String filter) {
        super(tagk, "");
        if (filter != null && filter.length() > 0) {
            throw new IllegalArgumentException("The filter must be empty for the not_key filter");
        }
        this.post_scan = true;
    }

    @Override
    public Deferred<Boolean> match(Map<String, String> tags) {
        if (tags.containsKey(this.tagk)) {
            return Deferred.fromResult((Object)false);
        }
        return Deferred.fromResult((Object)true);
    }

    @Override
    public String getType() {
        return FILTER_NAME;
    }

    @Override
    public String debugInfo() {
        return "{}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagVRegexFilter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TagVNotKeyFilter filter = (TagVNotKeyFilter)obj;
        return Objects.equal((Object)this.tagk, (Object)filter.tagk);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagk});
    }

    public static String description() {
        return "Skips any time series with the given tag key, regardless of the value. This can be useful for situations where a metric has inconsistent tag sets. NOTE: The filter value must be null or an empty string.";
    }

    public static String examples() {
        return "host=not_key()  {\"type\":\"not_key\",\"tagk\":\"host\",\"filter\":\"\",\"groupBy\":false}";
    }
}

