/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.opentsdb.query.filter.TagVFilter;

public class TagVNotLiteralOrFilter
extends TagVFilter {
    public static final String FILTER_NAME = "not_literal_or";
    protected final Set<String> literals;
    protected final boolean case_insensitive;

    public TagVNotLiteralOrFilter(String tagk, String filter) {
        this(tagk, filter, false);
    }

    public TagVNotLiteralOrFilter(String tagk, String filter, boolean case_insensitive) {
        super(tagk, filter);
        this.case_insensitive = case_insensitive;
        if (filter == null || filter.isEmpty()) {
            throw new IllegalArgumentException("Filter cannot be null or empty");
        }
        if (filter.length() == 1 && filter.charAt(0) == '|') {
            throw new IllegalArgumentException("Filter must contain more than just a pipe");
        }
        String[] split = filter.split("\\|");
        if (case_insensitive) {
            for (int i = 0; i < split.length; ++i) {
                split[i] = split[i].toLowerCase();
            }
        }
        this.literals = new HashSet<String>(Arrays.asList(split));
    }

    @Override
    public Deferred<Boolean> match(Map<String, String> tags) {
        String tagv = tags.get(this.tagk);
        if (tagv == null) {
            return Deferred.fromResult((Object)true);
        }
        return Deferred.fromResult((Object)(!this.literals.contains(this.case_insensitive ? tagv.toLowerCase() : tagv) ? 1 : 0));
    }

    @Override
    public String debugInfo() {
        return "{literals=" + this.literals + ", case=" + this.case_insensitive + "}";
    }

    @JsonIgnore
    public boolean isCaseInsensitive() {
        return this.case_insensitive;
    }

    @Override
    public String getType() {
        return FILTER_NAME;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagVNotLiteralOrFilter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TagVNotLiteralOrFilter filter = (TagVNotLiteralOrFilter)obj;
        return Objects.equal((Object)this.tagk, (Object)filter.tagk) && Objects.equal(this.literals, filter.literals) && Objects.equal((Object)this.case_insensitive, (Object)filter.case_insensitive);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagk, this.literals, this.case_insensitive});
    }

    public static String description() {
        return "Accepts one or more exact values and matches if the series does NOT contain any of them. Multiple values can be included and must be separated by the | (pipe) character. The filter is case sensitive and will not allow characters that TSDB does not allow at write time.";
    }

    public static String examples() {
        return "host=not_literal_or(web01),  host=not_literal_or(web01|web02|web03)  {\"type\":\"not_literal_or\",\"tagk\":\"host\",\"filter\":\"web01|web02|web03\",\"groupBy\":false}";
    }

    public static class TagVNotILiteralOrFilter
    extends TagVNotLiteralOrFilter {
        public static final String FILTER_NAME = "not_iliteral_or";

        public TagVNotILiteralOrFilter(String tagk, String filter) {
            super(tagk, filter, true);
        }

        @Override
        public String getType() {
            return FILTER_NAME;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TagVNotILiteralOrFilter)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            TagVNotILiteralOrFilter filter = (TagVNotILiteralOrFilter)obj;
            return Objects.equal((Object)this.tagk, (Object)filter.tagk) && Objects.equal((Object)this.literals, (Object)filter.literals) && Objects.equal((Object)this.case_insensitive, (Object)filter.case_insensitive);
        }

        public static String description() {
            return "Accepts one or more exact values and matches if the series does NOT contain any of them. Multiple values can be included and must be separated by the | (pipe) character. The filter is case insensitive and will not allow characters that TSDB does not allow at write time.";
        }

        public static String examples() {
            return "host=not_iliteral_or(web01),  host=not_iliteral_or(web01|web02|web03)  {\"type\":\"not_iliteral_or\",\"tagk\":\"host\",\"filter\":\"web01|web02|web03\",\"groupBy\":false}";
        }
    }
}

