/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.filter;

import com.google.common.base.Objects;
import com.stumbleupon.async.Deferred;
import java.util.Map;
import java.util.regex.Pattern;
import net.opentsdb.query.filter.TagVFilter;

public class TagVRegexFilter
extends TagVFilter {
    public static final String FILTER_NAME = "regexp";
    final Pattern pattern;

    public TagVRegexFilter(String tagk, String filter) {
        super(tagk, filter);
        if (filter == null || filter.length() < 1) {
            throw new IllegalArgumentException("Filter cannot be null or empty");
        }
        this.pattern = Pattern.compile(filter);
    }

    @Override
    public Deferred<Boolean> match(Map<String, String> tags) {
        String tagv = tags.get(this.tagk);
        if (tagv == null) {
            return Deferred.fromResult((Object)false);
        }
        return Deferred.fromResult((Object)this.pattern.matcher(tagv).find());
    }

    @Override
    public String debugInfo() {
        return "{pattern=" + this.pattern.toString() + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagVRegexFilter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TagVRegexFilter filter = (TagVRegexFilter)obj;
        return Objects.equal((Object)this.tagk, (Object)filter.tagk) && Objects.equal((Object)this.pattern.pattern(), (Object)filter.pattern.pattern());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagk, this.pattern.pattern()});
    }

    @Override
    public String getType() {
        return FILTER_NAME;
    }

    public static String description() {
        return "Provides full, POSIX compliant regular expression using the built in Java Pattern class. Note that an expression containing curly braces {} will not parse properly in URLs. If the pattern is not a valid regular expression then an exception will be raised.";
    }

    public static String examples() {
        return "host=regexp(.*)  {\"type\":\"regexp\",\"tagk\":\"host\",\"filter\":\".*\",\"groupBy\":false}";
    }
}

