/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Objects;
import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.Map;
import net.opentsdb.core.Tags;
import net.opentsdb.query.filter.TagVFilter;

public class TagVWildcardFilter
extends TagVFilter {
    public static final String FILTER_NAME = "wildcard";
    protected final boolean has_postfix;
    protected final boolean has_prefix;
    protected final String[] components;
    protected boolean case_insensitive;

    public TagVWildcardFilter(String tagk, String filter) {
        this(tagk, filter, false);
    }

    public TagVWildcardFilter(String tagk, String filter, boolean case_insensitive) {
        super(tagk, filter);
        String actual;
        this.case_insensitive = case_insensitive;
        if (filter == null || filter.length() < 1) {
            throw new IllegalArgumentException("Filter cannot be null or empty");
        }
        String string = actual = case_insensitive ? filter.toLowerCase() : filter;
        if (!actual.contains("*")) {
            throw new IllegalArgumentException("Filter must contain an asterisk");
        }
        if (actual.charAt(0) == '*') {
            this.has_postfix = true;
            while (actual.charAt(0) == '*' && actual.length() >= 2) {
                actual = actual.substring(1);
            }
        } else {
            this.has_postfix = false;
        }
        if (actual.charAt(actual.length() - 1) == '*') {
            this.has_prefix = true;
            while (actual.charAt(actual.length() - 1) == '*' && actual.length() >= 2) {
                actual = actual.substring(0, actual.length() - 1);
            }
        } else {
            this.has_prefix = false;
        }
        if (actual.indexOf(42) > 0) {
            this.components = Tags.splitString(actual, '*');
        } else {
            this.components = new String[1];
            this.components[0] = actual;
        }
        if (this.components.length == 1 && this.components[0].equals("*")) {
            this.post_scan = false;
        }
    }

    @Override
    public Deferred<Boolean> match(Map<String, String> tags) {
        String tagv = tags.get(this.tagk);
        if (tagv == null) {
            return Deferred.fromResult((Object)false);
        }
        if (this.components.length == 1 && this.components[0].equals("*")) {
            return Deferred.fromResult((Object)true);
        }
        if (this.case_insensitive) {
            tagv = tags.get(this.tagk).toLowerCase();
        }
        if (this.has_postfix && !this.has_prefix && !tagv.endsWith(this.components[this.components.length - 1])) {
            return Deferred.fromResult((Object)false);
        }
        if (this.has_prefix && !this.has_postfix && !tagv.startsWith(this.components[0])) {
            return Deferred.fromResult((Object)false);
        }
        int idx = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (tagv.indexOf(this.components[i], idx) < 0) {
                return Deferred.fromResult((Object)false);
            }
            idx += this.components[i].length();
        }
        return Deferred.fromResult((Object)true);
    }

    @Override
    public String debugInfo() {
        return "{components=" + Arrays.toString(this.components) + ", case=" + this.case_insensitive + "}";
    }

    @JsonIgnore
    public boolean isCaseInsensitive() {
        return this.case_insensitive;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagVWildcardFilter)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        TagVWildcardFilter filter = (TagVWildcardFilter)obj;
        return Objects.equal((Object)this.tagk, (Object)filter.tagk) && Arrays.equals(this.components, filter.components) && Objects.equal((Object)this.case_insensitive, (Object)filter.case_insensitive);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tagk, Arrays.hashCode(this.components), this.case_insensitive});
    }

    @Override
    public String getType() {
        return FILTER_NAME;
    }

    public static String description() {
        return "Performs pre, post and in-fix glob matching of values. The globs are case sensitive and multiple wildcards can be used. The wildcard character is the * (asterisk). At least one wildcard must be present in the filter value. A wildcard by itself can be used as well to match on any value for the tag key.";
    }

    public static String examples() {
        return "host=wildcard(web*),  host=wildcard(web*.tsdb.net)  {\"type\":\"wildcard\",\"tagk\":\"host\",\"filter\":\"web*.tsdb.net\",\"groupBy\":false}";
    }

    public static class TagVIWildcardFilter
    extends TagVWildcardFilter {
        public static final String FILTER_NAME = "iwildcard";

        public TagVIWildcardFilter(String tagk, String filter) {
            super(tagk, filter, true);
        }

        @Override
        public String getType() {
            return FILTER_NAME;
        }

        public static String description() {
            return "Performs pre, post and in-fix glob matching of values. The globs are case insensitive and multiple wildcards can be used. The wildcard character is the * (asterisk). Case insensitivity is achieved by dropping all values to lower case. At least one wildcard must be present in the filter value. A wildcard by itself can be used as well to match on any value for the tag key.";
        }

        public static String examples() {
            return "host=iwildcard(web*),  host=iwildcard(web*.tsdb.net)  {\"type\":\"iwildcard\",\"tagk\":\"host\",\"filter\":\"web*.tsdb.net\",\"groupBy\":false}";
        }
    }
}

