/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregators;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.query.pojo.Validatable;
import net.opentsdb.utils.DateTime;

@JsonDeserialize(builder=Builder.class)
public class Downsampler
extends Validatable {
    private String interval;
    private String aggregator;
    private NumericFillPolicy fill_policy;

    public Downsampler(Builder builder) {
        this.interval = builder.interval;
        this.aggregator = builder.aggregator;
        this.fill_policy = builder.fillPolicy;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.interval == null || this.interval.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty interval");
        }
        DateTime.parseDuration(this.interval);
        if (this.aggregator == null || this.aggregator.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty aggregator");
        }
        try {
            Aggregators.get(this.aggregator.toLowerCase());
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid aggregator");
        }
        if (this.fill_policy != null) {
            this.fill_policy.validate();
        }
    }

    public String getInterval() {
        return this.interval;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public NumericFillPolicy getFillPolicy() {
        return this.fill_policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Downsampler downsampler = (Downsampler)o;
        return Objects.equal((Object)this.interval, (Object)downsampler.interval) && Objects.equal((Object)this.aggregator, (Object)downsampler.aggregator) && Objects.equal((Object)this.fill_policy, (Object)downsampler.fill_policy);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.interval, this.aggregator, this.fill_policy});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String interval;
        @JsonProperty
        private String aggregator;
        @JsonProperty
        private NumericFillPolicy fillPolicy;

        public Builder setInterval(String interval) {
            this.interval = interval;
            return this;
        }

        public Builder setAggregator(String aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public Builder setFillPolicy(NumericFillPolicy fill_policy) {
            this.fillPolicy = fill_policy;
            return this;
        }

        public Downsampler build() {
            return new Downsampler(this);
        }
    }
}

