/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.opentsdb.query.expression.ExpressionIterator;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.query.expression.VariableIterator;
import net.opentsdb.query.pojo.Join;
import net.opentsdb.query.pojo.Query;
import net.opentsdb.query.pojo.Validatable;
import org.apache.commons.jexl2.Script;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class Expression
extends Validatable {
    private String id;
    private String expr;
    private Join join;
    private NumericFillPolicy fill_policy;
    private Set<String> variables;
    private Script parsed_expression;

    protected Expression(Builder builder) {
        this.id = builder.id;
        this.expr = builder.expr;
        this.join = builder.join;
        this.fill_policy = builder.fillPolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getExpr() {
        return this.expr;
    }

    public Join getJoin() {
        return this.join;
    }

    public NumericFillPolicy getFillPolicy() {
        return this.fill_policy;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalArgumentException("missing or empty id");
        }
        Query.validateId(this.id);
        if (this.expr == null || this.expr.isEmpty()) {
            throw new IllegalArgumentException("missing or empty expr");
        }
        this.parsed_expression = ExpressionIterator.JEXL_ENGINE.createScript(this.expr);
        this.variables = new HashSet<String>();
        for (List exp_list : ExpressionIterator.JEXL_ENGINE.getVariables(this.parsed_expression)) {
            for (String variable : exp_list) {
                this.variables.add(variable);
            }
        }
        if (this.join == null) {
            this.join = Join.Builder().setOperator(VariableIterator.SetOperator.UNION).build();
        }
    }

    @JsonIgnore
    public Script getParsedExpression() {
        return this.parsed_expression;
    }

    @JsonIgnore
    public Set<String> getVariables() {
        return this.variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expression expression = (Expression)o;
        return Objects.equal((Object)this.id, (Object)expression.id) && Objects.equal((Object)this.expr, (Object)expression.expr) && Objects.equal((Object)this.join, (Object)expression.join) && Objects.equal((Object)this.fill_policy, (Object)expression.fill_policy);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.expr, this.join, this.fill_policy});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String id;
        @JsonProperty
        private String expr;
        @JsonProperty
        private Join join;
        @JsonProperty
        private NumericFillPolicy fillPolicy;

        public Builder setId(String id) {
            Query.validateId(id);
            this.id = id;
            return this;
        }

        public Builder setExpression(String expr) {
            this.expr = expr;
            return this;
        }

        public Builder setJoin(Join join) {
            this.join = join;
            return this;
        }

        public Builder setFillPolicy(NumericFillPolicy fill_policy) {
            this.fillPolicy = fill_policy;
            return this;
        }

        public Expression build() {
            return new Expression(this);
        }
    }
}

