/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import java.util.List;
import net.opentsdb.query.filter.TagVFilter;
import net.opentsdb.query.pojo.Query;
import net.opentsdb.query.pojo.Validatable;

@JsonDeserialize(builder=Builder.class)
public class Filter
extends Validatable {
    private String id;
    private List<TagVFilter> tags;
    private boolean explicit_tags;

    private Filter(Builder builder) {
        this.id = builder.id;
        this.tags = builder.tags;
        this.explicit_tags = builder.explicitTags;
    }

    public String getId() {
        return this.id;
    }

    public List<TagVFilter> getTags() {
        return this.tags;
    }

    public boolean getExplicitTags() {
        return this.explicit_tags;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty id");
        }
        Query.validateId(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Filter filter = (Filter)o;
        return Objects.equal((Object)this.id, (Object)filter.id) && Objects.equal(this.tags, filter.tags) && Objects.equal((Object)this.explicit_tags, (Object)filter.explicit_tags);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.tags, this.explicit_tags});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String id;
        @JsonProperty
        private List<TagVFilter> tags;
        @JsonProperty
        private boolean explicitTags;

        public Builder setId(String id) {
            Query.validateId(id);
            this.id = id;
            return this;
        }

        public Builder setTags(List<TagVFilter> tags) {
            this.tags = tags;
            return this;
        }

        public Builder setExplicitTags(boolean explicit_tags) {
            this.explicitTags = explicit_tags;
            return this;
        }

        public Filter build() {
            return new Filter(this);
        }
    }
}

