/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import net.opentsdb.query.expression.VariableIterator;
import net.opentsdb.query.pojo.Validatable;

@JsonDeserialize(builder=Builder.class)
public class Join
extends Validatable {
    private VariableIterator.SetOperator operator;
    private boolean use_query_tags = false;
    private boolean include_agg_tags = true;

    public Join(Builder builder) {
        this.operator = builder.operator;
        this.use_query_tags = builder.useQueryTags;
        this.include_agg_tags = builder.includeAggTags;
    }

    public VariableIterator.SetOperator getOperator() {
        return this.operator;
    }

    public boolean getUseQueryTags() {
        return this.use_query_tags;
    }

    public boolean getIncludeAggTags() {
        return this.include_agg_tags;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.operator == null) {
            throw new IllegalArgumentException("Missing join operator");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Join join = (Join)o;
        return Objects.equal((Object)((Object)this.operator), (Object)((Object)join.operator)) && Objects.equal((Object)this.use_query_tags, (Object)join.use_query_tags) && Objects.equal((Object)this.include_agg_tags, (Object)join.include_agg_tags);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.operator, this.use_query_tags, this.include_agg_tags});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private VariableIterator.SetOperator operator;
        @JsonProperty
        private boolean useQueryTags = false;
        @JsonProperty
        private boolean includeAggTags = true;

        public Builder setOperator(VariableIterator.SetOperator operator) {
            this.operator = operator;
            return this;
        }

        public Builder setUseQueryTags(boolean use_query_tags) {
            this.useQueryTags = use_query_tags;
            return this;
        }

        public Builder setIncludeAggTags(boolean include_agg_tags) {
            this.includeAggTags = include_agg_tags;
            return this;
        }

        public Join build() {
            return new Join(this);
        }
    }
}

