/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregators;
import net.opentsdb.query.expression.NumericFillPolicy;
import net.opentsdb.query.pojo.Query;
import net.opentsdb.query.pojo.Validatable;
import net.opentsdb.utils.DateTime;

@JsonDeserialize(builder=Builder.class)
public class Metric
extends Validatable {
    private String metric;
    private String id;
    private String filter;
    private String time_offset;
    private String aggregator;
    private NumericFillPolicy fill_policy;

    public Metric(Builder builder) {
        this.metric = builder.metric;
        this.id = builder.id;
        this.filter = builder.filter;
        this.time_offset = builder.timeOffset;
        this.aggregator = builder.aggregator;
        this.fill_policy = builder.fillPolicy;
    }

    public String getMetric() {
        return this.metric;
    }

    public String getId() {
        return this.id;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getTimeOffset() {
        return this.time_offset;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public NumericFillPolicy getFillPolicy() {
        return this.fill_policy;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.metric == null || this.metric.isEmpty()) {
            throw new IllegalArgumentException("missing or empty metric");
        }
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalArgumentException("missing or empty id");
        }
        Query.validateId(this.id);
        if (this.time_offset != null) {
            DateTime.parseDateTimeString(this.time_offset, null);
        }
        if (this.aggregator != null && !this.aggregator.isEmpty()) {
            try {
                Aggregators.get(this.aggregator.toLowerCase());
            }
            catch (NoSuchElementException e) {
                throw new IllegalArgumentException("Invalid aggregator");
            }
        }
        if (this.fill_policy != null) {
            this.fill_policy.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric that = (Metric)o;
        return Objects.equal((Object)that.filter, (Object)this.filter) && Objects.equal((Object)that.id, (Object)this.id) && Objects.equal((Object)that.metric, (Object)this.metric) && Objects.equal((Object)that.time_offset, (Object)this.time_offset) && Objects.equal((Object)that.aggregator, (Object)this.aggregator) && Objects.equal((Object)that.fill_policy, (Object)this.fill_policy);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.metric, this.id, this.filter, this.time_offset, this.aggregator, this.fill_policy});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String metric;
        @JsonProperty
        private String id;
        @JsonProperty
        private String filter;
        @JsonProperty
        private String timeOffset;
        @JsonProperty
        private String aggregator;
        @JsonProperty
        private NumericFillPolicy fillPolicy;

        public Builder setMetric(String metric) {
            this.metric = metric;
            return this;
        }

        public Builder setId(String id) {
            Query.validateId(id);
            this.id = id;
            return this;
        }

        public Builder setFilter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder setTimeOffset(String time_offset) {
            this.timeOffset = time_offset;
            return this;
        }

        public Builder setAggregator(String aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public Builder setFillPolicy(NumericFillPolicy fill_policy) {
            this.fillPolicy = fill_policy;
            return this;
        }

        public Metric build() {
            return new Metric(this);
        }
    }
}

