/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import net.opentsdb.query.pojo.Query;
import net.opentsdb.query.pojo.Validatable;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class Output
extends Validatable {
    private String id;
    private String alias;

    public Output(Builder builder) {
        this.id = builder.id;
        this.alias = builder.alias;
    }

    public String getId() {
        return this.id;
    }

    public String getAlias() {
        return this.alias;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalArgumentException("missing or empty id");
        }
        Query.validateId(this.id);
    }

    public String toString() {
        return "var=" + this.id + ", alias=" + this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Output output = (Output)o;
        return Objects.equal((Object)output.alias, (Object)this.alias) && Objects.equal((Object)output.id, (Object)this.id);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.alias});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String id;
        @JsonProperty
        private String alias;

        public Builder setId(String id) {
            Query.validateId(id);
            this.id = id;
            return this;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Output build() {
            return new Output(this);
        }
    }
}

