/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import java.util.HashSet;
import java.util.List;
import net.opentsdb.query.pojo.Expression;
import net.opentsdb.query.pojo.Filter;
import net.opentsdb.query.pojo.Metric;
import net.opentsdb.query.pojo.Output;
import net.opentsdb.query.pojo.Timespan;
import net.opentsdb.query.pojo.Validatable;
import net.opentsdb.utils.JSON;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class Query
extends Validatable {
    private String name;
    private Timespan time;
    private List<Filter> filters;
    private List<Metric> metrics;
    private List<Expression> expressions;
    private List<Output> outputs;

    public Query(Builder builder) {
        this.name = builder.name;
        this.time = builder.time;
        this.filters = builder.filters;
        this.metrics = builder.metrics;
        this.expressions = builder.expressions;
        this.outputs = builder.outputs;
    }

    public String getName() {
        return this.name;
    }

    public Timespan getTime() {
        return this.time;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public List<Output> getOutputs() {
        return this.outputs;
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.time == null) {
            throw new IllegalArgumentException("missing time");
        }
        this.validatePOJO(this.time, "time");
        if (this.metrics == null || this.metrics.isEmpty()) {
            throw new IllegalArgumentException("missing or empty metrics");
        }
        HashSet<String> variable_ids = new HashSet<String>();
        for (Metric metric : this.metrics) {
            if (variable_ids.contains(metric.getId())) {
                throw new IllegalArgumentException("duplicated metric id: " + metric.getId());
            }
            variable_ids.add(metric.getId());
        }
        HashSet<String> filter_ids = new HashSet<String>();
        for (Filter filter : this.filters) {
            if (filter_ids.contains(filter.getId())) {
                throw new IllegalArgumentException("duplicated filter id: " + filter.getId());
            }
            filter_ids.add(filter.getId());
        }
        for (Expression expression : this.expressions) {
            if (variable_ids.contains(expression.getId())) {
                throw new IllegalArgumentException("Duplicated variable or expression id: " + expression.getId());
            }
            variable_ids.add(expression.getId());
        }
        this.validateCollection(this.metrics, "metric");
        if (this.filters != null) {
            this.validateCollection(this.filters, "filter");
        }
        if (this.expressions != null) {
            this.validateCollection(this.expressions, "expression");
        }
        this.validateFilters();
        if (this.expressions != null) {
            this.validateCollection(this.expressions, "expression");
            for (Expression exp : this.expressions) {
                if (exp.getVariables() == null) {
                    throw new IllegalArgumentException("No variables found for an expression?! " + JSON.serializeToString(exp));
                }
                for (String var : exp.getVariables()) {
                    if (variable_ids.contains(var)) continue;
                    throw new IllegalArgumentException("Expression [" + exp.getExpr() + "] was missing input " + var);
                }
            }
        }
    }

    private void validateFilters() {
        HashSet<String> ids = new HashSet<String>();
        for (Filter filter : this.filters) {
            ids.add(filter.getId());
        }
        for (Metric metric : this.metrics) {
            if (metric.getFilter() == null || metric.getFilter().isEmpty() || ids.contains(metric.getFilter())) continue;
            throw new IllegalArgumentException(String.format("unrecognized filter id %s in metric %s", metric.getFilter(), metric.getId()));
        }
    }

    public static void validateId(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The ID cannot be null or empty");
        }
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            throw new IllegalArgumentException("Invalid id (\"" + id + "\"): illegal character: " + c);
        }
        if (id.length() == 1 && Character.isDigit(id.charAt(0))) {
            throw new IllegalArgumentException("The ID cannot be an integer");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equal(query.expressions, this.expressions) && Objects.equal(query.filters, this.filters) && Objects.equal(query.metrics, this.metrics) && Objects.equal((Object)query.name, (Object)this.name) && Objects.equal(query.outputs, this.outputs) && Objects.equal((Object)query.time, (Object)this.time);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.time, this.filters, this.metrics, this.expressions, this.outputs});
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String name;
        @JsonProperty
        private Timespan time;
        @JsonProperty
        private List<Filter> filters;
        @JsonProperty
        private List<Metric> metrics;
        @JsonProperty
        private List<Expression> expressions;
        @JsonProperty
        private List<Output> outputs;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTime(Timespan time) {
            this.time = time;
            return this;
        }

        public Builder setFilters(List<Filter> filters) {
            this.filters = filters;
            return this;
        }

        public Builder setMetrics(List<Metric> metrics) {
            this.metrics = metrics;
            return this;
        }

        public Builder setExpressions(List<Expression> expressions) {
            this.expressions = expressions;
            return this;
        }

        public Builder setOutputs(List<Output> outputs) {
            this.outputs = outputs;
            return this;
        }

        public Query build() {
            return new Query(this);
        }
    }
}

