/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.query.pojo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import java.util.NoSuchElementException;
import net.opentsdb.core.Aggregators;
import net.opentsdb.query.pojo.Downsampler;
import net.opentsdb.query.pojo.Validatable;
import net.opentsdb.utils.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonDeserialize(builder=Builder.class)
public class Timespan
extends Validatable {
    private String start;
    private String end;
    private String timezone;
    private Downsampler downsampler;
    private String aggregator;
    private boolean rate;

    public Timespan(Builder builder) {
        this.start = builder.start;
        this.end = builder.end;
        this.timezone = builder.timezone;
        this.downsampler = builder.downsampler;
        this.aggregator = builder.aggregator;
        this.rate = builder.rate;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public Downsampler getDownsampler() {
        return this.downsampler;
    }

    public String getAggregator() {
        return this.aggregator;
    }

    public boolean isRate() {
        return this.rate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timespan timespan = (Timespan)o;
        return Objects.equal((Object)timespan.downsampler, (Object)this.downsampler) && Objects.equal((Object)timespan.end, (Object)this.end) && Objects.equal((Object)timespan.start, (Object)this.start) && Objects.equal((Object)timespan.timezone, (Object)this.timezone) && Objects.equal((Object)timespan.aggregator, (Object)this.aggregator) && Objects.equal((Object)timespan.rate, (Object)this.rate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end, this.timezone, this.downsampler, this.aggregator, this.rate});
    }

    public static Builder Builder() {
        return new Builder();
    }

    @Override
    public void validate() {
        if (this.start == null || this.start.isEmpty()) {
            throw new IllegalArgumentException("missing or empty start");
        }
        DateTime.parseDateTimeString(this.start, this.timezone);
        if (this.end != null && !this.end.isEmpty()) {
            DateTime.parseDateTimeString(this.end, this.timezone);
        }
        if (this.downsampler != null) {
            this.downsampler.validate();
        }
        if (this.aggregator == null || this.aggregator.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty aggregator");
        }
        try {
            Aggregators.get(this.aggregator.toLowerCase());
        }
        catch (NoSuchElementException e) {
            throw new IllegalArgumentException("Invalid aggregator");
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonPOJOBuilder(buildMethodName="build", withPrefix="")
    public static final class Builder {
        @JsonProperty
        private String start;
        @JsonProperty
        private String end;
        @JsonProperty
        private String timezone;
        @JsonProperty
        private Downsampler downsampler;
        @JsonProperty
        private String aggregator;
        @JsonProperty
        private boolean rate;

        public Builder setStart(String start) {
            this.start = start;
            return this;
        }

        public Builder setEnd(String end) {
            this.end = end;
            return this;
        }

        public Builder setTimezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder setDownsampler(Downsampler downsample) {
            this.downsampler = downsample;
            return this;
        }

        public Builder setAggregator(String aggregator) {
            this.aggregator = aggregator;
            return this;
        }

        public Builder setRate(boolean rate) {
            this.rate = rate;
            return this;
        }

        public Timespan build() {
            return new Timespan(this);
        }
    }
}

