/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.List;
import net.opentsdb.utils.Pair;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchQuery {
    private SearchType type;
    private String query;
    private String metric;
    private List<Pair<String, String>> tags;
    private boolean use_meta;
    private int limit;
    private int start_index;
    private int total_results;
    private float time;
    private List<Object> results;

    public SearchQuery() {
        this.metric = "*";
        this.use_meta = true;
        this.limit = 25;
    }

    public SearchQuery(String metric) {
        this.metric = metric;
        this.use_meta = true;
        this.limit = 25;
    }

    public SearchQuery(List<Pair<String, String>> tags) {
        this.tags = tags;
        this.metric = "*";
        this.use_meta = true;
        this.limit = 25;
    }

    public SearchQuery(String metric, List<Pair<String, String>> tags) {
        this.metric = metric;
        this.tags = tags;
        this.use_meta = true;
        this.limit = 25;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("type=").append((Object)this.type).append(", query=").append(this.query).append(", metric=").append(this.metric).append(", tags=[");
        if (this.tags != null) {
            for (int i = 0; i < this.tags.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append("{").append(this.tags.get(i).getKey()).append("=").append(this.tags.get(i).getValue()).append("}");
            }
        }
        buf.append("], use_meta=").append(this.use_meta).append(", limit=").append(this.limit).append(", start_index=").append(this.start_index);
        return buf.toString();
    }

    public static SearchType parseSearchType(String type) {
        if (type == null || type.isEmpty()) {
            throw new IllegalArgumentException("Type provided was null or empty");
        }
        if (type.toLowerCase().equals("tsmeta")) {
            return SearchType.TSMETA;
        }
        if (type.toLowerCase().equals("tsmeta_summary")) {
            return SearchType.TSMETA_SUMMARY;
        }
        if (type.toLowerCase().equals("tsuids")) {
            return SearchType.TSUIDS;
        }
        if (type.toLowerCase().equals("uidmeta")) {
            return SearchType.UIDMETA;
        }
        if (type.toLowerCase().equals("annotation")) {
            return SearchType.ANNOTATION;
        }
        if (type.toLowerCase().equals("lookup")) {
            return SearchType.LOOKUP;
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public SearchType getType() {
        return this.type;
    }

    public String getQuery() {
        return this.query;
    }

    public String getMetric() {
        return this.metric;
    }

    public List<Pair<String, String>> getTags() {
        return this.tags;
    }

    public boolean useMeta() {
        return this.use_meta;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getStartIndex() {
        return this.start_index;
    }

    public int getTotalResults() {
        return this.total_results;
    }

    public float getTime() {
        return this.time;
    }

    public List<Object> getResults() {
        if (this.results == null) {
            return Collections.emptyList();
        }
        return this.results;
    }

    public void setType(SearchType type) {
        this.type = type;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public void setTags(List<Pair<String, String>> tags) {
        this.tags = tags;
    }

    public void setUseMeta(boolean use_meta) {
        this.use_meta = use_meta;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStartIndex(int start_index) {
        this.start_index = start_index;
    }

    public void setTotalResults(int total_results) {
        this.total_results = total_results;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public void setResults(List<Object> results) {
        this.results = results;
    }

    public static enum SearchType {
        TSMETA,
        TSMETA_SUMMARY,
        TSUIDS,
        UIDMETA,
        ANNOTATION,
        LOOKUP;

    }
}

