/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.search;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import com.stumbleupon.async.DeferredGroupException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.opentsdb.core.Const;
import net.opentsdb.core.Internal;
import net.opentsdb.core.RowKey;
import net.opentsdb.core.TSDB;
import net.opentsdb.core.Tags;
import net.opentsdb.meta.TSMeta;
import net.opentsdb.query.QueryUtil;
import net.opentsdb.search.SearchQuery;
import net.opentsdb.uid.NoSuchUniqueId;
import net.opentsdb.uid.NoSuchUniqueName;
import net.opentsdb.uid.UniqueId;
import net.opentsdb.utils.ByteArrayPair;
import net.opentsdb.utils.Exceptions;
import net.opentsdb.utils.Pair;
import org.hbase.async.Bytes;
import org.hbase.async.KeyValue;
import org.hbase.async.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeriesLookup {
    private static final Logger LOG = LoggerFactory.getLogger(TimeSeriesLookup.class);
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private final SearchQuery query;
    private boolean to_stdout;
    private final TSDB tsdb;
    private byte[] metric_uid;
    private List<ByteArrayPair> pairs;
    private String rowkey_regex;
    private String tagv_filter;
    private final List<byte[]> tsuids;

    public TimeSeriesLookup(TSDB tsdb, SearchQuery query) {
        this.tsdb = tsdb;
        this.query = query;
        this.tsuids = Collections.synchronizedList(new ArrayList());
    }

    public List<byte[]> lookup() {
        try {
            return (List)this.lookupAsync().join();
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted performing lookup", (Throwable)e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (DeferredGroupException e) {
            Throwable ex = Exceptions.getCause(e);
            if (ex instanceof NoSuchUniqueName) {
                throw (NoSuchUniqueName)ex;
            }
            throw new RuntimeException("Unexpected exception", ex);
        }
        catch (NoSuchUniqueName e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public Deferred<List<byte[]>> lookupAsync() {
        final Pattern tagv_regex = this.tagv_filter != null ? Pattern.compile(this.tagv_filter) : null;
        final StringBuffer buf = this.to_stdout ? new StringBuffer(2048) : null;
        final long start = System.currentTimeMillis();
        final int limit = this.query.getLimit() > 0 ? (this.query.useMeta() || Const.SALT_WIDTH() < 1 ? this.query.getLimit() : (this.query.getLimit() < Const.SALT_BUCKETS() ? 1 : this.query.getLimit() / Const.SALT_BUCKETS())) : 0;
        class UIDCB
        implements Callback<Deferred<List<byte[]>>, Object> {
            UIDCB() {
            }

            public Deferred<List<byte[]>> call(Object arg0) throws Exception {
                class ScannerCB
                implements Callback<Deferred<List<byte[]>>, ArrayList<ArrayList<KeyValue>>> {
                    private final Scanner scanner;
                    private byte[] last_tsuid = null;
                    private int rows_read;
                    final /* synthetic */ long val$start;
                    final /* synthetic */ int val$limit;
                    final /* synthetic */ Pattern val$tagv_regex;
                    final /* synthetic */ StringBuffer val$buf;

                    ScannerCB(Scanner scanner) {
                        this.val$start = l;
                        this.val$limit = n;
                        this.val$tagv_regex = pattern;
                        this.val$buf = stringBuffer;
                        this.scanner = scanner;
                    }

                    Deferred<List<byte[]>> scan() {
                        return this.scanner.nextRows().addCallbackDeferring((Callback)this);
                    }

                    public Deferred<List<byte[]>> call(ArrayList<ArrayList<KeyValue>> rows) throws Exception {
                        if (rows == null) {
                            this.scanner.close();
                            if (TimeSeriesLookup.this.query.useMeta() || Const.SALT_WIDTH() < 1) {
                                LOG.debug("Lookup query matched " + TimeSeriesLookup.this.tsuids.size() + " time series in " + (System.currentTimeMillis() - this.val$start) + " ms");
                            }
                            return Deferred.fromResult((Object)TimeSeriesLookup.this.tsuids);
                        }
                        for (ArrayList<KeyValue> row : rows) {
                            byte[] tsuid;
                            if (this.val$limit > 0 && this.rows_read >= this.val$limit) {
                                return this.call(null);
                            }
                            byte[] byArray = tsuid = TimeSeriesLookup.this.query.useMeta() ? row.get(0).key() : UniqueId.getTSUIDFromKey(row.get(0).key(), TSDB.metrics_width(), (short)4);
                            if (this.val$tagv_regex != null && !this.val$tagv_regex.matcher(new String(tsuid, CHARSET)).find()) continue;
                            if (TimeSeriesLookup.this.to_stdout) {
                                if (this.last_tsuid != null && Bytes.memcmp((byte[])this.last_tsuid, (byte[])tsuid) == 0) continue;
                                this.last_tsuid = tsuid;
                                try {
                                    this.val$buf.append(UniqueId.uidToString(tsuid)).append(" ");
                                    this.val$buf.append((String)RowKey.metricNameAsync(TimeSeriesLookup.this.tsdb, tsuid).joinUninterruptibly());
                                    this.val$buf.append(" ");
                                    List<byte[]> tag_ids = UniqueId.getTagPairsFromTSUID(tsuid);
                                    Map resolved_tags = (Map)Tags.resolveIdsAsync(TimeSeriesLookup.this.tsdb, tag_ids).joinUninterruptibly();
                                    for (Map.Entry tag_pair : resolved_tags.entrySet()) {
                                        this.val$buf.append((String)tag_pair.getKey()).append("=").append((String)tag_pair.getValue()).append(" ");
                                    }
                                }
                                catch (NoSuchUniqueId nsui) {
                                    LOG.error("Unable to resolve UID in TSUID (" + UniqueId.uidToString(tsuid) + ") " + nsui.getMessage());
                                }
                                this.val$buf.setLength(0);
                            } else {
                                TimeSeriesLookup.this.tsuids.add(tsuid);
                            }
                            ++this.rows_read;
                        }
                        return this.scan();
                    }

                    public String toString() {
                        return "Scanner callback";
                    }
                }
                if (!TimeSeriesLookup.this.query.useMeta() && Const.SALT_WIDTH() > 0 && TimeSeriesLookup.this.metric_uid != null) {
                    ArrayList<Deferred<List<byte[]>>> deferreds = new ArrayList<Deferred<List<byte[]>>>(Const.SALT_BUCKETS());
                    for (int i = 0; i < Const.SALT_BUCKETS(); ++i) {
                        deferreds.add(new ScannerCB(TimeSeriesLookup.this, TimeSeriesLookup.this.getScanner(i), start, limit, tagv_regex, buf).scan());
                    }
                    class CompleteCB
                    implements Callback<List<byte[]>, ArrayList<List<byte[]>>> {
                        final /* synthetic */ long val$start;

                        CompleteCB() {
                            this.val$start = l;
                        }

                        public List<byte[]> call(ArrayList<List<byte[]>> unused) throws Exception {
                            LOG.debug("Lookup query matched " + TimeSeriesLookup.this.tsuids.size() + " time series in " + (System.currentTimeMillis() - this.val$start) + " ms");
                            return TimeSeriesLookup.this.tsuids;
                        }

                        public String toString() {
                            return "Final async lookup callback";
                        }
                    }
                    return Deferred.group(deferreds).addCallback((Callback)new CompleteCB(TimeSeriesLookup.this, start));
                }
                return new ScannerCB(TimeSeriesLookup.this, TimeSeriesLookup.this.getScanner(0), start, limit, tagv_regex, buf).scan();
            }

            public String toString() {
                return "UID resolution callback";
            }
        }
        return this.resolveUIDs().addCallbackDeferring((Callback)new UIDCB());
    }

    private Deferred<Object> resolveUIDs() {
        if (this.query.getMetric() != null && !this.query.getMetric().isEmpty() && !this.query.getMetric().equals("*")) {
            class MetricCB
            implements Callback<Deferred<Object>, byte[]> {
                MetricCB() {
                }

                public Deferred<Object> call(byte[] uid) throws Exception {
                    TimeSeriesLookup.access$602(TimeSeriesLookup.this, uid);
                    LOG.debug("Found UID (" + UniqueId.uidToString(TimeSeriesLookup.this.metric_uid) + ") for metric (" + TimeSeriesLookup.this.query.getMetric() + ")");
                    class TagResolution
                    implements Callback<Deferred<Object>, Object> {
                        TagResolution() {
                        }

                        public Deferred<Object> call(Object unused) throws Exception {
                            if (TimeSeriesLookup.this.query.getTags() == null || TimeSeriesLookup.this.query.getTags().isEmpty()) {
                                return Deferred.fromResult(null);
                            }
                            TimeSeriesLookup.this.pairs = Collections.synchronizedList(new ArrayList(TimeSeriesLookup.this.query.getTags().size()));
                            ArrayList<Deferred> deferreds = new ArrayList<Deferred>(TimeSeriesLookup.this.pairs.size());
                            for (Pair<String, String> tags : TimeSeriesLookup.this.query.getTags()) {
                                ArrayList<Object> deferred_tags = new ArrayList<Object>(2);
                                if (tags.getKey() != null && !tags.getKey().equals("*")) {
                                    deferred_tags.add(TimeSeriesLookup.this.tsdb.getUIDAsync(UniqueId.UniqueIdType.TAGK, tags.getKey()));
                                } else {
                                    deferred_tags.add(Deferred.fromResult(null));
                                }
                                if (tags.getValue() != null && !tags.getValue().equals("*")) {
                                    deferred_tags.add(TimeSeriesLookup.this.tsdb.getUIDAsync(UniqueId.UniqueIdType.TAGV, tags.getValue()));
                                } else {
                                    deferred_tags.add(Deferred.fromResult(null));
                                }
                                class PairResolution
                                implements Callback<Object, ArrayList<byte[]>> {
                                    PairResolution() {
                                    }

                                    public Object call(ArrayList<byte[]> tags) throws Exception {
                                        if (tags.size() < 2) {
                                            throw new IllegalArgumentException("Somehow we received an array that wasn't two bytes in size! " + tags);
                                        }
                                        TimeSeriesLookup.this.pairs.add(new ByteArrayPair(tags.get(0), tags.get(1)));
                                        return Deferred.fromResult(null);
                                    }
                                }
                                deferreds.add(Deferred.groupInOrder(deferred_tags).addCallback((Callback)new PairResolution()));
                            }
                            class TagsCB
                            implements Callback<Object, ArrayList<Object>> {
                                TagsCB() {
                                }

                                public Object call(ArrayList<Object> ignored) throws Exception {
                                    TimeSeriesLookup.this.rowkey_regex = TimeSeriesLookup.this.getRowKeyRegex();
                                    return null;
                                }
                            }
                            return Deferred.group(deferreds).addCallback((Callback)new TagsCB());
                        }
                    }
                    return new TagResolution().call(null);
                }
            }
            return this.tsdb.getUIDAsync(UniqueId.UniqueIdType.METRIC, this.query.getMetric()).addCallbackDeferring((Callback)new MetricCB());
        }
        try {
            return new TagResolution().call(null);
        }
        catch (Exception e) {
            return Deferred.fromError((Exception)e);
        }
    }

    private Scanner getScanner(int salt) {
        Scanner scanner = this.tsdb.getClient().newScanner(this.query.useMeta() ? this.tsdb.metaTable() : this.tsdb.dataTable());
        scanner.setFamily(this.query.useMeta() ? TSMeta.FAMILY : TSDB.FAMILY());
        if (this.metric_uid != null) {
            byte[] key;
            if (this.query.useMeta() || Const.SALT_WIDTH() < 1) {
                key = this.metric_uid;
            } else {
                key = new byte[Const.SALT_WIDTH() + TSDB.metrics_width()];
                System.arraycopy(RowKey.getSaltBytes(salt), 0, key, 0, Const.SALT_WIDTH());
                System.arraycopy(this.metric_uid, 0, key, Const.SALT_WIDTH(), this.metric_uid.length);
            }
            scanner.setStartKey(key);
            long uid = UniqueId.uidToLong(this.metric_uid, TSDB.metrics_width());
            if (++uid < Internal.getMaxUnsignedValueOnBytes(TSDB.metrics_width())) {
                if (this.query.useMeta() || Const.SALT_WIDTH() < 1) {
                    key = UniqueId.longToUID(uid, TSDB.metrics_width());
                } else {
                    key = new byte[Const.SALT_WIDTH() + TSDB.metrics_width()];
                    System.arraycopy(RowKey.getSaltBytes(salt), 0, key, 0, Const.SALT_WIDTH());
                    System.arraycopy(UniqueId.longToUID(uid, TSDB.metrics_width()), 0, key, Const.SALT_WIDTH(), this.metric_uid.length);
                }
                scanner.setStopKey(key);
            }
        }
        if (this.rowkey_regex != null) {
            scanner.setKeyRegexp(this.rowkey_regex, CHARSET);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanner regex: " + QueryUtil.byteRegexToString(this.rowkey_regex));
            }
        }
        return scanner;
    }

    private String getRowKeyRegex() {
        StringBuilder tagv_buffer = new StringBuilder();
        Collections.sort(this.pairs);
        short name_width = TSDB.tagk_width();
        short value_width = TSDB.tagv_width();
        short tagsize = (short)(name_width + value_width);
        int index = 0;
        StringBuilder buf = new StringBuilder(22 + (13 + tagsize) * this.pairs.size());
        buf.append("(?s)^.{").append(this.query.useMeta() ? TSDB.metrics_width() : TSDB.metrics_width() + Const.SALT_WIDTH()).append("}");
        if (!this.query.useMeta()) {
            buf.append("(?:.{").append(4).append("})*");
        }
        buf.append("(?:.{").append(tagsize).append("})*");
        while (index < this.pairs.size() && this.pairs.get(index).getKey() == null) {
            if (index > 0) {
                buf.append("|");
            }
            buf.append("(?:.{").append(name_width).append("})");
            buf.append("\\Q");
            QueryUtil.addId(buf, (byte[])this.pairs.get(index).getValue(), true);
            ++index;
        }
        buf.append("(?:.{").append(tagsize).append("})*").append("$");
        if (index > 0 && index < this.pairs.size()) {
            tagv_buffer.append(buf.toString());
            LOG.debug("Setting tagv filter: " + QueryUtil.byteRegexToString(buf.toString()));
        } else if (index >= this.pairs.size()) {
            LOG.debug("Setting scanner row key filter with tagvs only: " + QueryUtil.byteRegexToString(buf.toString()));
            if (tagv_buffer.length() > 0) {
                this.tagv_filter = tagv_buffer.toString();
            }
            return buf.toString();
        }
        if (index < this.pairs.size()) {
            buf.setLength(0);
            buf.append("(?s)^.{").append(this.query.useMeta() ? TSDB.metrics_width() : TSDB.metrics_width() + Const.SALT_WIDTH()).append("}");
            if (!this.query.useMeta()) {
                buf.append("(?:.{").append(4).append("})");
            }
            Pair last_pair = null;
            while (index < this.pairs.size()) {
                if (last_pair != null && last_pair.getValue() == null && Bytes.memcmp((byte[])((byte[])last_pair.getKey()), (byte[])((byte[])this.pairs.get(index).getKey())) == 0) {
                    LOG.debug("Skipping pair due to wildcard: " + this.pairs.get(index));
                } else if (last_pair != null && Bytes.memcmp((byte[])((byte[])last_pair.getKey()), (byte[])((byte[])this.pairs.get(index).getKey())) == 0) {
                    buf.append("|\\Q");
                    QueryUtil.addId(buf, (byte[])this.pairs.get(index).getKey(), false);
                    QueryUtil.addId(buf, (byte[])this.pairs.get(index).getValue(), true);
                } else {
                    if (last_pair != null) {
                        buf.append(")");
                    }
                    buf.append("(?:.{").append(tagsize).append("})*");
                    buf.append("(?:");
                    if (this.pairs.get(index).getKey() != null && this.pairs.get(index).getValue() != null) {
                        buf.append("\\Q");
                        QueryUtil.addId(buf, (byte[])this.pairs.get(index).getKey(), false);
                        QueryUtil.addId(buf, (byte[])this.pairs.get(index).getValue(), true);
                    } else {
                        buf.append("\\Q");
                        QueryUtil.addId(buf, (byte[])this.pairs.get(index).getKey(), true);
                        buf.append("(?:.{").append(value_width).append("})");
                    }
                }
                last_pair = this.pairs.get(index);
                ++index;
            }
            buf.append(")(?:.{").append(tagsize).append("})*").append("$");
        }
        if (tagv_buffer.length() > 0) {
            this.tagv_filter = tagv_buffer.toString();
        }
        return buf.toString();
    }

    public void setToStdout(boolean to_stdout) {
        this.to_stdout = to_stdout;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("query={").append(this.query).append("}, to_stdout=").append(this.to_stdout).append(", metric_uid=").append(this.metric_uid == null ? "null" : Arrays.toString(this.metric_uid)).append(", pairs=").append(this.pairs).append(", rowkey_regex=").append(this.rowkey_regex).append(", tagv_filter=").append(this.tagv_filter);
        return buf.toString();
    }

    static /* synthetic */ byte[] access$602(TimeSeriesLookup x0, byte[] x1) {
        x0.metric_uid = x1;
        return x1;
    }
}

