/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.stats;

import java.util.Arrays;

public final class Histogram {
    private final short interval;
    private final int cutoff;
    private final short num_linear_buckets;
    private final short exp_bucket_shift;
    private final int[] buckets;

    public Histogram(int max, short interval, int cutoff) {
        if (interval > max) {
            throw new IllegalArgumentException("interval > max! interval=" + interval + ", max=" + max);
        }
        if (cutoff > max) {
            throw new IllegalArgumentException("cutoff > max! cutoff=" + cutoff + ", max=" + max);
        }
        if (interval < 1) {
            throw new IllegalArgumentException("interval < 1! interval=" + interval);
        }
        if (cutoff < 0) {
            throw new IllegalArgumentException("cutoff < 0! interval=" + cutoff);
        }
        this.interval = interval;
        this.num_linear_buckets = (short)(cutoff / interval);
        this.cutoff = this.num_linear_buckets * interval;
        this.exp_bucket_shift = (short)Histogram.log2rounddown(interval);
        this.buckets = new int[this.num_linear_buckets + Histogram.log2roundup(max - cutoff >> this.exp_bucket_shift) + 1];
    }

    static final int log2roundup(int n) {
        int log2 = 0;
        while (n > 1 << log2) {
            ++log2;
        }
        return log2;
    }

    static final int log2rounddown(int n) {
        int log2 = 0;
        while (n > 1) {
            n >>>= 1;
            ++log2;
        }
        return log2;
    }

    public int buckets() {
        return this.buckets.length;
    }

    public void add(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("negative value: " + value);
        }
        int n = this.bucketIndexFor(value);
        this.buckets[n] = this.buckets[n] + 1;
    }

    public int percentile(int p) {
        int i;
        if (p < 1 || p > 100) {
            throw new IllegalArgumentException("invalid percentile: " + p);
        }
        int count = 0;
        for (i = 0; i < this.buckets.length; ++i) {
            count += this.buckets[i];
        }
        if (count == 0) {
            return 0;
        }
        p = count * p / 100;
        for (i = this.buckets.length - 1; i >= 0; --i) {
            if ((count -= this.buckets[i]) > p) continue;
            return this.bucketHighInterval(i);
        }
        return 0;
    }

    public void printAscii(StringBuilder out) {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.printAsciiBucket(out, i);
        }
    }

    final void printAsciiBucket(StringBuilder out, int i) {
        out.append('[').append(this.bucketLowInterval(i)).append('-').append(i == this.buckets.length - 1 ? "Inf" : Integer.valueOf(this.bucketHighInterval(i))).append("): ").append(this.buckets[i]).append('\n');
    }

    final int valueInBucket(int index) {
        return this.buckets[index];
    }

    private int bucketIndexFor(int value) {
        if (value < this.cutoff) {
            return value / this.interval;
        }
        int bucket = this.num_linear_buckets + Histogram.log2rounddown(value - this.cutoff >> this.exp_bucket_shift);
        if (bucket >= this.buckets.length) {
            return this.buckets.length - 1;
        }
        return bucket;
    }

    private int bucketLowInterval(int index) {
        if (index <= this.num_linear_buckets) {
            return index * this.interval;
        }
        return this.cutoff + (1 << index - this.num_linear_buckets + this.exp_bucket_shift);
    }

    private int bucketHighInterval(int index) {
        if (index == this.buckets.length - 1) {
            return Integer.MAX_VALUE;
        }
        return this.bucketLowInterval(index + 1);
    }

    public String toString() {
        return "Histogram(interval=" + this.interval + ", cutoff=" + this.cutoff + ", num_linear_buckets=" + this.num_linear_buckets + ", exp_bucket_shift=" + this.exp_bucket_shift + ", buckets=" + Arrays.toString(this.buckets) + ')';
    }
}

