/*
 * Decompiled with CFR 0.152.
 */
package net.opentsdb.stats;

import com.google.common.base.Objects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.opentsdb.core.Const;
import net.opentsdb.core.QueryException;
import net.opentsdb.core.TSQuery;
import net.opentsdb.stats.StatsCollector;
import net.opentsdb.utils.DateTime;
import net.opentsdb.utils.JSON;
import net.opentsdb.utils.Pair;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryStats {
    private static final Logger LOG = LoggerFactory.getLogger(QueryStats.class);
    private static final Logger QUERY_LOG = LoggerFactory.getLogger((String)"QueryLog");
    private static int COMPLETED_QUERY_CACHE_SIZE = 256;
    private static boolean ENABLE_DUPLICATES = true;
    private static ConcurrentHashMap<Integer, QueryStats> running_queries = new ConcurrentHashMap();
    private static Cache<Integer, QueryStats> completed_queries = CacheBuilder.newBuilder().maximumSize((long)COMPLETED_QUERY_CACHE_SIZE).build();
    private final long query_start_ns;
    private final long query_start_ms;
    private long query_completed_ts;
    private final String remote_address;
    private final TSQuery query;
    private HttpResponseStatus response;
    private Throwable exception;
    private long executed;
    private String user;
    private final Map<QueryStat, Long> overall_stats;
    private final Map<Integer, Map<QueryStat, Long>> query_stats;
    private final Map<Integer, Map<Integer, Map<QueryStat, Long>>> scanner_stats;
    private final Map<Integer, Map<Integer, Set<String>>> scanner_servers;
    private final Map<Integer, Map<Integer, String>> scanner_ids;
    private final Map<String, String> headers;
    private boolean sent_to_client;
    static final Map<QueryStat, Pair<QueryStat, QueryStat>> AGG_MAP = new HashMap<QueryStat, Pair<QueryStat, QueryStat>>();

    public QueryStats(String remote_address, TSQuery query, Map<String, String> headers) {
        if (remote_address == null || remote_address.isEmpty()) {
            throw new IllegalArgumentException("Remote address was null or empty");
        }
        if (query == null) {
            throw new IllegalArgumentException("Query object was null");
        }
        this.remote_address = remote_address;
        this.query = query;
        this.headers = headers;
        this.executed = 1L;
        this.query_start_ns = DateTime.nanoTime();
        this.query_start_ms = DateTime.currentTimeMillis();
        this.overall_stats = new HashMap<QueryStat, Long>();
        this.query_stats = new ConcurrentHashMap<Integer, Map<QueryStat, Long>>(1);
        this.scanner_stats = new ConcurrentHashMap<Integer, Map<Integer, Map<QueryStat, Long>>>(1);
        this.scanner_servers = new ConcurrentHashMap<Integer, Map<Integer, Set<String>>>(1);
        this.scanner_ids = new ConcurrentHashMap<Integer, Map<Integer, String>>(1);
        if (LOG.isDebugEnabled()) {
            LOG.debug("New query for remote " + remote_address + " with hash " + this.hashCode() + " on thread " + Thread.currentThread().getId());
        }
        if (running_queries.putIfAbsent(this.hashCode(), this) != null) {
            if (ENABLE_DUPLICATES) {
                LOG.warn("Query " + query + " is already executing for endpoint: " + remote_address);
            } else {
                throw new QueryException("Query is already executing for endpoint: " + remote_address);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully put new query for remote " + remote_address + " with hash " + this.hashCode() + " on thread " + Thread.currentThread().getId() + " w q " + query.toString());
        }
        LOG.info("Executing new query=" + JSON.serializeToString(this));
    }

    public int hashCode() {
        return this.remote_address.hashCode() ^ this.query.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryStats)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        QueryStats stats = (QueryStats)obj;
        return Objects.equal((Object)this.remote_address, (Object)stats.remote_address) && Objects.equal((Object)this.query, (Object)stats.query);
    }

    public String toString() {
        HashMap<String, Object> details = new HashMap<String, Object>();
        details.put("queryStartTimestamp", this.getQueryStartTimestamp());
        details.put("queryCompletedTimestamp", this.getQueryCompletedTimestamp());
        details.put("exception", this.getException());
        details.put("httpResponse", this.getHttpResponse());
        details.put("numRunningQueries", this.getNumRunningQueries());
        details.put("query", this.getQuery());
        details.put("user", this.getUser());
        details.put("requestHeaders", this.getRequestHeaders());
        details.put("executed", this.getExecuted());
        details.put("stats", this.getStats(true, true));
        return JSON.serializeToString(details);
    }

    public void markSerializationSuccessful() {
        this.markSerialized(HttpResponseStatus.OK, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markSerialized(HttpResponseStatus response, Throwable exception) {
        this.exception = exception;
        this.response = response;
        this.query_completed_ts = DateTime.currentTimeMillis();
        this.overall_stats.put(QueryStat.PROCESSING_PRE_WRITE_TIME, DateTime.nanoTime() - this.query_start_ns);
        ConcurrentHashMap<Integer, QueryStats> concurrentHashMap = running_queries;
        synchronized (concurrentHashMap) {
            if (!running_queries.containsKey(this.hashCode()) && !ENABLE_DUPLICATES) {
                LOG.warn("Query was already marked as complete: " + this);
            }
            running_queries.remove(this.hashCode());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Removed completed query " + this.remote_address + " with hash " + this.hashCode() + " on thread " + Thread.currentThread().getId());
            }
        }
        this.aggQueryStats();
        int cache_hash = this.hashCode() ^ response.toString().hashCode();
        Cache<Integer, QueryStats> cache = completed_queries;
        synchronized (cache) {
            QueryStats old_query = (QueryStats)completed_queries.getIfPresent((Object)cache_hash);
            if (old_query == null) {
                completed_queries.put((Object)cache_hash, (Object)this);
            } else {
                ++old_query.executed;
            }
        }
    }

    public void markSent() {
        this.sent_to_client = true;
        this.overall_stats.put(QueryStat.TOTAL_TIME, DateTime.nanoTime() - this.query_start_ns);
        LOG.info("Completing query=" + JSON.serializeToString(this));
        QUERY_LOG.info(this.toString());
    }

    public void markSendFailed() {
        this.overall_stats.put(QueryStat.TOTAL_TIME, DateTime.nanoTime() - this.query_start_ns);
        LOG.info("Completing query=" + JSON.serializeToString(this));
        QUERY_LOG.info(this.toString());
    }

    public static Map<String, Object> getRunningAndCompleteStats() {
        TreeMap<String, Object> root = new TreeMap<String, Object>();
        if (running_queries.isEmpty()) {
            root.put("running", Collections.emptyList());
        } else {
            ArrayList running = new ArrayList(running_queries.size());
            root.put("running", running);
            for (QueryStats stats : running_queries.values()) {
                HashMap<String, Object> obj = new HashMap<String, Object>(10);
                obj.put("query", stats.query);
                obj.put("remote", stats.remote_address);
                obj.put("user", stats.user);
                obj.put("headers", stats.headers);
                obj.put("queryStart", stats.query_start_ms);
                obj.put("elapsed", DateTime.msFromNanoDiff(DateTime.nanoTime(), stats.query_start_ns));
                running.add(obj);
            }
        }
        ConcurrentMap completed = completed_queries.asMap();
        if (completed.isEmpty()) {
            root.put("completed", Collections.emptyList());
        } else {
            root.put("completed", completed.values());
        }
        return root;
    }

    public static void collectStats(StatsCollector collector) {
        collector.record("query.count", running_queries.size(), "type=running");
    }

    public void addStat(QueryStat name, long value) {
        this.overall_stats.put(name, value);
    }

    public void addStat(int query_index, QueryStat name, long value) {
        Map<QueryStat, Long> qs = this.query_stats.get(query_index);
        if (qs == null) {
            qs = new HashMap<QueryStat, Long>();
            this.query_stats.put(query_index, qs);
        }
        qs.put(name, value);
    }

    public void aggQueryStats() {
        HashMap<QueryStat, Pair<Long, Long>> overall_cumulations = new HashMap<QueryStat, Pair<Long, Long>>();
        for (Map.Entry<Integer, Map<Integer, Map<QueryStat, Long>>> entry : this.scanner_stats.entrySet()) {
            int query_index = entry.getKey();
            HashMap<QueryStat, Pair<Long, Long>> cumulations = new HashMap<QueryStat, Pair<Long, Long>>();
            for (Map.Entry<Integer, Map<QueryStat, Long>> entry2 : entry.getValue().entrySet()) {
                for (Map.Entry<QueryStat, Long> stat : entry2.getValue().entrySet()) {
                    if (stat.getKey().is_time) {
                        if (!AGG_MAP.containsKey((Object)stat.getKey())) continue;
                        Pair<Long, Long> pair = (Pair<Long, Long>)cumulations.get((Object)stat.getKey());
                        if (pair == null) {
                            pair = new Pair<Long, Long>(0L, Long.MIN_VALUE);
                            cumulations.put(stat.getKey(), pair);
                        }
                        pair.setKey((Long)pair.getKey() + stat.getValue());
                        if (stat.getValue() > pair.getValue()) {
                            pair.setValue(stat.getValue());
                        }
                        if ((pair = (Pair<Long, Long>)overall_cumulations.get((Object)stat.getKey())) == null) {
                            pair = new Pair<Long, Long>(0L, Long.MIN_VALUE);
                            overall_cumulations.put(stat.getKey(), pair);
                        }
                        pair.setKey((Long)pair.getKey() + stat.getValue());
                        if (stat.getValue() <= pair.getValue()) continue;
                        pair.setValue(stat.getValue());
                        continue;
                    }
                    this.updateStat(query_index, stat.getKey(), stat.getValue());
                }
            }
            for (Map.Entry<Integer, Map<QueryStat, Long>> entry3 : cumulations.entrySet()) {
                Pair<QueryStat, QueryStat> names = AGG_MAP.get(entry3.getKey());
                this.addStat(query_index, names.getKey(), (Long)((Pair)((Object)entry3.getValue())).getKey() / (long)entry.getValue().size());
                this.addStat(query_index, names.getValue(), (Long)((Pair)((Object)entry3.getValue())).getValue());
            }
        }
        for (Map.Entry<Integer, Map<Integer, Map<QueryStat, Long>>> entry : overall_cumulations.entrySet()) {
            Pair<QueryStat, QueryStat> names = AGG_MAP.get(entry.getKey());
            this.addStat(names.getKey(), (Long)((Pair)((Object)entry.getValue())).getKey() / (long)(this.scanner_stats.size() * Const.SALT_WIDTH() > 0 ? Const.SALT_BUCKETS() : 1));
            this.addStat(names.getValue(), (Long)((Pair)((Object)entry.getValue())).getValue());
        }
        overall_cumulations.clear();
        for (Map map : this.query_stats.values()) {
            for (Map.Entry stat : map.entrySet()) {
                if (((QueryStat)((Object)stat.getKey())).is_time) {
                    if (!AGG_MAP.containsKey(stat.getKey())) continue;
                    Pair<Long, Long> pair = (Pair<Long, Long>)overall_cumulations.get(stat.getKey());
                    if (pair == null) {
                        pair = new Pair<Long, Long>(0L, Long.MIN_VALUE);
                        overall_cumulations.put((QueryStat)((Object)stat.getKey()), pair);
                    }
                    pair.setKey((Long)pair.getKey() + (Long)stat.getValue());
                    if ((Long)stat.getValue() <= pair.getValue()) continue;
                    pair.setValue((Long)stat.getValue());
                    continue;
                }
                if (this.overall_stats.containsKey(stat.getKey())) {
                    this.overall_stats.put((QueryStat)((Object)stat.getKey()), this.overall_stats.get(stat.getKey()) + (Long)stat.getValue());
                    continue;
                }
                this.overall_stats.put((QueryStat)((Object)stat.getKey()), (Long)stat.getValue());
            }
        }
        for (Map.Entry entry : overall_cumulations.entrySet()) {
            Pair<QueryStat, QueryStat> names = AGG_MAP.get(entry.getKey());
            this.overall_stats.put(names.getKey(), (Long)((Pair)entry.getValue()).getKey() / (long)this.query_stats.size());
            this.overall_stats.put(names.getValue(), (Long)((Pair)entry.getValue()).getValue());
        }
    }

    public void updateStat(int query_index, QueryStat name, long value) {
        Map<QueryStat, Long> qs = this.query_stats.get(query_index);
        long cum_time = value;
        if (qs == null) {
            qs = new HashMap<QueryStat, Long>();
            this.query_stats.put(query_index, qs);
        }
        if (qs.containsKey((Object)name)) {
            cum_time += qs.get((Object)name).longValue();
        }
        qs.put(name, cum_time);
    }

    public void addScannerStat(int query_index, int id, QueryStat name, long value) {
        Map<QueryStat, Long> scanner_stat_map;
        Map<Integer, Map<QueryStat, Long>> qs = this.scanner_stats.get(query_index);
        if (qs == null) {
            qs = new ConcurrentHashMap<Integer, Map<QueryStat, Long>>(Const.SALT_WIDTH() > 0 ? Const.SALT_BUCKETS() : 1);
            this.scanner_stats.put(query_index, qs);
        }
        if ((scanner_stat_map = qs.get(id)) == null) {
            scanner_stat_map = new HashMap<QueryStat, Long>();
            qs.put(id, scanner_stat_map);
        }
        scanner_stat_map.put(name, value);
    }

    public void addScannerServers(int query_index, int id, Set<String> servers) {
        Map<Integer, Set<String>> query_servers = this.scanner_servers.get(query_index);
        if (query_servers == null) {
            query_servers = new ConcurrentHashMap<Integer, Set<String>>(Const.SALT_WIDTH() > 0 ? Const.SALT_BUCKETS() : 1);
            this.scanner_servers.put(query_index, query_servers);
        }
        query_servers.put(id, servers);
    }

    public void updateScannerStat(int query_index, int id, QueryStat name, long value) {
        Map<QueryStat, Long> scanner_stat_map;
        Map<Integer, Map<QueryStat, Long>> qs = this.scanner_stats.get(query_index);
        long cum_time = value;
        if (qs == null) {
            qs = new ConcurrentHashMap<Integer, Map<QueryStat, Long>>();
            this.scanner_stats.put(query_index, qs);
        }
        if ((scanner_stat_map = qs.get(id)) == null) {
            scanner_stat_map = new HashMap<QueryStat, Long>();
            qs.put(id, scanner_stat_map);
        }
        if (scanner_stat_map.containsKey((Object)name)) {
            cum_time += scanner_stat_map.get((Object)name).longValue();
        }
        scanner_stat_map.put(name, cum_time);
    }

    public void addScannerId(int query_index, int id, String string_id) {
        Map<Integer, String> scanners = this.scanner_ids.get(query_index);
        if (scanners == null) {
            scanners = new ConcurrentHashMap<Integer, String>();
            this.scanner_ids.put(query_index, scanners);
        }
        scanners.put(id, string_id);
    }

    public long queryStart() {
        return this.query_start_ns;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getRequestHeaders() {
        return this.headers;
    }

    public int getNumRunningQueries() {
        return running_queries.size();
    }

    public String getException() {
        if (this.exception == null) {
            return "null";
        }
        return this.exception.getMessage() + (this.exception.getStackTrace() != null && this.exception.getStackTrace().length > 0 ? "\n" + this.exception.getStackTrace()[0].toString() : "");
    }

    public HttpResponseStatus getHttpResponse() {
        return this.response;
    }

    public long getExecuted() {
        return this.executed;
    }

    public TSQuery getQuery() {
        return this.query;
    }

    public long getQueryStartTimestamp() {
        return this.query_start_ms;
    }

    public long getQueryCompletedTimestamp() {
        return this.query_completed_ts;
    }

    public boolean getSentToClient() {
        return this.sent_to_client;
    }

    public Map<String, Object> getStats() {
        return this.getStats(false, false);
    }

    public Map<String, Object> getStats(boolean with_sub_queries, boolean with_scanners) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Map.Entry<QueryStat, Long> entry : this.overall_stats.entrySet()) {
            if (entry.getKey().is_time) {
                map.put(entry.getKey().toString(), DateTime.msFromNano(entry.getValue()));
                continue;
            }
            map.put(entry.getKey().toString(), entry.getValue());
        }
        if (with_sub_queries) {
            for (Map.Entry<Integer, Map<QueryStat, Long>> entry : this.query_stats.entrySet()) {
                HashMap<String, Map<String, Object>> qs = new HashMap<String, Map<String, Object>>(1);
                qs.put(String.format("queryIdx_%02d", entry.getKey()), this.getQueryStats(entry.getKey(), with_scanners));
                map.putAll(qs);
            }
        }
        return map;
    }

    public Map<String, Object> getQueryStats(int index, boolean with_scanners) {
        Map<QueryStat, Long> qs = this.query_stats.get(index);
        if (qs == null) {
            return null;
        }
        TreeMap<String, Object> query_map = new TreeMap<String, Object>();
        query_map.put("queryIndex", index);
        for (Map.Entry<QueryStat, Long> stat : qs.entrySet()) {
            if (stat.getKey().is_time) {
                query_map.put(stat.getKey().toString(), DateTime.msFromNano(stat.getValue()));
                continue;
            }
            query_map.put(stat.getKey().toString(), stat.getValue());
        }
        if (with_scanners) {
            Map<Integer, Map<QueryStat, Long>> scanner_stats_map = this.scanner_stats.get(index);
            TreeMap scanner_maps = new TreeMap();
            query_map.put("scannerStats", scanner_maps);
            if (scanner_stats_map != null) {
                Map<Integer, String> scanners = this.scanner_ids.get(index);
                for (Map.Entry<Integer, Map<QueryStat, Long>> scanner : scanner_stats_map.entrySet()) {
                    TreeMap<String, Object> scanner_map = new TreeMap<String, Object>();
                    scanner_maps.put(String.format("scannerIdx_%02d", scanner.getKey()), scanner_map);
                    String id = scanners != null ? scanners.get(scanner.getKey()) : null;
                    scanner_map.put("scannerId", id);
                    for (Map.Entry<QueryStat, Long> scanner_stats : scanner.getValue().entrySet()) {
                        if (!scanner_stats.getKey().is_time) {
                            scanner_map.put(scanner_stats.getKey().toString(), scanner_stats.getValue());
                            continue;
                        }
                        scanner_map.put(scanner_stats.getKey().toString(), DateTime.msFromNano(scanner_stats.getValue()));
                    }
                }
            }
        }
        return query_map;
    }

    public long getStat(QueryStat stat) {
        if (!this.overall_stats.containsKey((Object)stat)) {
            return -1L;
        }
        return this.overall_stats.get((Object)stat);
    }

    public double getTimeStat(QueryStat stat) {
        if (!stat.is_time) {
            throw new IllegalArgumentException("The stat is not a time stat");
        }
        if (!this.overall_stats.containsKey((Object)stat)) {
            return Double.NaN;
        }
        return DateTime.msFromNano(this.overall_stats.get((Object)stat));
    }

    public static void setEnableDuplicates(boolean enable_dupes) {
        ENABLE_DUPLICATES = enable_dupes;
    }

    static {
        AGG_MAP.put(QueryStat.HBASE_TIME, new Pair<QueryStat, QueryStat>(QueryStat.AVG_HBASE_TIME, QueryStat.MAX_HBASE_TIME));
        AGG_MAP.put(QueryStat.SCANNER_TIME, new Pair<QueryStat, QueryStat>(QueryStat.AVG_SALT_SCANNER_TIME, QueryStat.MAX_HBASE_TIME));
        AGG_MAP.put(QueryStat.UID_TO_STRING_TIME, new Pair<QueryStat, QueryStat>(QueryStat.MAX_UID_TO_STRING, QueryStat.MAX_UID_TO_STRING));
        AGG_MAP.put(QueryStat.SCANNER_UID_TO_STRING_TIME, new Pair<QueryStat, QueryStat>(QueryStat.MAX_SCANNER_UID_TO_STRING_TIME, QueryStat.AVG_SCANNER_UID_TO_STRING_TIME));
        AGG_MAP.put(QueryStat.QUERY_SCAN_TIME, new Pair<QueryStat, QueryStat>(QueryStat.MAX_SCAN_TIME, QueryStat.AVG_SCAN_TIME));
        AGG_MAP.put(QueryStat.AGGREGATION_TIME, new Pair<QueryStat, QueryStat>(QueryStat.MAX_AGGREGATION_TIME, QueryStat.AVG_AGGREGATION_TIME));
        AGG_MAP.put(QueryStat.SERIALIZATION_TIME, new Pair<QueryStat, QueryStat>(QueryStat.MAX_SERIALIZATION_TIME, QueryStat.AVG_SERIALIZATION_TIME));
    }

    public static enum QueryStat {
        STRING_TO_UID_TIME("stringToUidTime", true),
        COLUMNS_FROM_STORAGE("columnsFromStorage", false),
        ROWS_FROM_STORAGE("rowsFromStorage", false),
        BYTES_FROM_STORAGE("bytesFromStorage", false),
        SUCCESSFUL_SCAN("successfulScan", false),
        DPS_PRE_FILTER("dpsPreFilter", false),
        ROWS_PRE_FILTER("rowsPreFilter", false),
        DPS_POST_FILTER("dpsPostFilter", false),
        ROWS_POST_FILTER("rowsPostFilter", false),
        SCANNER_UID_TO_STRING_TIME("scannerUidToStringTime", true),
        COMPACTION_TIME("compactionTime", true),
        HBASE_TIME("hbaseTime", true),
        UID_PAIRS_RESOLVED("uidPairsResolved", false),
        SCANNER_TIME("scannerTime", true),
        SCANNER_MERGE_TIME("saltScannerMergeTime", true),
        QUERY_SCAN_TIME("queryScanTime", true),
        GROUP_BY_TIME("groupByTime", true),
        UID_TO_STRING_TIME("uidToStringTime", true),
        AGGREGATED_SIZE("emittedDPs", false),
        NAN_DPS("nanDPs", false),
        AGGREGATION_TIME("aggregationTime", true),
        SERIALIZATION_TIME("serializationTime", true),
        PROCESSING_PRE_WRITE_TIME("processingPreWriteTime", true),
        TOTAL_TIME("totalTime", true),
        MAX_HBASE_TIME("maxHBaseTime", true),
        AVG_HBASE_TIME("avgHBaseTime", true),
        MAX_SALT_SCANNER_TIME("maxScannerTime", true),
        AVG_SALT_SCANNER_TIME("avgScannerTime", true),
        MAX_UID_TO_STRING("maxUidToStringTime", true),
        AVG_UID_TO_STRING("avgUidToStringTime", true),
        MAX_COMPACTION_TIME("maxCompactionTime", true),
        AVG_COMPACTION_TIME("avgCompactionTime", true),
        MAX_SCANNER_UID_TO_STRING_TIME("maxScannerUidtoStringTime", true),
        AVG_SCANNER_UID_TO_STRING_TIME("avgScannerUidToStringTime", true),
        MAX_SCANNER_MERGE_TIME("maxSaltScannerMergeTime", true),
        AVG_SCANNER_MERGE_TIME("avgSaltScannerMergeTime", true),
        MAX_SCAN_TIME("maxQueryScanTime", true),
        AVG_SCAN_TIME("avgQueryScanTime", true),
        MAX_AGGREGATION_TIME("maxAggregationTime", true),
        AVG_AGGREGATION_TIME("avgAggregationTime", true),
        MAX_SERIALIZATION_TIME("maxSerializationTime", true),
        AVG_SERIALIZATION_TIME("avgSerializationTime", true);

        private final String stat_name;
        private final boolean is_time;

        private QueryStat(String stat_name, boolean is_time) {
            this.stat_name = stat_name;
            this.is_time = is_time;
        }

        public String toString() {
            return this.stat_name;
        }
    }
}

